/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.locked;

import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.exousia.modules.locked.SimplePolicyConfiguration;

public class SharedState {
    private static final System.Logger LOG = System.getLogger(SharedState.class.getName());
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private static Lock rLock = rwLock.readLock();
    private static Lock wLock = rwLock.writeLock();
    private static Map<String, SimplePolicyConfiguration> configTable = new HashMap<String, SimplePolicyConfiguration>();
    private static Map<String, Set<String>> linkTable = new HashMap<String, Set<String>>();

    static SimplePolicyConfiguration lookupConfig(String pcid) {
        wLock.lock();
        try {
            SimplePolicyConfiguration simplePolicyConfiguration = configTable.get(pcid);
            return simplePolicyConfiguration;
        }
        finally {
            wLock.unlock();
        }
    }

    static SimplePolicyConfiguration getConfig(String pcid, boolean remove) {
        SimplePolicyConfiguration simplePolicyConfiguration = null;
        wLock.lock();
        try {
            simplePolicyConfiguration = configTable.get(pcid);
            if (simplePolicyConfiguration == null) {
                simplePolicyConfiguration = new SimplePolicyConfiguration(pcid);
                SharedState.initLinks(pcid);
                configTable.put(pcid, simplePolicyConfiguration);
            } else if (remove) {
                SharedState.removeLinks(pcid);
            }
        }
        finally {
            wLock.unlock();
        }
        return simplePolicyConfiguration;
    }

    static SimplePolicyConfiguration getActiveConfig() throws PolicyContextException {
        String contextId = PolicyContext.getContextID();
        SimplePolicyConfiguration simplePolicyConfiguration = null;
        if (contextId != null) {
            rLock.lock();
            try {
                simplePolicyConfiguration = configTable.get(contextId);
                if (simplePolicyConfiguration == null) {
                    LOG.log(System.Logger.Level.WARNING, "Invalid policy context id: {0}", contextId);
                }
            }
            finally {
                rLock.unlock();
            }
            if (simplePolicyConfiguration != null && !simplePolicyConfiguration.inService()) {
                LOG.log(System.Logger.Level.DEBUG, "Invalid policy context state.");
                simplePolicyConfiguration = null;
            }
        }
        return simplePolicyConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void link(String id, String otherId) throws PolicyContextException {
        wLock.lock();
        try {
            if (otherId.equals(id)) {
                throw new IllegalArgumentException("Operation attempted to link PolicyConfiguration to itself.");
            }
            Set<String> linkSet = linkTable.get(id);
            Set<String> otherLinkSet = linkTable.get(otherId);
            if (otherLinkSet == null) {
                throw new RuntimeException("Linked policy configuration (" + otherId + ") does not exist");
            }
            for (String nextid : otherLinkSet) {
                linkSet.add(nextid);
                linkTable.put(nextid, linkSet);
            }
        }
        finally {
            wLock.unlock();
        }
    }

    static void initLinks(String contextId) {
        HashSet<String> linkSet = new HashSet<String>();
        linkSet.add(contextId);
        linkTable.put(contextId, linkSet);
    }

    static void removeLinks(String contextId) {
        wLock.lock();
        try {
            Set<String> linkSet = linkTable.get(contextId);
            if (linkSet != null) {
                linkSet.remove(contextId);
                linkTable.remove(contextId);
            }
            SharedState.initLinks(contextId);
        }
        finally {
            wLock.unlock();
        }
    }
}

