/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import org.glassfish.rmic.iiop.BatchEnvironment;
import org.glassfish.rmic.iiop.CompoundType;
import org.glassfish.rmic.iiop.Constants;
import org.glassfish.rmic.iiop.NameContext;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.iiop.ValueType;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Identifier;

public class IDLNames
implements Constants {
    public static final byte[] ASCII_HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] IDL_IDENTIFIER_CHARS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1};

    public static String getMemberOrMethodName(NameContext nameContext, String name, BatchEnvironment env) {
        String result = env.namesCache.get(name);
        if (result == null) {
            result = nameContext.get(name);
            result = IDLNames.convertLeadingUnderscores(result);
            result = IDLNames.convertIDLKeywords(result);
            result = IDLNames.convertToISOLatin1(result);
            env.namesCache.put(name, result);
        }
        return result;
    }

    public static String convertToISOLatin1(String name) {
        String result = IDLNames.replace(name, "x\\u", "U");
        result = IDLNames.replace(result, "x\\U", "U");
        int length = result.length();
        StringBuffer buffer = null;
        for (int i = 0; i < length; ++i) {
            char c = result.charAt(i);
            if (c > '\u00ff' || IDL_IDENTIFIER_CHARS[c] == 0) {
                if (buffer == null) {
                    buffer = new StringBuffer(result.substring(0, i));
                }
                buffer.append("U");
                buffer.append((char)ASCII_HEX[(c & 0xF000) >>> 12]);
                buffer.append((char)ASCII_HEX[(c & 0xF00) >>> 8]);
                buffer.append((char)ASCII_HEX[(c & 0xF0) >>> 4]);
                buffer.append((char)ASCII_HEX[c & 0xF]);
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        if (buffer != null) {
            result = buffer.toString();
        }
        return result;
    }

    public static String convertIDLKeywords(String name) {
        for (String IDL_KEYWORDS1 : IDL_KEYWORDS) {
            if (!name.equalsIgnoreCase(IDL_KEYWORDS1)) continue;
            return "_" + name;
        }
        return name;
    }

    public static String convertLeadingUnderscores(String name) {
        if (name.startsWith("_")) {
            return "J" + name;
        }
        return name;
    }

    public static String getClassOrInterfaceName(Identifier id, BatchEnvironment env) throws Exception {
        String result;
        String typeName = id.getName().toString();
        String packageName = null;
        if (id.isQualified()) {
            packageName = id.getQualifier().toString();
        }
        if ((result = env.namesCache.get(typeName)) == null) {
            result = IDLNames.toInnerClassName(typeName);
            result = IDLNames.convertToISOLatin1(result);
            NameContext context = NameContext.forName(packageName, false, env);
            context.assertPut(result);
            result = IDLNames.getTypeOrModuleName(result);
            env.namesCache.put(typeName, result);
        }
        return result;
    }

    private static String toInnerClassName(String typeName) {
        if (typeName.contains(". ")) {
            return IDLNames.replace(typeName, ". ", "__");
        }
        return IDLNames.replace(typeName, "$", "__");
    }

    public static String getExceptionName(String idlName) {
        String result = idlName;
        result = idlName.endsWith("Exception") ? IDLNames.stripLeadingUnderscore(idlName.substring(0, idlName.lastIndexOf("Exception")) + "Ex") : idlName + "Ex";
        return result;
    }

    public static String[] getModuleNames(Identifier theID, boolean boxIt, BatchEnvironment env) throws Exception {
        String[] result = null;
        if (theID.isQualified()) {
            Identifier id = theID.getQualifier();
            env.modulesContext.assertPut(id.toString());
            int count = 1;
            Identifier current = id;
            while (current.isQualified()) {
                current = current.getQualifier();
                ++count;
            }
            result = new String[count];
            int index = count - 1;
            current = id;
            for (int i = 0; i < count; ++i) {
                String item = current.getName().toString();
                String cachedItem = env.namesCache.get(item);
                if (cachedItem == null) {
                    cachedItem = IDLNames.convertToISOLatin1(item);
                    cachedItem = IDLNames.getTypeOrModuleName(cachedItem);
                    env.namesCache.put(item, cachedItem);
                }
                result[index--] = cachedItem;
                current = current.getQualifier();
            }
        }
        if (boxIt) {
            if (result == null) {
                result = IDL_BOXEDIDL_MODULE;
            } else {
                String[] boxed = new String[result.length + IDL_BOXEDIDL_MODULE.length];
                System.arraycopy(IDL_BOXEDIDL_MODULE, 0, boxed, 0, IDL_BOXEDIDL_MODULE.length);
                System.arraycopy(result, 0, boxed, IDL_BOXEDIDL_MODULE.length, result.length);
                result = boxed;
            }
        }
        return result;
    }

    public static String getArrayName(Type theType, int arrayDimension) {
        StringBuilder idlName = new StringBuilder(64);
        idlName.append("seq");
        idlName.append(Integer.toString(arrayDimension));
        idlName.append("_");
        idlName.append(IDLNames.replace(IDLNames.stripLeadingUnderscore(theType.getIDLName()), " ", "_"));
        return idlName.toString();
    }

    public static String[] getArrayModuleNames(Type theType) {
        String[] moduleName;
        String[] typeModule = theType.getIDLModuleNames();
        int typeModuleLength = typeModule.length;
        if (typeModuleLength == 0) {
            moduleName = IDL_SEQUENCE_MODULE;
        } else {
            moduleName = new String[typeModuleLength + IDL_SEQUENCE_MODULE.length];
            System.arraycopy(IDL_SEQUENCE_MODULE, 0, moduleName, 0, IDL_SEQUENCE_MODULE.length);
            System.arraycopy(typeModule, 0, moduleName, IDL_SEQUENCE_MODULE.length, typeModuleLength);
        }
        return moduleName;
    }

    private static int getInitialAttributeKind(CompoundType.Method method, BatchEnvironment env) throws ClassNotFound {
        int result = 0;
        if (!method.isConstructor()) {
            boolean validExceptions = true;
            ValueType[] exceptions = method.getExceptions();
            if (exceptions.length > 0) {
                for (ValueType exception : exceptions) {
                    if (!exception.isCheckedException() || exception.isRemoteExceptionOrSubclass()) continue;
                    validExceptions = false;
                    break;
                }
            } else {
                validExceptions = method.getEnclosing().isType(32768);
            }
            if (validExceptions) {
                String name = method.getName();
                int nameLength = name.length();
                int argCount = method.getArguments().length;
                Type returnType = method.getReturnType();
                boolean voidReturn = returnType.isType(1);
                boolean booleanReturn = returnType.isType(2);
                if (name.startsWith("get") && nameLength > 3 && argCount == 0 && !voidReturn) {
                    result = 2;
                } else if (name.startsWith("is") && nameLength > 2 && argCount == 0 && booleanReturn) {
                    result = 1;
                } else if (name.startsWith("set") && nameLength > 3 && argCount == 1 && voidReturn) {
                    result = 5;
                }
            }
        }
        return result;
    }

    private static void setAttributeKinds(CompoundType.Method[] methods, int[] kinds, String[] names) {
        int i;
        int count = methods.length;
        block5: for (i = 0; i < count; ++i) {
            switch (kinds[i]) {
                case 2: {
                    names[i] = names[i].substring(3);
                    continue block5;
                }
                case 1: {
                    names[i] = names[i].substring(2);
                    continue block5;
                }
                case 5: {
                    names[i] = names[i].substring(3);
                }
            }
        }
        block6: for (i = 0; i < count; ++i) {
            if (kinds[i] != 1) continue;
            for (int j = 0; j < count; ++j) {
                Type targetType;
                Type isType;
                if (j == i || kinds[j] != 2 && kinds[j] != 5 || !names[i].equals(names[j]) || (isType = methods[i].getReturnType()).equals(targetType = kinds[j] == 2 ? methods[j].getReturnType() : methods[j].getArguments()[0])) continue;
                kinds[i] = 0;
                names[i] = methods[i].getName();
                continue block6;
            }
        }
        for (i = 0; i < count; ++i) {
            if (kinds[i] != 5) continue;
            int getterIndex = -1;
            int isGetterIndex = -1;
            for (int j = 0; j < count; ++j) {
                Type setterArg;
                Type getterReturn;
                if (j == i || !names[i].equals(names[j]) || !(getterReturn = methods[j].getReturnType()).equals(setterArg = methods[i].getArguments()[0])) continue;
                if (kinds[j] == 1) {
                    isGetterIndex = j;
                    continue;
                }
                if (kinds[j] != 2) continue;
                getterIndex = j;
            }
            if (getterIndex > -1) {
                if (isGetterIndex > -1) {
                    kinds[isGetterIndex] = 3;
                    methods[isGetterIndex].setAttributePairIndex(i);
                    methods[i].setAttributePairIndex(isGetterIndex);
                    kinds[getterIndex] = 0;
                    names[getterIndex] = methods[getterIndex].getName();
                    continue;
                }
                kinds[getterIndex] = 4;
                methods[getterIndex].setAttributePairIndex(i);
                methods[i].setAttributePairIndex(getterIndex);
                continue;
            }
            if (isGetterIndex > -1) {
                kinds[isGetterIndex] = 3;
                methods[isGetterIndex].setAttributePairIndex(i);
                methods[i].setAttributePairIndex(isGetterIndex);
                continue;
            }
            kinds[i] = 0;
            names[i] = methods[i].getName();
        }
        for (i = 0; i < count; ++i) {
            String name;
            if (kinds[i] != 0 && Character.isUpperCase((name = names[i]).charAt(0)) && (name.length() == 1 || Character.isLowerCase(name.charAt(1)))) {
                StringBuilder buffer = new StringBuilder(name);
                buffer.setCharAt(0, Character.toLowerCase(name.charAt(0)));
                names[i] = buffer.toString();
            }
            methods[i].setAttributeKind(kinds[i]);
        }
    }

    public static void setMethodNames(CompoundType container, CompoundType.Method[] allMethods, BatchEnvironment env) throws Exception {
        int i;
        CompoundType.Method method;
        int i2;
        int i3;
        int count = allMethods.length;
        if (count == 0) {
            return;
        }
        String[] names = new String[count];
        for (int i4 = 0; i4 < count; ++i4) {
            names[i4] = allMethods[i4].getName();
        }
        CompoundType enclosing = allMethods[0].getEnclosing();
        if (enclosing.isType(4096) || enclosing.isType(8192) || enclosing.isType(32768)) {
            int[] kinds = new int[count];
            for (i3 = 0; i3 < count; ++i3) {
                kinds[i3] = IDLNames.getInitialAttributeKind(allMethods[i3], env);
            }
            IDLNames.setAttributeKinds(allMethods, kinds, names);
        }
        NameContext context = new NameContext(true);
        for (i3 = 0; i3 < count; ++i3) {
            context.put(names[i3]);
        }
        boolean haveConstructor = false;
        for (int i5 = 0; i5 < count; ++i5) {
            if (!allMethods[i5].isConstructor()) {
                names[i5] = IDLNames.getMemberOrMethodName(context, names[i5], env);
                continue;
            }
            names[i5] = "create";
            haveConstructor = true;
        }
        boolean[] overloaded = new boolean[count];
        for (i2 = 0; i2 < count; ++i2) {
            overloaded[i2] = !allMethods[i2].isAttribute() && !allMethods[i2].isConstructor() && IDLNames.doesMethodCollide(names[i2], allMethods[i2], allMethods, names, true);
        }
        IDLNames.convertOverloadedMethods(allMethods, names, overloaded);
        for (i2 = 0; i2 < count; ++i2) {
            overloaded[i2] = !allMethods[i2].isAttribute() && allMethods[i2].isConstructor() && IDLNames.doesConstructorCollide(names[i2], allMethods[i2], allMethods, names, true);
        }
        IDLNames.convertOverloadedMethods(allMethods, names, overloaded);
        for (i2 = 0; i2 < count; ++i2) {
            method = allMethods[i2];
            if (!method.isAttribute() || !IDLNames.doesMethodCollide(names[i2], method, allMethods, names, true)) continue;
            int n = i2;
            names[n] = names[n] + "__";
        }
        if (haveConstructor) {
            for (i2 = 0; i2 < count; ++i2) {
                method = allMethods[i2];
                if (!method.isConstructor() || !IDLNames.doesConstructorCollide(names[i2], method, allMethods, names, false)) continue;
                int n = i2;
                names[n] = names[n] + "__";
            }
        }
        String containerName = container.getIDLName();
        for (i = 0; i < count; ++i) {
            if (!names[i].equalsIgnoreCase(containerName) || allMethods[i].isAttribute()) continue;
            int n = i;
            names[n] = names[n] + "_";
        }
        for (i = 0; i < count; ++i) {
            if (!IDLNames.doesMethodCollide(names[i], allMethods[i], allMethods, names, false)) continue;
            throw new Exception(allMethods[i].toString());
        }
        for (i = 0; i < count; ++i) {
            CompoundType.Method method2 = allMethods[i];
            String wireName = names[i];
            if (method2.isAttribute()) {
                wireName = ATTRIBUTE_WIRE_PREFIX[method2.getAttributeKind()] + IDLNames.stripLeadingUnderscore(wireName);
                String attributeName = names[i];
                method2.setAttributeName(attributeName);
            }
            method2.setIDLName(wireName);
        }
    }

    private static String stripLeadingUnderscore(String name) {
        if (name != null && name.length() > 1 && name.charAt(0) == '_') {
            return name.substring(1);
        }
        return name;
    }

    private static String stripTrailingUnderscore(String name) {
        if (name != null && name.length() > 1 && name.charAt(name.length() - 1) == '_') {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    private static void convertOverloadedMethods(CompoundType.Method[] allMethods, String[] names, boolean[] overloaded) {
        for (int i = 0; i < names.length; ++i) {
            Type[] args;
            if (!overloaded[i]) continue;
            CompoundType.Method method = allMethods[i];
            for (Type arg : args = method.getArguments()) {
                int n = i;
                names[n] = names[n] + "__";
                String argIDLName = arg.getQualifiedIDLName(false);
                argIDLName = IDLNames.replace(argIDLName, "::_", "_");
                argIDLName = IDLNames.replace(argIDLName, "::", "_");
                argIDLName = IDLNames.replace(argIDLName, " ", "_");
                int n2 = i;
                names[n2] = names[n2] + argIDLName;
            }
            if (args.length == 0) {
                int n = i;
                names[n] = names[n] + "__";
            }
            names[i] = IDLNames.stripLeadingUnderscore(names[i]);
        }
    }

    private static boolean doesMethodCollide(String name, CompoundType.Method method, CompoundType.Method[] allMethods, String[] allNames, boolean ignoreAttributes) {
        for (int i = 0; i < allMethods.length; ++i) {
            CompoundType.Method target = allMethods[i];
            if (method == target || target.isConstructor() || ignoreAttributes && target.isAttribute() || !name.equals(allNames[i])) continue;
            int kind1 = method.getAttributeKind();
            int kind2 = target.getAttributeKind();
            if (kind1 != 0 && kind2 != 0 && (kind1 == 5 && kind2 != 5 || kind1 != 5 && kind2 == 5 || kind1 == 3 && kind2 == 2 || kind1 == 2 && kind2 == 3)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesConstructorCollide(String name, CompoundType.Method method, CompoundType.Method[] allMethods, String[] allNames, boolean compareConstructors) {
        for (int i = 0; i < allMethods.length; ++i) {
            CompoundType.Method target = allMethods[i];
            if (method == target || target.isConstructor() != compareConstructors || !name.equals(allNames[i])) continue;
            return true;
        }
        return false;
    }

    public static void setMemberNames(CompoundType container, CompoundType.Member[] allMembers, CompoundType.Method[] allMethods, BatchEnvironment env) throws Exception {
        boolean changed;
        NameContext context = new NameContext(true);
        for (CompoundType.Member allMember : allMembers) {
            context.put(allMember.getName());
        }
        for (int i = 0; i < allMembers.length; ++i) {
            CompoundType.Member member = allMembers[i];
            String idlName = IDLNames.getMemberOrMethodName(context, member.getName(), env);
            member.setIDLName(idlName);
        }
        String containerName = container.getIDLName();
        for (CompoundType.Member allMember : allMembers) {
            String name = allMember.getIDLName();
            if (!name.equalsIgnoreCase(containerName)) continue;
            allMember.setIDLName(name + "_");
        }
        for (int i = 0; i < allMembers.length; ++i) {
            String name = allMembers[i].getIDLName();
            for (int j = 0; j < allMembers.length; ++j) {
                if (i == j || !allMembers[j].getIDLName().equals(name)) continue;
                throw new Exception(name);
            }
        }
        do {
            changed = false;
            block6: for (CompoundType.Member allMember : allMembers) {
                String name = allMember.getIDLName();
                for (CompoundType.Method allMethod : allMethods) {
                    if (!allMethod.getIDLName().equals(name)) continue;
                    allMember.setIDLName(name + "_");
                    changed = true;
                    continue block6;
                }
            }
        } while (changed);
    }

    public static String getTypeName(int typeCode, boolean isConstant) {
        String idlName = null;
        switch (typeCode) {
            case 1: {
                idlName = "void";
                break;
            }
            case 2: {
                idlName = "boolean";
                break;
            }
            case 4: {
                idlName = "octet";
                break;
            }
            case 8: {
                idlName = "wchar";
                break;
            }
            case 16: {
                idlName = "short";
                break;
            }
            case 32: {
                idlName = "long";
                break;
            }
            case 64: {
                idlName = "long long";
                break;
            }
            case 128: {
                idlName = "float";
                break;
            }
            case 256: {
                idlName = "double";
                break;
            }
            case 1024: {
                idlName = "any";
                break;
            }
            case 2048: {
                idlName = "Object";
                break;
            }
            case 512: {
                idlName = isConstant ? "wstring" : "WStringValue";
            }
        }
        return idlName;
    }

    public static String getQualifiedName(String[] idlModuleNames, String idlName) {
        String result = null;
        if (idlModuleNames != null && idlModuleNames.length > 0) {
            for (int i = 0; i < idlModuleNames.length; ++i) {
                if (i == 0) {
                    result = idlModuleNames[0];
                    continue;
                }
                result = result + "::";
                result = result + idlModuleNames[i];
            }
            result = result + "::";
            result = result + idlName;
        } else {
            result = idlName;
        }
        return result;
    }

    public static String replace(String source, String match, String replace) {
        int index = source.indexOf(match, 0);
        if (index >= 0) {
            StringBuilder result = new StringBuilder(source.length() + 16);
            int matchLength = match.length();
            int startIndex = 0;
            while (index >= 0) {
                result.append(source.substring(startIndex, index));
                result.append(replace);
                startIndex = index + matchLength;
                index = source.indexOf(match, startIndex);
            }
            if (startIndex < source.length()) {
                result.append(source.substring(startIndex));
            }
            return result.toString();
        }
        return source;
    }

    public static String getIDLRepositoryID(String idlName) {
        return "IDL:" + IDLNames.replace(idlName, "::", "/") + ":1.0";
    }

    private static String getTypeOrModuleName(String name) {
        String result = IDLNames.convertLeadingUnderscores(name);
        return IDLNames.convertIDLKeywords(result);
    }
}

