/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JArrayExpr;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class PlainJArrayExpr
extends AbstractJExpr
implements JArrayExpr {
    private ArrayList<JExpr> members;

    PlainJArrayExpr() {
        super(0);
    }

    PlainJArrayExpr(JExpr ... members) {
        super(0);
        if (members != null) {
            ArrayList<JExpr> list = new ArrayList<JExpr>(members.length);
            for (JExpr expr : members) {
                if (expr == null) continue;
                list.add(expr);
            }
            if (list.size() > 0) {
                this.members = list;
            }
        }
    }

    @Override
    public JArrayExpr add(JExpr value) {
        if (value != null) {
            ArrayList<JExpr> members = this.members;
            if (members == null) {
                this.members = members = new ArrayList();
            }
            members.add(value);
        }
        return this;
    }

    @Override
    public int elementCount() {
        ArrayList<JExpr> members = this.members;
        return members == null ? 0 : members.size();
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        Iterator<JExpr> iterator;
        writer.write(Tokens$.PUNCT.BRACE.OPEN);
        ArrayList<JExpr> members = this.members;
        if (members != null && (iterator = members.iterator()).hasNext()) {
            writer.write(FormatPreferences.Space.WITHIN_BRACES_ARRAY_INIT);
            writer.write(iterator.next());
            while (iterator.hasNext()) {
                writer.write(Tokens$.PUNCT.COMMA);
                writer.write(iterator.next());
            }
            writer.write(FormatPreferences.Space.WITHIN_BRACES_ARRAY_INIT);
        }
        writer.write(Tokens$.PUNCT.BRACE.CLOSE);
    }
}

