/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetClusterHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ClusterUtil {
    private static final String[] configBrokerInfoItemNames = new String[]{"Address", "ID"};
    private static final String[] configBrokerInfoItemDesc = configBrokerInfoItemNames;
    private static final OpenType[] configItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
    private static volatile CompositeType configCompType = null;

    public static String getBrokerAddress(String brokerID) {
        if (brokerID == null) {
            return null;
        }
        ClusterManager cmgr = Globals.getClusterManager();
        if (cmgr == null) {
            return null;
        }
        ClusteredBroker bkr = cmgr.getBroker(brokerID);
        if (bkr == null) {
            return null;
        }
        MQAddress addr = bkr.getBrokerURL();
        if (addr == null) {
            return null;
        }
        return addr.toString();
    }

    public static String getShortBrokerAddress(String brokerID) {
        BrokerMQAddress ba = null;
        String longAddr = ClusterUtil.getBrokerAddress(brokerID);
        Logger logger = Globals.getLogger();
        if (longAddr == null) {
            return null;
        }
        try {
            ba = BrokerMQAddress.createAddress(longAddr);
        }
        catch (Exception e) {
            BrokerResources rb = Globals.getBrokerResources();
            logger.log(16, rb.getString("B2174", brokerID), e);
            return null;
        }
        if (ba == null) {
            return null;
        }
        return ba.getHost().getHostName() + ":" + ba.getPort();
    }

    public static boolean isMasterBroker(String brokerAddress) {
        ClusterManager cm = Globals.getClusterManager();
        ClusteredBroker cb = null;
        String id = null;
        if (cm == null) {
            return false;
        }
        try {
            id = cm.lookupBrokerID(BrokerMQAddress.createAddress(brokerAddress));
        }
        catch (Exception e) {
            return false;
        }
        if (id == null || id.equals("")) {
            return false;
        }
        try {
            cb = cm.getBroker(id);
            if (cb == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        ClusteredBroker master = cm.getMasterBroker();
        if (master == null) {
            return false;
        }
        return master.equals(cb);
    }

    public static CompositeData getConfigCompositeData(ClusteredBroker cb) throws OpenDataException {
        Logger logger = Globals.getLogger();
        CompositeDataSupport cds = null;
        Hashtable bkrInfo = GetClusterHandler.getBrokerClusterInfo(cb, logger);
        String id = null;
        if (Globals.getHAEnabled()) {
            id = (String)bkrInfo.get("ID");
        }
        Object[] brokerInfoItemValues = new Object[]{bkrInfo.get("Address"), id};
        if (configCompType == null) {
            configCompType = new CompositeType("BrokerClusterInfoConfig", "BrokerClusterInfoConfig", configBrokerInfoItemNames, configBrokerInfoItemDesc, configItemTypes);
        }
        cds = new CompositeDataSupport(configCompType, configBrokerInfoItemNames, brokerInfoItemValues);
        return cds;
    }
}

