/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.WebuiInput;
import com.sun.webui.jsf.model.ClockTime;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert.IntegerConverter;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.ValueChangeEvent;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public final class Time
extends WebuiInput
implements NamingContainer {
    public static final String HOUR_FACET = "hour";
    public static final String MINUTES_FACET = "minutes";
    private static final String TIME_SUBMITTED = "com.sun.webui.jsf.TimeSubmitted";
    private static final boolean DEBUG = false;
    private boolean disabled = false;
    private boolean disabledSet = false;
    private boolean readOnly = false;
    private boolean readOnlySet = false;
    private String style = null;
    private String styleClass = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndexSet = false;
    private TimeZone timeZone = null;
    private boolean visible = false;
    private boolean visibleSet = false;
    private String hourTooltipKey;
    private String minutesTooltipKey;

    public Time() {
        this.setRendererType("com.sun.webui.jsf.Time");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Time";
    }

    public DropDown getHourMenu() {
        return this.getMenu(HOUR_FACET, this.getHourItems());
    }

    public DropDown getMinutesMenu() {
        return this.getMenu(MINUTES_FACET, this.getMinuteItems());
    }

    private DropDown getMenu(String facet, Option[] options) {
        int tindex;
        DropDown menu = (DropDown)ComponentUtilities.getPrivateFacet((UIComponent)this, facet, true);
        if (menu == null) {
            menu = new DropDown();
            menu.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facet));
            menu.setItems(options);
            menu.setConverter((Converter)new IntegerConverter());
            ComponentUtilities.putPrivateFacet((UIComponent)this, facet, (UIComponent)menu);
        }
        if ((tindex = this.getTabIndex()) > 0) {
            menu.setTabIndex(tindex);
        }
        menu.setDisabled(this.isDisabled());
        menu.setRequired(this.isRequired());
        return menu;
    }

    private Option[] getHourItems() {
        int counter;
        Option[] hours = new Option[25];
        hours[0] = new Option(-1, " ");
        for (counter = 0; counter < 10; ++counter) {
            hours[counter + 1] = new Option(counter, "0" + counter);
        }
        while (counter < 24) {
            hours[counter + 1] = new Option(counter, String.valueOf(counter));
            ++counter;
        }
        return hours;
    }

    private Option[] getMinuteItems() {
        Option[] minutes = new Option[13];
        minutes[0] = new Option(-1, " ");
        minutes[1] = new Option(0, "00");
        minutes[2] = new Option(5, "05");
        for (int i = 2; i < 12; ++i) {
            minutes[i + 1] = new Option(5 * i, String.valueOf(5 * i));
        }
        return minutes;
    }

    public String getOffset() {
        Calendar calendar = this.getCalendar();
        TimeZone tz = calendar.getTimeZone();
        StringBuilder gmtTimeZone = new StringBuilder(8);
        int value = calendar.get(15) + calendar.get(16);
        if (value < 0) {
            gmtTimeZone.append('-');
            value = -value;
        } else {
            gmtTimeZone.append('+');
        }
        int num = value / 3600000;
        if (num < 10) {
            gmtTimeZone.append("0");
        }
        gmtTimeZone.append(num).append(":");
        num = value % 3600000 / 60000;
        if (num < 10) {
            gmtTimeZone.append("0");
        }
        gmtTimeZone.append(num);
        return gmtTimeZone.toString();
    }

    public Calendar getCalendar() {
        TimeZone tz;
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Calendar calendar = (tz = this.getTimeZone()) == null ? Calendar.getInstance(locale) : Calendar.getInstance(tz, locale);
        return calendar;
    }

    public String getHourTooltipKey() {
        return this.hourTooltipKey;
    }

    public void setHourTooltipKey(String newHourTooltipKey) {
        this.hourTooltipKey = newHourTooltipKey;
    }

    public String getMinutesTooltipKey() {
        return this.minutesTooltipKey;
    }

    public void setMinutesTooltipKey(String newMinutesTooltipKey) {
        this.minutesTooltipKey = newMinutesTooltipKey;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.setValid(true);
        ComponentUtilities.getPrivateFacet((UIComponent)this, HOUR_FACET, false).processDecodes(context);
        ComponentUtilities.getPrivateFacet((UIComponent)this, MINUTES_FACET, false).processDecodes(context);
        this.setSubmittedValue(TIME_SUBMITTED);
        if (this.isImmediate()) {
            this.runValidation(context);
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object hourValue = ((EditableValueHolder)ComponentUtilities.getPrivateFacet((UIComponent)this, HOUR_FACET, false)).getValue();
        Object minuteValue = ((EditableValueHolder)ComponentUtilities.getPrivateFacet((UIComponent)this, MINUTES_FACET, false)).getValue();
        ClockTime newValue = null;
        try {
            newValue = this.createClockTime(hourValue, minuteValue, context);
        }
        catch (ConverterException ce) {
            FacesMessage message = ce.getFacesMessage();
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
            context.renderResponse();
        }
        catch (Exception ex) {
            FacesMessage message = new FacesMessage("Invalid input");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
            context.renderResponse();
        }
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previous, (Object)newValue));
            }
        }
    }

    private void runValidation(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClockTime createClockTime(Object hourObject, Object minuteObject, FacesContext context) {
        String messageKey = null;
        ClockTime time = null;
        if (hourObject instanceof Integer && minuteObject instanceof Integer) {
            int hour = (Integer)hourObject;
            int minute = (Integer)minuteObject;
            if (hour == -1 && minute == -1) {
                if (!this.isRequired()) return null;
                messageKey = "Time.required";
            } else if (hour == -1) {
                messageKey = "Time.enterHour";
            } else if (minute == -1) {
                messageKey = "Time.enterMinute";
            } else {
                time = new ClockTime();
                try {
                    time.setHour(hour);
                    time.setMinute(minute);
                }
                catch (Exception ex) {
                    messageKey = "Time.invalidData";
                }
            }
        } else {
            if (!this.isRequired()) return null;
            messageKey = "Time.required";
        }
        if (messageKey == null) return time;
        String message = ThemeUtilities.getTheme(context).getMessage(messageKey);
        throw new ConverterException(new FacesMessage(message));
    }

    private static void log(String msg) {
        LogUtil.finest(Time.class.getName() + "::" + msg);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        String rendererType;
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        DropDown hourMenu = this.getHourMenu();
        DropDown minuteMenu = this.getMinutesMenu();
        if (this.getSubmittedValue() == null) {
            Object object = this.getValue();
            ClockTime value = null;
            if (object != null && object instanceof ClockTime) {
                value = (ClockTime)object;
            }
            if (value != null) {
                hourMenu.setValue(value.getHour());
            } else {
                hourMenu.setValue(-1);
            }
            if (value != null) {
                minuteMenu.setValue(value.getMinute());
            } else {
                minuteMenu.setValue(-1);
            }
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String key = this.getHourTooltipKey();
        if (key != null) {
            hourMenu.setToolTip(theme.getMessage(key));
        }
        if ((key = this.getMinutesTooltipKey()) != null) {
            minuteMenu.setToolTip(theme.getMessage(key));
        }
        if ((rendererType = this.getRendererType()) != null) {
            this.getRenderer(context).encodeEnd(context, (UIComponent)this);
        }
    }

    public boolean isDisabled() {
        if (this.disabledSet) {
            return this.disabled;
        }
        ValueExpression vb = this.getValueExpression("disabled");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setDisabled(boolean newDisabled) {
        this.disabled = newDisabled;
        this.disabledSet = true;
    }

    public boolean isReadOnly() {
        if (this.readOnlySet) {
            return this.readOnly;
        }
        ValueExpression vb = this.getValueExpression("readOnly");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setReadOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
        this.readOnlySet = true;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public int getTabIndex() {
        if (this.tabIndexSet) {
            return this.tabIndex;
        }
        ValueExpression vb = this.getValueExpression("tabIndex");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int newTabIndex) {
        this.tabIndex = newTabIndex;
        this.tabIndexSet = true;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        ValueExpression vb = this.getValueExpression("timeZone");
        if (vb != null) {
            return (TimeZone)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTimeZone(TimeZone newTimeZone) {
        this.timeZone = newTimeZone;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.disabled = (Boolean)values[1];
        this.disabledSet = (Boolean)values[2];
        this.readOnly = (Boolean)values[3];
        this.readOnlySet = (Boolean)values[4];
        this.style = (String)values[5];
        this.styleClass = (String)values[6];
        this.tabIndex = (Integer)values[7];
        this.tabIndexSet = (Boolean)values[8];
        this.timeZone = (TimeZone)values[9];
        this.visible = (Boolean)values[10];
        this.visibleSet = (Boolean)values[11];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.disabled ? Boolean.TRUE : Boolean.FALSE, this.disabledSet ? Boolean.TRUE : Boolean.FALSE, this.readOnly ? Boolean.TRUE : Boolean.FALSE, this.readOnlySet ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.tabIndex, this.tabIndexSet ? Boolean.TRUE : Boolean.FALSE, this.timeZone, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }
}

