/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.admin.rest.resources.TemplateExecCommand;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.Dom;

@Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5", "application/x-www-form-urlencoded;qs=0.5"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE})
public class SystemPropertiesCliResource
extends TemplateExecCommand {
    protected static final String TAG_SYSTEM_PROPERTY = "system-property";
    @Inject
    protected ServiceLocator injector;
    protected Dom entity;
    protected Domain domain;

    public SystemPropertiesCliResource() {
        super(SystemPropertiesCliResource.class.getSimpleName(), "", "", "", "", true);
    }

    public void setEntity(Dom p) {
        this.entity = p;
    }

    public Dom getEntity() {
        return this.entity;
    }

    @GET
    public ActionReportResult get() {
        this.domain = (Domain)this.locatorBridge.getRemoteLocator().getService(Domain.class, new Annotation[0]);
        ParameterMap data = new ParameterMap();
        this.processCommandParams(data);
        this.addQueryString((MultivaluedMap<String, String>)this.uriInfo.getQueryParameters(), data);
        this.adjustParameters(data);
        TreeMap<String, Map<String, String>> properties = new TreeMap<String, Map<String, String>>();
        RestActionReporter actionReport = new RestActionReporter();
        this.getSystemProperties(properties, this.getEntity(), false);
        actionReport.getExtraProperties().put("systemProperties", new ArrayList(properties.values()));
        if (properties.isEmpty()) {
            actionReport.getTopMessagePart().setMessage("Nothing to list.");
        }
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
        return results;
    }

    @POST
    public Response create(HashMap<String, String> data) {
        Response resp = this.deleteRemovedProperties(data);
        return resp == null ? this.saveProperties(data) : resp;
    }

    @PUT
    public Response update(HashMap<String, String> data) {
        return this.saveProperties(data);
    }

    @Path(value="{Name}/")
    @POST
    public Response getSystemPropertyResource(@PathParam(value="Name") String id, HashMap<String, String> data) {
        data.put(id, data.get("value"));
        data.remove("value");
        List segments = this.uriInfo.getPathSegments(true);
        String grandParent = ((PathSegment)segments.get(segments.size() - 3)).getPath();
        return this.saveProperties(grandParent, data);
    }

    @Path(value="{Name}/")
    @DELETE
    public Response deleteSystemProperty(@PathParam(value="Name") String id, HashMap<String, String> data) {
        List segments = this.uriInfo.getPathSegments(true);
        String grandParent = ((PathSegment)segments.get(segments.size() - 3)).getPath();
        return this.deleteProperty(grandParent, id);
    }

    protected void getSystemProperties(Map<String, Map<String, String>> properties, Dom dom, boolean getDefaults) {
        List sysprops = dom.nodeElements(TAG_SYSTEM_PROPERTY);
        if (sysprops != null && !sysprops.isEmpty()) {
            for (Dom sysprop : sysprops) {
                String name = sysprop.attribute("name");
                Map<String, String> currValue = properties.get(name);
                if (currValue == null) {
                    currValue = new HashMap<String, String>();
                    currValue.put("name", name);
                    currValue.put(getDefaults ? "defaultValue" : "value", sysprop.attribute("value"));
                    if (sysprop.attribute("description") != null) {
                        currValue.put("description", sysprop.attribute("description"));
                    }
                    properties.put(name, currValue);
                    continue;
                }
                if (currValue.get("defaultValue") != null) continue;
                currValue.put("defaultValue", sysprop.attribute("value"));
            }
        }
        if (dom.getProxyType().equals(Server.class)) {
            if (((Server)dom.createProxy()).getCluster() != null) {
                this.getSystemProperties(properties, this.getCluster(dom.parent().parent(), ((Server)dom.createProxy()).getCluster().getName()), true);
            } else {
                this.getSystemProperties(properties, this.getConfig(dom.parent().parent(), dom.attribute("config-ref")), true);
            }
        } else if (dom.getProxyType().equals(Cluster.class)) {
            this.getSystemProperties(properties, this.getConfig(dom.parent().parent(), dom.attribute("config-ref")), true);
        }
    }

    protected Dom getCluster(Dom domain, String clusterName) {
        List configs = ((Dom)domain.nodeElements("clusters").get(0)).nodeElements("cluster");
        for (Dom config : configs) {
            if (!config.attribute("name").equals(clusterName)) continue;
            return config;
        }
        return null;
    }

    protected Dom getConfig(Dom domain, String configName) {
        List configs = ((Dom)domain.nodeElements("configs").get(0)).nodeElements("config");
        for (Dom config : configs) {
            if (!config.attribute("name").equals(configName)) continue;
            return config;
        }
        return null;
    }

    protected String convertPropertyMapToString(HashMap<String, String> data) {
        StringBuilder options = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            options.append(sep).append(entry.getKey()).append("=").append(value.replaceAll(":", "\\\\:").replaceAll("=", "\\\\="));
            sep = ":";
        }
        return options.toString();
    }

    protected Response saveProperties(HashMap<String, String> data) {
        return this.saveProperties(null, data);
    }

    protected Response saveProperties(String parent, HashMap<String, String> data) {
        String propertiesString = this.convertPropertyMapToString(data);
        data = new HashMap();
        data.put("DEFAULT", propertiesString);
        data.put("target", parent == null ? this.getParent(this.uriInfo) : parent);
        RestActionReporter actionReport = ResourceUtil.runCommand("create-system-properties", data, this.getSubject());
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
        int status = 200;
        if (exitCode == ActionReport.ExitCode.FAILURE) {
            status = 500;
        }
        return Response.status((int)status).entity((Object)results).build();
    }

    protected Response deleteProperty(String parent, String propName) {
        ParameterMap pm = new ParameterMap();
        pm.add((Object)"DEFAULT", (Object)propName);
        pm.add((Object)"target", (Object)(parent == null ? this.getParent(this.uriInfo) : parent));
        RestActionReporter actionReport = ResourceUtil.runCommand("delete-system-property", pm, this.getSubject());
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
        int status = 200;
        if (exitCode == ActionReport.ExitCode.FAILURE) {
            status = 500;
        }
        return Response.status((int)status).entity((Object)results).build();
    }

    protected Response deleteRemovedProperties(Map<String, String> newProps) {
        ArrayList<String> existingList = new ArrayList<String>();
        Dom parent = this.getEntity();
        for (Dom existingProp : parent.nodeElements(TAG_SYSTEM_PROPERTY)) {
            existingList.add(existingProp.attribute("name"));
        }
        if (existingList.isEmpty()) {
            return null;
        }
        for (String onePropName : existingList) {
            Response resp;
            if (newProps.containsKey(onePropName) || (resp = this.deleteProperty(null, onePropName)).getStatus() == 200) continue;
            return resp;
        }
        return null;
    }
}

