/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch.spi.impl;

import com.ibm.jbatch.spi.BatchSPIManager;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.jbatch.spi.DatabaseAlreadyInitializedException;
import com.ibm.jbatch.spi.DatabaseConfigurationBean;
import com.ibm.jbatch.spi.ExecutorServiceProvider;
import com.sun.enterprise.config.serverbeans.Config;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.batch.spi.impl.BatchRuntimeConfiguration;
import org.glassfish.batch.spi.impl.GlassFishBatchSecurityHelper;
import org.glassfish.batch.spi.impl.GlassFishBatchValidationException;
import org.glassfish.batch.spi.impl.ManagedServiceActivator;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=10)
public class BatchRuntimeHelper
implements PostConstruct,
EventListener {
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    @Named(value="default-instance-name")
    private BatchRuntimeConfiguration batchRuntimeConfiguration;
    @Inject
    private ServerContext serverContext;
    private volatile ManagedServiceActivator activator;
    @Inject
    private GlassFishBatchSecurityHelper glassFishBatchSecurityHelper;
    @Inject
    private Logger logger;
    @Inject
    Events events;
    @Inject
    Config config;
    @Inject
    ApplicationRegistry applicationRegistry;
    private GlassFishBatchExecutorServiceProvider glassFishBatchExecutorServiceProvider = new GlassFishBatchExecutorServiceProvider();
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private Set<String> tagNamesRequiringCleanup = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndInitializeBatchRuntime() {
        if (!this.initialized.get()) {
            BatchRuntimeHelper batchRuntimeHelper = this;
            synchronized (batchRuntimeHelper) {
                if (!this.initialized.get()) {
                    this.initialized.set(true);
                }
            }
        }
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
        BatchSPIManager batchSPIManager = BatchSPIManager.getInstance();
        batchSPIManager.registerExecutorServiceProvider((ExecutorServiceProvider)this.glassFishBatchExecutorServiceProvider);
        batchSPIManager.registerBatchSecurityHelper((BatchSecurityHelper)this.glassFishBatchSecurityHelper);
        try {
            GlassFishDatabaseConfigurationBean databaseConfigurationBean = new GlassFishDatabaseConfigurationBean();
            batchSPIManager.registerDatabaseConfigurationBean((DatabaseConfigurationBean)databaseConfigurationBean);
        }
        catch (DatabaseAlreadyInitializedException daiEx) {
            daiEx.printStackTrace();
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.glassFishBatchExecutorServiceProvider.setExecutorService(executorService);
    }

    private void registerIfBatchJobsDirExists(ApplicationInfo applicationInfo) {
        if (applicationInfo != null && applicationInfo.isLoaded()) {
            ClassLoader appClassLoader = applicationInfo.getAppClassLoader();
            if (appClassLoader != null && appClassLoader.getResource("META-INF/batch-jobs") != null) {
                this.tagNamesRequiringCleanup.add(this.config.getName() + ":" + applicationInfo.getName());
                return;
            }
            for (ModuleInfo moduleInfo : applicationInfo.getModuleInfos()) {
                ClassLoader moduleClassLoader = moduleInfo.getModuleClassLoader();
                if (moduleClassLoader == null || moduleClassLoader.getResource("META-INF/batch-jobs") == null) continue;
                this.tagNamesRequiringCleanup.add(this.config.getName() + ":" + applicationInfo.getName());
            }
        }
    }

    public void event(EventListener.Event<?> event) {
        block11: {
            try {
                if (event.is(EventTypes.SERVER_READY)) {
                    for (String appName : this.applicationRegistry.getAllApplicationNames()) {
                        ApplicationInfo applicationInfo = this.applicationRegistry.get(appName);
                        this.registerIfBatchJobsDirExists(applicationInfo);
                    }
                } else if (event.is(Deployment.APPLICATION_LOADED) && event.hook() != null && event.hook() instanceof ApplicationInfo) {
                    ApplicationInfo applicationInfo = (ApplicationInfo)event.hook();
                    this.registerIfBatchJobsDirExists(applicationInfo);
                }
                if (!event.is(Deployment.UNDEPLOYMENT_SUCCESS) || event.hook() == null || !(event.hook() instanceof DeploymentContextImpl)) break block11;
                DeploymentContextImpl deploymentContext = (DeploymentContextImpl)event.hook();
                Properties props = deploymentContext.getAppProps();
                String appName = props.getProperty("defaultAppName");
                if (Boolean.parseBoolean(props.getProperty("retain-batch-jobs"))) break block11;
                String tagName = this.config.getName() + ":" + appName;
                try {
                    BatchSPIManager batchSPIManager = BatchSPIManager.getInstance();
                    if (batchSPIManager != null && batchSPIManager.getBatchJobUtil() != null) {
                        batchSPIManager.getBatchJobUtil().purgeOwnedRepositoryData(tagName);
                        this.tagNamesRequiringCleanup.remove(tagName);
                    } else if (this.tagNamesRequiringCleanup.contains(tagName) && batchSPIManager.getBatchJobUtil() != null) {
                        batchSPIManager.getBatchJobUtil().purgeOwnedRepositoryData(tagName);
                        this.tagNamesRequiringCleanup.remove(tagName);
                    }
                }
                catch (Exception ex) {
                    this.logger.log(Level.FINE, "Error while purging jobs", ex);
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.FINE, "Exception while handling event: " + String.valueOf(event), ex);
            }
        }
    }

    public String getDataSourceLookupName() {
        String val = this.batchRuntimeConfiguration.getDataSourceLookupName();
        if (val == null || val.trim().length() == 0) {
            val = this.serverContext.getInstanceName().equals("server") ? "jdbc/__TimerPool" : "jdbc/__default";
        }
        return val;
    }

    public static String getDefaultDataSourceLookupNameForTarget(String targetName) {
        return targetName.equals("server") ? "jdbc/__TimerPool" : "jdbc/__default";
    }

    private String getSchemaName() {
        String schemaName = this.batchRuntimeConfiguration.getJobRepositoryDatabaseSchemaName();
        return schemaName != null && schemaName.trim().length() > 0 ? schemaName : "APP";
    }

    public String getExecutorServiceLookupName() {
        return this.batchRuntimeConfiguration.getExecutorServiceLookupName();
    }

    public ExecutorService lookupExecutorService() {
        return this.lookupExecutorService(this.getExecutorServiceLookupName());
    }

    public ExecutorService lookupExecutorService(String exeLookupName) {
        try {
            InitialContext initialContext;
            Object obj;
            if (this.activator == null) {
                this.activator = (ManagedServiceActivator)this.serviceLocator.getService(ManagedServiceActivator.class, new Annotation[0]);
            }
            if (!((obj = (initialContext = new InitialContext()).lookup(exeLookupName)) instanceof ExecutorService)) {
                throw new GlassFishBatchValidationException(exeLookupName + " is not mapped to an ExecutorService. Batch operations may not work correctly.");
            }
            return (ExecutorService)obj;
        }
        catch (NamingException nEx) {
            throw new GlassFishBatchValidationException("No ExecutorService bound to name = " + exeLookupName, nEx);
        }
    }

    private class GlassFishBatchExecutorServiceProvider
    implements ExecutorServiceProvider {
        private volatile ExecutorService executorService;

        private GlassFishBatchExecutorServiceProvider() {
        }

        void setExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecutorService getExecutorService() {
            BatchRuntimeHelper.this.checkAndInitializeBatchRuntime();
            if (this.executorService == null) {
                GlassFishBatchExecutorServiceProvider glassFishBatchExecutorServiceProvider = this;
                synchronized (glassFishBatchExecutorServiceProvider) {
                    if (this.executorService == null) {
                        this.executorService = BatchRuntimeHelper.this.lookupExecutorService();
                    }
                }
            }
            return this.executorService;
        }
    }

    private class GlassFishDatabaseConfigurationBean
    extends DatabaseConfigurationBean {
        private GlassFishDatabaseConfigurationBean() {
        }

        public String getJndiName() {
            BatchRuntimeHelper.this.checkAndInitializeBatchRuntime();
            return BatchRuntimeHelper.this.getDataSourceLookupName();
        }

        public String getSchema() {
            BatchRuntimeHelper.this.checkAndInitializeBatchRuntime();
            return BatchRuntimeHelper.this.getSchemaName();
        }
    }
}

