/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.config;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.common.config.spi.ConfigProvider;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class GlobalConfig {
    private static final Config EMPTY = Config.empty();
    private static final LazyValue<Config> DEFAULT_CONFIG = LazyValue.create(() -> {
        List providers = HelidonServiceLoader.create(ServiceLoader.load(ConfigProvider.class)).asList();
        if (providers.isEmpty()) {
            return EMPTY;
        }
        return ((ConfigProvider)providers.get(0)).create();
    });
    private static final AtomicReference<Config> CONFIG = new AtomicReference();

    private GlobalConfig() {
    }

    public static boolean configured() {
        return CONFIG.get() != null;
    }

    public static Config config() {
        return GlobalConfig.configured() ? CONFIG.get() : (Config)DEFAULT_CONFIG.get();
    }

    public static Config config(Supplier<Config> config) {
        return GlobalConfig.config(config, false);
    }

    public static Config config(Supplier<Config> config, boolean overwrite) {
        Objects.requireNonNull(config);
        if (overwrite || !GlobalConfig.configured()) {
            CONFIG.set(config.get());
        }
        return CONFIG.get();
    }
}

