/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.compiler;

import jakarta.servlet.jsp.tagext.FunctionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.Compiler;
import org.glassfish.wasp.compiler.ELNode;
import org.glassfish.wasp.compiler.Node;

public class ELFunctionMapper {
    private int currFunc = 0;
    StringBuilder ds;
    StringBuilder ss;

    public static void map(Compiler compiler, Node.Nodes page) throws WaspException {
        ELFunctionMapper map = new ELFunctionMapper();
        map.ds = new StringBuilder();
        map.ss = new StringBuilder();
        page.visit(map.new ELFunctionVisitor());
        String ds = map.ds.toString();
        if (ds.length() > 0) {
            Node.Root root = page.getRoot();
            new Node.Declaration(map.ss.toString(), null, root);
            new Node.Declaration("static {\n" + ds + "}\n", null, root);
        }
    }

    class ELFunctionVisitor
    extends Node.Visitor {
        private HashMap<String, String> gMap = new HashMap();

        ELFunctionVisitor() {
        }

        @Override
        public void visit(Node.ParamAction n) throws WaspException {
            this.doMap(n.getValue());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.IncludeAction n) throws WaspException {
            this.doMap(n.getPage());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.ForwardAction n) throws WaspException {
            this.doMap(n.getPage());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.SetProperty n) throws WaspException {
            this.doMap(n.getValue());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.UseBean n) throws WaspException {
            this.doMap(n.getBeanName());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.PlugIn n) throws WaspException {
            this.doMap(n.getHeight());
            this.doMap(n.getWidth());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.JspElement n) throws WaspException {
            Node.JspAttribute[] attrs = n.getJspAttributes();
            for (int i = 0; attrs != null && i < attrs.length; ++i) {
                this.doMap(attrs[i]);
            }
            this.doMap(n.getNameAttribute());
            this.visitBody(n);
        }

        @Override
        public void visit(Node.UninterpretedTag n) throws WaspException {
            Node.JspAttribute[] attrs = n.getJspAttributes();
            for (int i = 0; attrs != null && i < attrs.length; ++i) {
                this.doMap(attrs[i]);
            }
            this.visitBody(n);
        }

        @Override
        public void visit(Node.CustomTag n) throws WaspException {
            Node.JspAttribute[] attrs = n.getJspAttributes();
            for (int i = 0; attrs != null && i < attrs.length; ++i) {
                this.doMap(attrs[i]);
            }
            this.visitBody(n);
        }

        @Override
        public void visit(Node.ELExpression n) throws WaspException {
            this.doMap(n.getEL());
        }

        private void doMap(Node.JspAttribute attr) throws WaspException {
            if (attr != null) {
                this.doMap(attr.getEL());
            }
        }

        private void doMap(ELNode.Nodes el) throws WaspException {
            if (el == null) {
                return;
            }
            class Fvisitor
            extends ELNode.Visitor {
                ArrayList<ELNode.Function> funcs = new ArrayList();
                Set<String> keys = new HashSet<String>();

                Fvisitor() {
                }

                @Override
                public void visit(ELNode.Function n) throws WaspException {
                    if (n.getUri() == null) {
                        return;
                    }
                    String key = n.getPrefix() + ":" + n.getName();
                    if (!this.keys.contains(key)) {
                        this.keys.add(key);
                        this.funcs.add(n);
                    }
                }
            }
            Fvisitor fv = new Fvisitor();
            el.visit(fv);
            ArrayList<ELNode.Function> functions = fv.funcs;
            if (functions.size() == 0) {
                return;
            }
            String decName = this.matchMap(functions);
            if (decName != null) {
                el.setMapName(decName);
                return;
            }
            decName = this.getMapName();
            ELFunctionMapper.this.ss.append("static private org.glassfish.wasp.runtime.ProtectedFunctionMapper " + decName + ";\n");
            ELFunctionMapper.this.ds.append("  " + decName + "= ");
            ELFunctionMapper.this.ds.append("org.glassfish.wasp.runtime.ProtectedFunctionMapper");
            Object funcMethod = null;
            if (functions.size() == 1) {
                funcMethod = ".getMapForFunction";
            } else {
                ELFunctionMapper.this.ds.append(".getInstance();\n");
                funcMethod = "  " + decName + ".mapFunction";
            }
            for (int i = 0; i < functions.size(); ++i) {
                ELNode.Function f = functions.get(i);
                FunctionInfo funcInfo = f.getFunctionInfo();
                String key = f.getPrefix() + ":" + f.getName();
                ELFunctionMapper.this.ds.append((String)funcMethod + "(\"" + key + "\", " + funcInfo.getFunctionClass() + ".class, \"" + f.getMethodName() + "\", new Class[] {");
                String[] params = f.getParameters();
                for (int k = 0; k < params.length; ++k) {
                    int iArray;
                    if (k != 0) {
                        ELFunctionMapper.this.ds.append(", ");
                    }
                    if ((iArray = params[k].indexOf(91)) < 0) {
                        ELFunctionMapper.this.ds.append(params[k] + ".class");
                        continue;
                    }
                    String baseType = params[k].substring(0, iArray);
                    ELFunctionMapper.this.ds.append("java.lang.reflect.Array.newInstance(");
                    ELFunctionMapper.this.ds.append(baseType);
                    ELFunctionMapper.this.ds.append(".class,");
                    int aCount = 0;
                    for (int jj = iArray; jj < params[k].length(); ++jj) {
                        if (params[k].charAt(jj) != '[') continue;
                        ++aCount;
                    }
                    if (aCount == 1) {
                        ELFunctionMapper.this.ds.append("0).getClass()");
                        continue;
                    }
                    ELFunctionMapper.this.ds.append("new int[" + aCount + "]).getClass()");
                }
                ELFunctionMapper.this.ds.append("});\n");
                this.gMap.put(f.getPrefix() + ":" + f.getName() + ":" + f.getUri(), decName);
            }
            el.setMapName(decName);
        }

        private String matchMap(ArrayList<ELNode.Function> functions) {
            String mapName = null;
            for (int i = 0; i < functions.size(); ++i) {
                ELNode.Function f = functions.get(i);
                String temName = this.gMap.get(f.getPrefix() + ":" + f.getName() + ":" + f.getUri());
                if (temName == null) {
                    return null;
                }
                if (mapName == null) {
                    mapName = temName;
                    continue;
                }
                if (temName.equals(mapName)) continue;
                return null;
            }
            return mapName;
        }

        private String getMapName() {
            return "_jspx_fnmap_" + ELFunctionMapper.this.currFunc++;
        }
    }
}

