/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-commands")
@Singleton
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-commands", description="list-commands")})
@AccessRequired(resource={"domain"}, action={"read"})
public class ListCommandsCommand
implements AdminCommand {
    private static final String MODE = "mode";
    private static final String DEBUG = "debug";
    @Inject
    ServiceLocator habitat;

    public void execute(AdminCommandContext context) {
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ActionReport report = context.getActionReport();
        report.getTopMessagePart().setChildrenType("Command");
        for (String name : this.sortedAdminCommands()) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(name);
        }
    }

    protected String getScope() {
        return null;
    }

    private List<String> sortedAdminCommands() {
        String scope = this.getScope();
        ArrayList<String> names = new ArrayList<String>();
        for (ServiceHandle command : this.habitat.getAllServiceHandles(AdminCommand.class, new Annotation[0])) {
            String name = command.getActiveDescriptor().getName();
            if (name == null) continue;
            int ci = name.indexOf("/");
            if (ci != -1) {
                String cmdScope = name.substring(0, ci + 1);
                if (scope == null || !cmdScope.equals(scope)) continue;
                name = name.substring(ci + 1);
            } else if (scope != null) continue;
            if (ListCommandsCommand.debugCommand(command)) {
                if (!ListCommandsCommand.debugSet()) continue;
                names.add(name);
                continue;
            }
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }

    private static boolean debugCommand(ServiceHandle<?> command) {
        ActiveDescriptor ad = command.getActiveDescriptor();
        Map metadata = ad.getMetadata();
        List modes = (List)metadata.get(MODE);
        if (modes == null) {
            return false;
        }
        for (String mode : modes) {
            if (!DEBUG.equals(mode)) continue;
            return true;
        }
        return false;
    }

    private static boolean debugSet() {
        String s = System.getenv("AS_DEBUG");
        return Boolean.valueOf(s);
    }
}

