/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.connector.annotation.handlers;

import com.sun.enterprise.deployment.Addressing;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.RespectBinding;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.annotation.context.AppClientContext;
import com.sun.enterprise.deployment.annotation.context.ServiceReferenceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.util.StringUtils;
import jakarta.jws.HandlerChain;
import jakarta.xml.ws.WebServiceClient;
import jakarta.xml.ws.WebServiceRef;
import jakarta.xml.ws.soap.MTOM;
import jakarta.xml.ws.spi.WebServiceFeatureAnnotation;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.webservices.connector.annotation.handlers.HandlerChainHandler;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=WebServiceRef.class)
public class WebServiceRefHandler
extends AbstractHandler {
    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }

    protected HandlerProcessingResult processAWsRef(AnnotationInfo annInfo, WebServiceRef annotation) throws AnnotationProcessorException {
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        AnnotatedElement annElem = annInfo.getAnnotatedElement();
        Class<?> annotatedType = null;
        Class declaringClass = null;
        InjectionTarget target = null;
        String defaultServiceRefName = null;
        if (annInfo.getElementType().equals((Object)ElementType.FIELD)) {
            Field annotatedField = (Field)annElem;
            if (annCtx instanceof AppClientContext && !Modifier.isStatic(annotatedField.getModifiers())) {
                throw new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.injectionfieldnotstatic", "Injection fields for application clients must be declared STATIC"), annInfo);
            }
            annotatedType = annotatedField.getType();
            declaringClass = annotatedField.getDeclaringClass();
            defaultServiceRefName = declaringClass.getName() + "/" + annotatedField.getName();
            target = new InjectionTarget();
            target.setFieldName(annotatedField.getName());
            target.setClassName(annotatedField.getDeclaringClass().getName());
        } else if (annInfo.getElementType().equals((Object)ElementType.METHOD)) {
            Method annotatedMethod = (Method)annElem;
            this.validateInjectionMethod(annotatedMethod, annInfo);
            if (annCtx instanceof AppClientContext && !Modifier.isStatic(annotatedMethod.getModifiers())) {
                throw new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.injectionmethodnotstatic", "Injection methods for application clients must be declared STATIC"), annInfo);
            }
            annotatedType = annotatedMethod.getParameterTypes()[0];
            declaringClass = annotatedMethod.getDeclaringClass();
            String propertyName = this.getInjectionMethodPropertyName(annotatedMethod, annInfo);
            defaultServiceRefName = declaringClass.getName() + "/" + propertyName;
            target = new InjectionTarget();
            target.setMethodName(annotatedMethod.getName());
            target.setClassName(annotatedMethod.getDeclaringClass().getName());
        } else if (annInfo.getElementType().equals((Object)ElementType.TYPE)) {
            if (!StringUtils.ok((String)annotation.name())) {
                throw new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.nonametypelevel", "TYPE-Level annotation  must specify name member."), annInfo);
            }
            annotatedType = annotation.type();
            if (annotatedType == null || annotatedType == Object.class) {
                throw new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.typenotfound", "TYPE-level annotation symbol must specify type member."), annInfo);
            }
            declaringClass = (Class)annElem;
        } else {
            throw new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.invalidtype", "annotation not allowed on this element."), annInfo);
        }
        MTOM mtom = null;
        jakarta.xml.ws.soap.Addressing addressing = null;
        jakarta.xml.ws.RespectBinding respectBinding = null;
        HashMap<Class<? extends Annotation>, Annotation> otherAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation a : annElem.getAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(WebServiceFeatureAnnotation.class)) continue;
            if (a instanceof MTOM) {
                mtom = (MTOM)a;
                continue;
            }
            if (a instanceof jakarta.xml.ws.soap.Addressing) {
                addressing = (jakarta.xml.ws.soap.Addressing)a;
                continue;
            }
            if (a instanceof jakarta.xml.ws.RespectBinding) {
                respectBinding = (jakarta.xml.ws.RespectBinding)a;
                continue;
            }
            if (otherAnnotations.containsKey(a.getClass())) continue;
            otherAnnotations.put(a.getClass(), a);
        }
        Object serviceRefName = !StringUtils.ok((String)annotation.name()) ? defaultServiceRefName : annotation.name();
        ServiceReferenceContainer[] containers = null;
        if (annCtx instanceof ServiceReferenceContainerContext) {
            containers = ((ServiceReferenceContainerContext)annCtx).getServiceRefContainers();
        }
        if (containers == null || containers.length == 0) {
            annInfo.getProcessingContext().getErrorHandler().fine(new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.invalidannotationforthisclass", "Illegal annotation symbol for this class will be ignored"), annInfo));
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        for (ServiceReferenceContainer container : containers) {
            WebServiceClient wsclientAnn;
            Map<Class<? extends Annotation>, Annotation> oa;
            ServiceReferenceDescriptor aRef = null;
            try {
                aRef = container.getServiceReferenceByName((String)serviceRefName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (aRef == null) {
                aRef = new ServiceReferenceDescriptor();
                aRef.setName((String)serviceRefName);
                container.addServiceReferenceDescriptor(aRef);
            }
            if ((oa = aRef.getOtherAnnotations()) == null) {
                aRef.setOtherAnnotations(otherAnnotations);
            } else {
                for (Map.Entry entry : otherAnnotations.entrySet()) {
                    if (oa.containsKey(entry.getKey())) continue;
                    oa.put((Class)entry.getKey(), (Annotation)entry.getValue());
                }
            }
            if (!StringUtils.ok((String)aRef.getWsdlFileUri()) && StringUtils.ok((String)annotation.wsdlLocation())) {
                aRef.setWsdlFileUri(annotation.wsdlLocation());
            }
            if (!aRef.hasMtomEnabled() && mtom != null) {
                aRef.setMtomEnabled(mtom.enabled());
                aRef.setMtomThreshold(mtom.threshold());
            }
            if (aRef.getAddressing() == null && addressing != null) {
                aRef.setAddressing(new Addressing(addressing.enabled(), addressing.required(), addressing.responses().toString()));
            }
            if (aRef.getRespectBinding() == null && respectBinding != null) {
                aRef.setRespectBinding(new RespectBinding(respectBinding.enabled()));
            }
            if ((aRef.getMappedName() == null || aRef.getMappedName().isEmpty()) && StringUtils.ok((String)annotation.mappedName())) {
                aRef.setMappedName(new SimpleJndiName(annotation.mappedName()));
            }
            if (!aRef.hasLookupName() && StringUtils.ok((String)annotation.lookup())) {
                aRef.setLookupName(new SimpleJndiName(annotation.lookup()));
            }
            aRef.setInjectResourceType("jakarta.jws.WebServiceRef");
            if (target != null) {
                aRef.addInjectionTarget(target);
            }
            if (!Object.class.equals((Object)annotation.value()) && !jakarta.xml.ws.Service.class.equals((Object)annotation.value())) {
                if (aRef.getServiceInterface() == null) {
                    aRef.setServiceInterface(annotation.value().getName());
                }
                if (aRef.getPortInfoBySEI(annotatedType.getName()) == null) {
                    ServiceRefPortInfo portInfo = new ServiceRefPortInfo();
                    portInfo.setServiceEndpointInterface(annotatedType.getName());
                    aRef.addPortInfo(portInfo);
                }
                if (aRef.getInjectionTargetType() == null) {
                    aRef.setInjectionTargetType(annotatedType.getName());
                }
                wsclientAnn = annotation.value().getAnnotation(WebServiceClient.class);
            } else {
                wsclientAnn = annotatedType.getAnnotation(WebServiceClient.class);
            }
            if (wsclientAnn == null) {
                throw new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.classnotannotated", "Class must be annotated with a {1} annotation\n symbol : {1}\n location: {0}", new Object[]{annotatedType.toString(), WebServiceClient.class.toString()}));
            }
            if (aRef.getWsdlFileUri() == null) {
                aRef.setWsdlFileUri(wsclientAnn.wsdlLocation());
            }
            if (aRef.getServiceName() == null) {
                aRef.setServiceNamespaceUri(wsclientAnn.targetNamespace());
                aRef.setServiceLocalPart(wsclientAnn.name());
            }
            if (aRef.getServiceInterface() != null) continue;
            aRef.setServiceInterface(annotatedType.getName());
        }
        if (annElem.getAnnotation(HandlerChain.class) == null) {
            return new HandlerChainHandler().processHandlerChainAnnotation(annInfo, annCtx, annotatedType, declaringClass, false);
        }
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo annInfo) throws AnnotationProcessorException {
        WebServiceRef annotation = (WebServiceRef)annInfo.getAnnotation();
        return this.processAWsRef(annInfo, annotation);
    }
}

