/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.jws.boot;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.Security;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.glassfish.appclient.client.jws.boot.ClassPathManager;
import org.glassfish.appclient.client.jws.boot.ErrorDisplayDialog;
import org.glassfish.main.jdke.cl.GlassfishUrlClassLoader;
import org.glassfish.main.jdke.props.SystemProperties;

public class JWSACCMain
implements Runnable {
    private static final String JWSACC_ARGUMENT_PREFIX = "-jwsacc";
    private static final String JWSACC_EXIT_AFTER_RETURN = "ExitAfterReturn";
    private static final String JWSACC_FORCE_ERROR = "ForceError";
    private static final String JWSACC_KEEP_JWS_CLASS_LOADER = "KeepJWSClassLoader";
    private static final String JWSACC_RUN_ON_SWING_THREAD = "RunOnSwingThread";
    private static boolean exitAfterReturn;
    private static boolean keepJWSClassLoader;
    private static boolean runOnSwingThread;
    private static ClassPathManager classPathManager;
    private static URL[] downloadedJarURLs;
    private static URL[] persistenceJarURLs;
    private static final ResourceBundle rb;
    private final String[] args;

    public JWSACCMain(String[] args) {
        this.args = args;
    }

    public static void main(String[] args) {
        try {
            args = JWSACCMain.prepareJWSArgs(args);
            try {
                classPathManager = JWSACCMain.getClassPathManager();
                downloadedJarURLs = classPathManager.locateDownloadedJars();
                persistenceJarURLs = classPathManager.locatePersistenceJARs();
            }
            catch (Throwable thr) {
                throw new IllegalArgumentException(rb.getString("jwsacc.errorLocJARs"), thr);
            }
            JWSACCMain jwsACCMain = new JWSACCMain(args);
            if (runOnSwingThread) {
                SwingUtilities.invokeAndWait(jwsACCMain);
            } else {
                jwsACCMain.run();
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            System.exit(1);
        }
    }

    private static String dotToSlash(String orig) {
        return orig.replaceAll("\\.", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: {
            Runnable exit;
            block8: {
                int exitValue = 0;
                try {
                    File downloadedAppclientJarFile = this.findAppClientFileForJWSLaunch(this.getClass().getClassLoader());
                    ClassLoader loader = JWSACCMain.prepareClassLoader(downloadedAppclientJarFile);
                    SystemProperties.setProperty((String)"com.sun.aas.downloaded.appclient.jar", (String)downloadedAppclientJarFile.getAbsolutePath(), (boolean)true);
                    Thread.currentThread().setContextClassLoader(loader);
                    System.err.println("XXXX: JWSACCMain.run set CL to thread: " + String.valueOf(loader));
                    Class<?> mainClass = Class.forName("com.sun.enterprise.appclient.MainWithModuleSupport", true, loader);
                    Constructor<?> constr = mainClass.getDeclaredConstructor(String[].class, URL[].class);
                    constr.newInstance(this.args, persistenceJarURLs);
                    if (!exitAfterReturn && exitValue == 0) break block7;
                    exit = new Runnable(this){
                        private int statusValue;

                        @Override
                        public void run() {
                            System.out.printf("Exiting after return from client with status %1$d%n", this.statusValue);
                            System.exit(this.statusValue);
                        }

                        public Runnable init(int exitStatus) {
                            this.statusValue = exitStatus;
                            return this;
                        }
                    }.init(exitValue);
                    if (!runOnSwingThread) break block8;
                }
                catch (Throwable thr) {
                    Runnable exit2;
                    block9: {
                        try {
                            exitValue = 1;
                            System.err.println(rb.getString("jwsacc.errorLaunch"));
                            System.err.println(thr.toString());
                            thr.printStackTrace();
                            ErrorDisplayDialog.showErrors(thr, rb);
                            if (!exitAfterReturn && exitValue == 0) break block7;
                            exit2 = new /* invalid duplicate definition of identical inner class */.init(exitValue);
                            if (!runOnSwingThread) break block9;
                        }
                        catch (Throwable throwable) {
                            if (exitAfterReturn || exitValue != 0) {
                                Runnable exit3 = new /* invalid duplicate definition of identical inner class */.init(exitValue);
                                if (runOnSwingThread) {
                                    SwingUtilities.invokeLater(exit3);
                                } else {
                                    exit3.run();
                                }
                            }
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(exit2);
                    }
                    exit2.run();
                }
                SwingUtilities.invokeLater(exit);
                break block7;
            }
            exit.run();
        }
    }

    private static String[] prepareJWSArgs(String[] args) {
        Vector<String> JWSACCArgs = new Vector<String>();
        Vector<String> nonJWSACCArgs = new Vector<String>();
        for (String arg : args) {
            if (arg.startsWith(JWSACC_ARGUMENT_PREFIX)) {
                JWSACCArgs.add(arg.substring(JWSACC_ARGUMENT_PREFIX.length()));
                continue;
            }
            nonJWSACCArgs.add(arg);
        }
        JWSACCMain.processJWSArgs(JWSACCArgs);
        return nonJWSACCArgs.toArray(new String[nonJWSACCArgs.size()]);
    }

    private static void processJWSArgs(Vector<String> args) {
        for (String arg : args) {
            if (arg.equals(JWSACC_EXIT_AFTER_RETURN)) {
                exitAfterReturn = true;
                continue;
            }
            if (arg.equals(JWSACC_FORCE_ERROR)) {
                throw new RuntimeException("Forced error - testing only");
            }
            if (arg.equals(JWSACC_KEEP_JWS_CLASS_LOADER)) {
                keepJWSClassLoader = true;
                continue;
            }
            if (!arg.equals(JWSACC_RUN_ON_SWING_THREAD)) continue;
            runOnSwingThread = true;
        }
    }

    public static int firstFreePolicyIndex() {
        String propValue;
        int i = 0;
        while ((propValue = Security.getProperty("policy.url." + String.valueOf(++i))) != null && !propValue.equals("")) {
        }
        return i;
    }

    private static ClassLoader prepareClassLoader(File downloadedAppclientJarFile) {
        return new GlassfishUrlClassLoader("JWS-ACC", downloadedJarURLs, classPathManager.getParentClassLoader());
    }

    private static File findContainingJar(String target, ClassLoader loader) throws Exception {
        File result = null;
        URL resourceURL = loader.getResource(target);
        if (resourceURL != null) {
            result = classPathManager.findContainingJar(resourceURL);
        }
        return result;
    }

    private File findAppClientFileForJWSLaunch(ClassLoader loader) throws Exception {
        File containingJar = JWSACCMain.findContainingJar("META-INF/application.xml", loader);
        if (containingJar == null) {
            containingJar = JWSACCMain.findContainingJar("META-INF/application-client.xml", loader);
        }
        if (containingJar == null) {
            throw new IllegalArgumentException("Could not locate META-INF/application.xml or META-INF/application-client.xml");
        }
        return containingJar;
    }

    public static ClassPathManager getClassPathManager() {
        return ClassPathManager.getClassPathManager(keepJWSClassLoader);
    }

    static {
        rb = ResourceBundle.getBundle(JWSACCMain.dotToSlash(JWSACCMain.class.getPackage().getName() + ".LocalStrings"));
    }
}

