/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.I18n;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.api.ResourceAttributes;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="resource-adapter-config")
@PerLookup
@I18n(value="create.resource.adapter.config")
public class ResourceAdapterConfigManager
implements ResourceManager {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(ResourceAdapterConfigManager.class);
    private String raName;
    private String threadPoolIds;
    private String objectType = "user";
    private String name;

    public String getResourceType() {
        return "resource-adapter-config";
    }

    public ResourceStatus create(Resources resources, ResourceAttributes attributes, final Properties properties, String target) throws Exception {
        this.setParams(attributes);
        ResourceStatus validationStatus = this.isValid(resources);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ResourceAdapterConfig newResource = ResourceAdapterConfigManager.this.createConfigBean(param, properties);
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)resources);
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(ResourceAdapterConfigManager.class.getName()).log(Level.SEVERE, "TransactionFailure: create-resource-adapter-config", tfe);
            String msg = I18N.getLocalString("create.resource.adapter.config.fail", "Unable to create resource adapter config", new Object[]{this.raName}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg);
        }
        String msg = I18N.getLocalString("create.resource.adapter.config.success", "Resource adapter config {0} created successfully", new Object[]{this.raName});
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources) {
        ResourceStatus status = new ResourceStatus(0, "Validation Successful");
        if (this.raName == null) {
            String msg = I18N.getLocalString("create.resource.adapter.confignoRAName", "No RA Name defined for resource adapter config.");
            return new ResourceStatus(1, msg);
        }
        if (resources.getResourceByName(ResourceAdapterConfig.class, new SimpleJndiName(this.raName)) != null) {
            String msg = I18N.getLocalString("create.resource.adapter.config.duplicate", "Resource adapter config already exists for RAR", new Object[]{this.raName});
            return new ResourceStatus(1, msg);
        }
        return status;
    }

    private ResourceAdapterConfig createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ResourceAdapterConfig newResource = (ResourceAdapterConfig)param.createChild(ResourceAdapterConfig.class);
        newResource.setResourceAdapterName(this.raName);
        if (this.threadPoolIds != null) {
            newResource.setThreadPoolIds(this.threadPoolIds);
        }
        newResource.setObjectType(this.objectType);
        if (this.name != null) {
            newResource.setName(this.name);
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    public void setParams(ResourceAttributes attributes) {
        this.raName = attributes.getString("resource-adapter-name");
        this.name = attributes.getString("name");
        this.threadPoolIds = attributes.getString("thread-pool-ids");
        this.objectType = attributes.getString("object-type");
    }

    public Resource createConfigBean(Resources resources, ResourceAttributes attributes, Properties properties, boolean validate) throws Exception {
        this.setParams(attributes);
        ResourceStatus status = validate ? this.isValid(resources) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage(), status.getException());
    }
}

