/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.messageinterpolation.parser;

import java.util.List;
import org.hibernate.validator.internal.engine.messageinterpolation.parser.MessageDescriptorFormatException;
import org.hibernate.validator.internal.engine.messageinterpolation.parser.Token;

public class TokenIterator {
    private final List<Token> tokenList;
    private final String originalMessage;
    private StringBuilder messageBuilder;
    private int currentPosition;
    private Token currentToken;
    private boolean allInterpolationTermsProcessed;
    private boolean currentTokenAvailable;

    public TokenIterator(String originalMessage, List<Token> tokens) {
        this.tokenList = tokens;
        this.originalMessage = originalMessage;
    }

    public boolean hasMoreInterpolationTerms() throws MessageDescriptorFormatException {
        while (this.currentPosition < this.tokenList.size()) {
            this.currentToken = this.tokenList.get(this.currentPosition);
            ++this.currentPosition;
            if (this.currentToken.isParameter()) {
                this.currentTokenAvailable = true;
                return true;
            }
            if (this.messageBuilder == null) continue;
            this.messageBuilder.append(this.currentToken.getTokenValue());
        }
        this.allInterpolationTermsProcessed = true;
        return false;
    }

    public String nextInterpolationTerm() {
        if (!this.currentTokenAvailable) {
            throw new IllegalStateException("Trying to call #nextInterpolationTerm without calling #hasMoreInterpolationTerms");
        }
        this.currentTokenAvailable = false;
        return this.currentToken.getTokenValue();
    }

    public void replaceCurrentInterpolationTerm(String replacement) {
        if (!this.currentToken.getTokenValue().equals(replacement) && this.messageBuilder == null) {
            this.messageBuilder = new StringBuilder();
            for (int i = 0; i < this.currentPosition - 1; ++i) {
                this.messageBuilder.append(this.tokenList.get(i).getTokenValue());
            }
        }
        if (this.messageBuilder != null) {
            this.messageBuilder.append(replacement);
        }
    }

    public String getInterpolatedMessage() {
        if (!this.allInterpolationTermsProcessed) {
            throw new IllegalStateException("Not all interpolation terms have been processed yet.");
        }
        return this.messageBuilder != null ? this.messageBuilder.toString() : this.originalMessage;
    }
}

