/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Limit;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.log.Logger;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.xact.BeginXact;
import org.apache.derby.impl.store.raw.xact.EndXact;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.LockCount;
import org.apache.derby.impl.store.raw.xact.RowLocking3Escalate;
import org.apache.derby.impl.store.raw.xact.SavePoint;
import org.apache.derby.impl.store.raw.xact.TransactionTable;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.XactContext;
import org.apache.derby.impl.store.raw.xact.XactFactory;
import org.apache.derby.impl.store.raw.xact.XactId;
import org.apache.derby.shared.common.error.StandardException;

public class Xact
extends RawTransaction
implements Limit,
LockOwner {
    protected static final int CLOSED = 0;
    protected static final int IDLE = 1;
    protected static final int ACTIVE = 2;
    protected static final int UPDATE = 3;
    protected static final int PREPARED = 4;
    public static final int END_ABORTED = 1;
    public static final int END_PREPARED = 2;
    public static final int END_COMMITTED = 4;
    public static final int RECOVERY_ROLLBACK_FIRST = 16;
    public static final int INTERNAL_TRANSACTION = 32;
    public static final int NESTED_TOP_TRANSACTION = 64;
    private static final int COMMIT_SYNC = 65536;
    private static final int COMMIT_NO_SYNC = 131072;
    private static final int COMMIT_PREPARE = 262144;
    private int savedEndStatus;
    private boolean needSync;
    private boolean justCreated = true;
    protected XactContext xc;
    protected final XactFactory xactFactory;
    protected final DataFactory dataFactory;
    protected final LogFactory logFactory;
    protected final DataValueFactory dataValueFactory;
    private final CompatibilitySpace compatibilitySpace;
    private LockingPolicy defaultLocking;
    private GlobalTransactionId myGlobalId;
    private volatile TransactionId myId;
    private volatile TransactionId parentTransactionId;
    protected Logger logger;
    protected volatile int state;
    private Integer inComplete = null;
    private boolean seenUpdates;
    private boolean inPostCommitProcessing;
    private LogInstant logStart;
    private LogInstant logLast;
    private Stack<SavePoint> savePoints;
    protected List<Serviceable> postCommitWorks;
    protected List<Serviceable> postAbortWorks;
    protected List<Serviceable> postTerminationWorks;
    private boolean recoveryTransaction;
    DynamicByteArrayOutputStream logBuffer;
    private boolean postCompleteMode;
    private boolean sanityCheck_xaclosed;
    private String transName;
    private boolean readOnly;
    private boolean flush_log_on_xact_end;
    private boolean backupBlocked;
    private boolean dontWaitForLocks;

    protected Xact(XactFactory xactFactory, Xact xact, LogFactory logFactory, DataFactory dataFactory, DataValueFactory dataValueFactory, boolean bl, CompatibilitySpace compatibilitySpace, boolean bl2) {
        this.xactFactory = xactFactory;
        if (xact != null) {
            this.parentTransactionId = xact.getId();
        }
        this.logFactory = logFactory;
        this.dataFactory = dataFactory;
        this.dataValueFactory = dataValueFactory;
        this.readOnly = bl;
        this.flush_log_on_xact_end = bl2;
        this.compatibilitySpace = compatibilitySpace == null ? this.getLockFactory().createCompatibilitySpace(this) : compatibilitySpace;
        this.resetDefaultLocking();
        xactFactory.setNewTransactionId(null, this);
        this.setIdleState();
        this.backupBlocked = false;
    }

    @Override
    public final LockFactory getLockFactory() {
        return this.xactFactory.getLockFactory();
    }

    @Override
    public final DataFactory getDataFactory() {
        return this.dataFactory;
    }

    @Override
    public final LogFactory getLogFactory() {
        return this.logFactory;
    }

    @Override
    public boolean anyoneBlocked() {
        return this.getLockFactory().anyoneBlocked();
    }

    @Override
    public DynamicByteArrayOutputStream getLogBuffer() {
        if (this.logBuffer == null) {
            this.logBuffer = new DynamicByteArrayOutputStream(1024);
        } else {
            this.logBuffer.reset();
        }
        return this.logBuffer;
    }

    @Override
    public void logAndUndo(Compensation compensation, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        SavePoint savePoint;
        this.setActiveState();
        if (this.state == 2) {
            this.setUpdateState();
        }
        this.seenUpdates = true;
        LogInstant logInstant2 = this.logger.logAndUndo(this, compensation, logInstant, limitObjectInput);
        this.setLastLogInstant(logInstant2);
        if (this.savePoints != null && !this.savePoints.empty() && (savePoint = this.savePoints.peek()).getSavePoint() == null) {
            savePoint.setSavePoint(logInstant2);
        }
    }

    @Override
    public void addUpdateTransaction(int n) {
        if (this.myId != null) {
            this.xactFactory.addUpdateTransaction(this.myId, this, n);
        }
    }

    @Override
    public void removeUpdateTransaction() {
        if (this.myId != null) {
            this.xactFactory.removeUpdateTransaction(this.myId);
        }
    }

    @Override
    public void prepareTransaction() {
        if (this.myId != null) {
            this.xactFactory.prepareTransaction(this.myId);
        }
    }

    @Override
    public void setFirstLogInstant(LogInstant logInstant) {
        this.logStart = logInstant;
    }

    @Override
    public LogInstant getFirstLogInstant() {
        return this.logStart;
    }

    @Override
    public void setLastLogInstant(LogInstant logInstant) {
        this.logLast = logInstant;
    }

    @Override
    public LogInstant getLastLogInstant() {
        return this.logLast;
    }

    void setTransactionId(GlobalTransactionId globalTransactionId, TransactionId transactionId) {
        this.myGlobalId = globalTransactionId;
        this.myId = transactionId;
    }

    @Override
    public void setTransactionId(Loggable loggable, TransactionId transactionId) {
        this.myId = transactionId;
        this.myGlobalId = ((BeginXact)loggable).getGlobalId();
    }

    @Override
    public void setup(PersistentSet persistentSet) throws StandardException {
        int n = PropertyUtil.getServiceInt(persistentSet, "derby.locks.escalationThreshold", 100, Integer.MAX_VALUE, 5000);
        this.getLockFactory().setLimit(this.compatibilitySpace, this, n, this);
    }

    @Override
    public final GlobalTransactionId getGlobalId() {
        return this.myGlobalId;
    }

    @Override
    public final ContextManager getContextManager() {
        return this.xc.getContextManager();
    }

    @Override
    public final CompatibilitySpace getCompatibilitySpace() {
        return this.compatibilitySpace;
    }

    @Override
    public boolean noWait() {
        return this.dontWaitForLocks;
    }

    @Override
    public void setNoLockWait(boolean bl) {
        this.dontWaitForLocks = bl;
    }

    @Override
    public final TransactionId getId() {
        return this.myId;
    }

    protected final TransactionId getIdNoCheck() {
        return this.myId;
    }

    public final String getContextId() {
        XactContext xactContext = this.xc;
        return xactContext == null ? null : xactContext.getIdName();
    }

    @Override
    public LockingPolicy getDefaultLockingPolicy() {
        return this.defaultLocking;
    }

    @Override
    public final LockingPolicy newLockingPolicy(int n, int n2, boolean bl) {
        return this.xactFactory.getLockingPolicy(n, n2, bl);
    }

    @Override
    public final void setDefaultLockingPolicy(LockingPolicy lockingPolicy) {
        if (lockingPolicy == null) {
            lockingPolicy = this.xactFactory.getLockingPolicy(0, 0, false);
        }
        this.defaultLocking = lockingPolicy;
    }

    @Override
    public LogInstant commit() throws StandardException {
        return this.commit(65536);
    }

    @Override
    public LogInstant commitNoSync(int n) throws StandardException {
        if (this.state == 1 && this.savePoints == null && (n & 4) != 0) {
            return null;
        }
        return this.commit(0x20000 | n);
    }

    private LogInstant prepareCommit(int n) throws StandardException {
        LogInstant logInstant = null;
        if (this.state == 0) {
            throw StandardException.newException("40XT8", this.toInternalDetailString());
        }
        try {
            this.preComplete(COMMIT);
            if (this.seenUpdates) {
                EndXact endXact = new EndXact(this.getGlobalId(), ((n & 0x40000) == 0 ? 4 : 2) | this.statusForEndXactLog());
                logInstant = this.logger.logAndDo(this, endXact);
                if (this.flush_log_on_xact_end) {
                    if ((n & 0x10000) == 0) {
                        this.needSync = true;
                    } else {
                        this.logger.flush(logInstant);
                        this.needSync = false;
                    }
                }
            } else if (this.needSync && (n & 0x10000) != 0) {
                this.logger.flushAll();
                this.needSync = false;
            }
        }
        catch (StandardException standardException) {
            if (standardException.getSeverity() < 30000) {
                throw StandardException.newException("40XT1", standardException, new Object[0]);
            }
            throw standardException;
        }
        return logInstant;
    }

    private void completeCommit(int n) throws StandardException {
        this.postComplete(n, COMMIT);
        if ((n & 2) == 0) {
            this.postTermination();
        } else {
            this.setActiveState();
        }
        this.myGlobalId = null;
    }

    private LogInstant commit(int n) throws StandardException {
        LogInstant logInstant = this.prepareCommit(n);
        this.completeCommit(n);
        return logInstant;
    }

    @Override
    public void abort() throws StandardException {
        if (this.state == 0) {
            return;
        }
        try {
            this.preComplete(ABORT);
            if (this.getFirstLogInstant() != null) {
                if (this.logger == null) {
                    throw StandardException.newException("XSTB3.M", new Object[0]);
                }
                this.logger.undo(this, this.getId(), this.getFirstLogInstant(), this.getLastLogInstant());
                EndXact endXact = new EndXact(this.getGlobalId(), 1 | this.statusForEndXactLog());
                this.logger.flush(this.logger.logAndDo(this, endXact));
            } else if (this.needSync) {
                this.logger.flushAll();
            }
            this.needSync = false;
        }
        catch (StandardException standardException) {
            if (standardException.getSeverity() < 50000) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSTB0.M", standardException, new Object[0]));
            }
            throw standardException;
        }
        this.postComplete(0, ABORT);
        if (this.postCommitWorks != null && !this.postCommitWorks.isEmpty()) {
            this.postCommitWorks.clear();
        }
        this.postTermination();
        this.myGlobalId = null;
    }

    @Override
    public void reprepare() throws StandardException {
        if (this.state == 0) {
            throw StandardException.newException("40XT8", this.toInternalDetailString());
        }
        try {
            if (this.logger == null) {
                throw StandardException.newException("XSTB3.M", new Object[0]);
            }
            this.state = 3;
            this.logger.reprepare(this, this.getId(), this.getFirstLogInstant(), this.getLastLogInstant());
            this.state = 4;
            this.seenUpdates = true;
        }
        catch (StandardException standardException) {
            if (standardException.getSeverity() < 50000) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSTB0.M", standardException, new Object[0]));
            }
            throw standardException;
        }
    }

    @Override
    public void destroy() throws StandardException {
        if (this.state != 0) {
            this.abort();
        }
        this.close();
    }

    @Override
    public void close() throws StandardException {
        switch (this.state) {
            case 0: {
                return;
            }
            case 1: {
                break;
            }
            default: {
                throw StandardException.newException("40XT4", new Object[0]);
            }
        }
        this.getLockFactory().clearLimit(this.compatibilitySpace, this);
        if (this.myId != null) {
            this.xactFactory.remove((XactId)this.myId);
        }
        this.xc.popMe();
        this.xc = null;
        this.myGlobalId = null;
        this.myId = null;
        this.logStart = null;
        this.logLast = null;
        this.state = 0;
    }

    @Override
    public void logAndDo(Loggable loggable) throws StandardException {
        LogInstant logInstant = null;
        if (this.logger == null) {
            this.getLogger();
        }
        if (this.logger == null) {
            throw StandardException.newException("XSTB2.M", new Object[0]);
        }
        this.setActiveState();
        if (this.state == 2) {
            logInstant = this.logger.logAndDo(this, new BeginXact(this.getGlobalId(), this.statusForBeginXactLog()));
            this.setUpdateState();
        }
        this.seenUpdates = true;
        if (loggable != null) {
            logInstant = this.logger.logAndDo(this, loggable);
            if (logInstant != null) {
                this.setLastLogInstant(logInstant);
                if (this.savePoints != null && !this.savePoints.empty()) {
                    SavePoint savePoint;
                    for (int i = this.savePoints.size() - 1; i >= 0 && (savePoint = (SavePoint)this.savePoints.elementAt(i)).getSavePoint() == null; --i) {
                        savePoint.setSavePoint(logInstant);
                    }
                }
            }
        } else if (logInstant != null) {
            this.setLastLogInstant(logInstant);
        }
    }

    @Override
    public void addPostCommitWork(Serviceable serviceable) {
        if (this.recoveryTransaction) {
            return;
        }
        if (this.postCommitWorks == null) {
            this.postCommitWorks = new ArrayList<Serviceable>(1);
        }
        this.postCommitWorks.add(serviceable);
    }

    @Override
    public void addPostAbortWork(Serviceable serviceable) {
        if (this.recoveryTransaction) {
            return;
        }
        if (this.postAbortWorks == null) {
            this.postAbortWorks = new ArrayList<Serviceable>(1);
        }
        this.postAbortWorks.add(serviceable);
    }

    @Override
    public void addPostTerminationWork(Serviceable serviceable) {
        if (this.recoveryTransaction) {
            return;
        }
        if (this.postTerminationWorks == null) {
            this.postTerminationWorks = new ArrayList<Serviceable>(2);
        }
        this.postTerminationWorks.add(serviceable);
    }

    @Override
    public ContainerHandle openContainer(ContainerKey containerKey, int n) throws StandardException {
        return this.openContainer(containerKey, this.defaultLockingPolicy(), n);
    }

    @Override
    public ContainerHandle openContainer(ContainerKey containerKey, LockingPolicy lockingPolicy, int n) throws StandardException {
        this.setActiveState();
        if (lockingPolicy == null) {
            lockingPolicy = this.xactFactory.getLockingPolicy(0, 0, false);
        }
        return this.dataFactory.openContainer(this, containerKey, lockingPolicy, n);
    }

    @Override
    public RawContainerHandle openDroppedContainer(ContainerKey containerKey, LockingPolicy lockingPolicy) throws StandardException {
        this.setActiveState();
        if (lockingPolicy == null) {
            lockingPolicy = this.xactFactory.getLockingPolicy(0, 0, false);
        }
        RawContainerHandle rawContainerHandle = null;
        try {
            rawContainerHandle = this.dataFactory.openDroppedContainer(this, containerKey, lockingPolicy, 4);
        }
        catch (StandardException standardException) {
            rawContainerHandle = this.dataFactory.openDroppedContainer(this, containerKey, lockingPolicy, 8);
        }
        return rawContainerHandle;
    }

    @Override
    public long addContainer(long l, long l2, int n, Properties properties, int n2) throws StandardException {
        this.setActiveState();
        return this.dataFactory.addContainer(this, l, l2, n, properties, n2);
    }

    @Override
    public long addAndLoadStreamContainer(long l, Properties properties, RowSource rowSource) throws StandardException {
        this.setActiveState();
        return this.dataFactory.addAndLoadStreamContainer(this, l, properties, rowSource);
    }

    @Override
    public StreamContainerHandle openStreamContainer(long l, long l2, boolean bl) throws StandardException {
        this.setActiveState();
        return this.dataFactory.openStreamContainer(this, l, l2, bl);
    }

    @Override
    public void dropStreamContainer(long l, long l2) throws StandardException {
        this.setActiveState();
        this.dataFactory.dropStreamContainer(this, l, l2);
    }

    @Override
    public void reCreateContainerForRedoRecovery(long l, long l2, ByteArray byteArray) throws StandardException {
        this.setActiveState();
        this.dataFactory.reCreateContainerForRedoRecovery(this, l, l2, byteArray);
    }

    @Override
    public void dropContainer(ContainerKey containerKey) throws StandardException {
        this.setActiveState();
        this.dataFactory.dropContainer(this, containerKey);
    }

    @Override
    public int setSavePoint(String string, Object object) throws StandardException {
        if (object != null && object instanceof String) {
            this.throwExceptionIfSQLSavepointNotAllowed(object);
        }
        if (this.getSavePointPosition(string, object, false) != -1) {
            throw StandardException.newException("3B501.S", new Object[0]);
        }
        if (this.savePoints == null) {
            this.savePoints = new Stack();
        }
        this.savePoints.push(new SavePoint(string, object));
        return this.savePoints.size();
    }

    private void throwExceptionIfSQLSavepointNotAllowed(Object object) throws StandardException {
        boolean bl = false;
        if (this.savePoints != null && !this.savePoints.empty()) {
            for (int i = this.savePoints.size() - 1; i >= 0; --i) {
                SavePoint savePoint = (SavePoint)this.savePoints.elementAt(i);
                if (!savePoint.isThisUserDefinedsavepoint()) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            throw StandardException.newException("3B002.S", new Object[0]);
        }
    }

    @Override
    public int releaseSavePoint(String string, Object object) throws StandardException {
        int n = this.getSavePointPosition(string, object, true);
        if (n == -1) {
            if (object != null && !(object instanceof String)) {
                string = string.substring(2);
            }
            throw StandardException.newException("3B001.S", string);
        }
        this.popSavePoints(n, true);
        return this.savePoints.size();
    }

    @Override
    public int rollbackToSavePoint(String string, Object object) throws StandardException {
        int n = this.getSavePointPosition(string, object, true);
        if (n == -1) {
            if (object != null && !(object instanceof String)) {
                string = string.substring(2);
            }
            throw StandardException.newException("3B001.S", string);
        }
        this.notifyObservers(SAVEPOINT_ROLLBACK);
        this.popSavePoints(n, false);
        return this.savePoints.size();
    }

    private void getLogger() {
        this.logger = this.logFactory.getLogger();
    }

    protected void assumeIdentity(TransactionTableEntry transactionTableEntry) {
        if (transactionTableEntry != null) {
            transactionTableEntry.setXact(this);
            this.myId = transactionTableEntry.getXid();
            this.logStart = transactionTableEntry.getFirstLog();
            this.logLast = transactionTableEntry.getLastLog();
            this.myGlobalId = null;
            if (this.state == 1) {
                this.state = 2;
            }
            if (this.logger == null) {
                this.getLogger();
            }
            this.savedEndStatus = 0;
        } else {
            this.myGlobalId = null;
            this.myId = null;
            this.logStart = null;
            this.logLast = null;
            this.state = 1;
        }
    }

    protected void assumeGlobalXactIdentity(TransactionTableEntry transactionTableEntry) {
        this.myId = transactionTableEntry.getXid();
        this.myGlobalId = transactionTableEntry.getGid();
        this.logStart = transactionTableEntry.getFirstLog();
        this.logLast = transactionTableEntry.getLastLog();
        if (this.state == 1) {
            this.state = 2;
        }
        if (transactionTableEntry.isPrepared()) {
            this.state = 4;
        }
        transactionTableEntry.setXact(this);
        if (this.logger == null) {
            this.getLogger();
        }
        this.savedEndStatus = 0;
    }

    private final void setUpdateState() throws StandardException {
        if (this.readOnly) {
            throw StandardException.newException("40XT8", this.toInternalDetailString());
        }
        this.state = 3;
    }

    protected void setIdleState() {
        this.state = 1;
        this.seenUpdates = false;
        this.logStart = null;
        this.logLast = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setActiveState() throws StandardException {
        if (this.state == 0 || !this.inAbort() && this.state == 4) {
            throw StandardException.newException("40XT8", this.toInternalDetailString());
        }
        if (this.state == 1) {
            Xact xact = this;
            synchronized (xact) {
                this.state = 2;
            }
            if (!this.justCreated) {
                this.xactFactory.setNewTransactionId(this.myId, this);
            }
            this.justCreated = false;
        }
    }

    protected final void setPrepareState() throws StandardException {
        if (this.state == 4 || this.state == 0) {
            throw StandardException.newException("40XT8", this.toInternalDetailString());
        }
        this.state = 4;
    }

    public final LockingPolicy defaultLockingPolicy() {
        return this.defaultLocking;
    }

    private final void releaseAllLocks() {
        this.getLockFactory().unlockGroup(this.getCompatibilitySpace(), this);
    }

    void resetDefaultLocking() {
        this.setDefaultLockingPolicy(this.newLockingPolicy(1, 5, true));
    }

    protected void preComplete(Integer n) throws StandardException {
        if (this.inComplete != null) {
            if (n.equals(COMMIT)) {
                throw this.logFactory.markCorrupt(StandardException.newException("40XT1", new Object[0]));
            }
            throw this.logFactory.markCorrupt(StandardException.newException("XSTB0.M", new Object[0]));
        }
        this.inComplete = n;
        if (!this.postCompleteMode) {
            this.doComplete(n);
        }
    }

    protected void postComplete(int n, Integer n2) throws StandardException {
        if (this.postCompleteMode) {
            this.doComplete(n2);
        }
        if ((n & 2) == 0) {
            this.releaseAllLocks();
        }
        this.setIdleState();
        this.inComplete = null;
    }

    protected void doComplete(Integer n) throws StandardException {
        if (this.savePoints != null) {
            this.savePoints.removeAllElements();
        }
        do {
            this.notifyObservers(n);
            this.checkObserverException();
        } while (this.countObservers() > 0);
    }

    private void checkObserverException() throws StandardException {
        if (this.observerException != null) {
            StandardException standardException = this.observerException;
            this.observerException = null;
            throw standardException;
        }
    }

    protected boolean doPostCommitWorkInTran() {
        return !this.inPostCommitProcessing && !this.recoveryTransaction && this.isUserTransaction() && this.myGlobalId == null;
    }

    @Override
    public boolean handlesPostTerminationWork() {
        return !this.recoveryTransaction;
    }

    @Override
    public void recoveryTransaction() {
        this.recoveryTransaction = true;
        this.xactFactory.remove(this.myId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferPostCommitorAbortWork(List<Serviceable> list) throws StandardException {
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            if (this.doPostCommitWorkInTran()) {
                try {
                    this.inPostCommitProcessing = true;
                    Serviceable[] serviceableArray = new Serviceable[n];
                    serviceableArray = list.toArray(serviceableArray);
                    list.clear();
                    boolean bl = this.xactFactory.inDatabaseCreation();
                    for (int i = 0; i < n; ++i) {
                        if (bl || serviceableArray[i].serviceImmediately()) {
                            try {
                                if (serviceableArray[i].performWork(this.xc.getContextManager()) == 1) {
                                    serviceableArray[i] = null;
                                }
                            }
                            catch (StandardException standardException) {
                                serviceableArray[i] = null;
                                this.xc.cleanupOnError(standardException);
                            }
                        }
                        if (serviceableArray[i] == null) continue;
                        boolean bl2 = this.xactFactory.submitPostCommitWork(serviceableArray[i]);
                        serviceableArray[i] = null;
                        if (!bl2) continue;
                        bl = true;
                    }
                }
                finally {
                    this.inPostCommitProcessing = false;
                    if (list != null) {
                        list.clear();
                    }
                }
            }
            for (int i = 0; i < n; ++i) {
                this.xactFactory.submitPostCommitWork(list.get(i));
            }
            list.clear();
        }
    }

    private final void postTermination() throws StandardException {
        int n = this.postTerminationWorks == null ? 0 : this.postTerminationWorks.size();
        for (int i = 0; i < n; ++i) {
            this.addPostCommitWork(this.postTerminationWorks.get(i));
        }
        if (n > 0) {
            this.postTerminationWorks.clear();
        }
        this.transferPostCommitorAbortWork(this.postCommitWorks);
        this.transferPostCommitorAbortWork(this.postAbortWorks);
        this.unblockBackup();
    }

    private int getSavePointPosition(String string, Object object, boolean bl) {
        if (this.savePoints == null || this.savePoints.empty()) {
            return -1;
        }
        for (int i = this.savePoints.size() - 1; i >= 0; --i) {
            SavePoint savePoint = (SavePoint)this.savePoints.elementAt(i);
            if (!savePoint.getName().equals(string)) continue;
            if (bl && savePoint.getKindOfSavepoint() != null) {
                if (!savePoint.getKindOfSavepoint().equals(object)) continue;
                return i;
            }
            return i;
        }
        return -1;
    }

    protected boolean popSavePoints(int n, boolean bl) throws StandardException {
        if (bl) {
            this.savePoints.setSize(n);
            return false;
        }
        LogInstant logInstant = null;
        int n2 = this.savePoints.size();
        for (int i = n; i < n2; ++i) {
            SavePoint savePoint = (SavePoint)this.savePoints.elementAt(i);
            LogInstant logInstant2 = savePoint.getSavePoint();
            if (logInstant2 == null) continue;
            logInstant = logInstant2;
            break;
        }
        this.savePoints.setSize(n + 1);
        if (logInstant == null) {
            return false;
        }
        try {
            this.logger.undo(this, this.getId(), logInstant, this.getLastLogInstant());
        }
        catch (StandardException standardException) {
            if (standardException.getSeverity() < 30000) {
                throw StandardException.newException("40XT2", standardException, new Object[0]);
            }
            throw standardException;
        }
        return true;
    }

    @Override
    public RawTransaction startNestedTopTransaction() throws StandardException {
        return this.xactFactory.startNestedTopTransaction(this.xc.getFactory(), this.xc.getContextManager());
    }

    private boolean isUserTransaction() {
        String string = this.getContextId();
        return string == "UserTransaction" || string.equals("UserTransaction");
    }

    public final boolean isActive() {
        int n = this.state;
        return n != 0 && n != 1;
    }

    public final boolean isPrepared() {
        return this.state == 4;
    }

    @Override
    public boolean isIdle() {
        return this.state == 1;
    }

    @Override
    public boolean isPristine() {
        return this.state == 1 || this.state == 2;
    }

    @Override
    public boolean inAbort() {
        return ABORT.equals(this.inComplete);
    }

    @Override
    public FileResource getFileHandler() {
        return this.dataFactory.getFileHandler();
    }

    @Override
    protected int statusForBeginXactLog() {
        return this.recoveryRollbackFirst() ? 16 : 0;
    }

    @Override
    protected int statusForEndXactLog() {
        return this.savedEndStatus;
    }

    void setPostComplete() {
        this.postCompleteMode = true;
    }

    @Override
    public boolean blockBackup(boolean bl) throws StandardException {
        if (!this.backupBlocked) {
            this.backupBlocked = this.xactFactory.blockBackup(bl);
        }
        return this.backupBlocked;
    }

    private void unblockBackup() {
        if (this.backupBlocked) {
            this.xactFactory.unblockBackup();
        }
        this.backupBlocked = false;
    }

    @Override
    public boolean isBlockingBackup() {
        return this.backupBlocked;
    }

    @Override
    public void reached(CompatibilitySpace compatibilitySpace, Object object, int n, Enumeration enumeration, int n2) throws StandardException {
        Object object2;
        Hashtable<ContainerKey, Object> hashtable = new Hashtable<ContainerKey, Object>();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof RecordHandle)) continue;
            ContainerKey containerKey = ((RecordHandle)e).getContainerId();
            object2 = (LockCount)((Dictionary)hashtable).get(containerKey);
            if (object2 == null) {
                object2 = new LockCount();
                ((Dictionary)hashtable).put(containerKey, object2);
            }
            ++((LockCount)object2).count;
        }
        int n3 = n / (((Dictionary)hashtable).size() + 1);
        if (n3 < n / 4) {
            n3 = n / 4;
        }
        boolean bl = false;
        object2 = ((Dictionary)hashtable).keys();
        while (object2.hasMoreElements()) {
            ContainerKey containerKey = (ContainerKey)object2.nextElement();
            LockCount lockCount = (LockCount)((Dictionary)hashtable).get(containerKey);
            if (lockCount.count < n3) continue;
            try {
                if (this.openContainer(containerKey, new RowLocking3Escalate(this.getLockFactory()), 196) == null) continue;
                bl = true;
            }
            catch (StandardException standardException) {
                if (standardException.isLockTimeout()) continue;
                throw standardException;
            }
        }
        if (bl) {
            this.notifyObservers(LOCK_ESCALATE);
            this.checkObserverException();
        }
    }

    @Override
    public void createXATransactionFromLocalTransaction(int n, byte[] byArray, byte[] byArray2) throws StandardException {
        GlobalXactId globalXactId = new GlobalXactId(n, byArray, byArray2);
        if (((TransactionTable)this.xactFactory.getTransactionTable()).findTransactionContextByGlobalId(globalXactId) != null) {
            throw StandardException.newException("XSAX1.S", new Object[0]);
        }
        this.setTransactionId(globalXactId, this.getId());
    }

    @Override
    public void xa_commit(boolean bl) throws StandardException {
        if (bl) {
            if (this.state == 4) {
                throw StandardException.newException("40XT8", this.toInternalDetailString());
            }
            this.prepareCommit(65536);
            this.completeCommit(65536);
        } else {
            if (this.state != 4) {
                throw StandardException.newException("40XT8", this.toInternalDetailString());
            }
            this.prepareCommit(65536);
            this.completeCommit(65536);
        }
    }

    @Override
    public int xa_prepare() throws StandardException {
        if (this.state == 1 || this.state == 2) {
            this.abort();
            return 1;
        }
        this.prepareCommit(327682);
        this.inComplete = null;
        this.setPrepareState();
        return 2;
    }

    @Override
    public void xa_rollback() throws StandardException {
        this.abort();
    }

    public String toString() {
        try {
            return this.myId.toString();
        }
        catch (Throwable throwable) {
            return "null";
        }
    }

    public String toInternalDetailString() {
        return "savedEndStatus = " + this.savedEndStatus + "\nneedSync = " + this.needSync + "\njustCreated = " + this.justCreated + "\nmyGlobalId = " + String.valueOf(this.myGlobalId) + "\nmyId = " + String.valueOf(this.myId) + "\nstate = " + this.state + "\ninComplete = " + this.inComplete + "\nseenUpdates = " + this.seenUpdates + "\ninPostCommitProcessing = " + this.inPostCommitProcessing + "\nlogStart = " + String.valueOf(this.logStart) + "\nlogLast = " + String.valueOf(this.logLast) + "\nrecoveryTransaction = " + this.recoveryTransaction + "\npostCompleteMode = " + this.postCompleteMode + "\nsanityCheck_xaclosed = " + this.sanityCheck_xaclosed + "\ntransName = " + this.transName + "\nreadOnly = " + this.readOnly + "\nflush_log_on_xact_end = " + this.flush_log_on_xact_end + "\nbackupBlocked = " + this.backupBlocked + "\ndontWaitForLocks = " + this.dontWaitForLocks + "\n";
    }

    @Override
    public String getActiveStateTxIdString() {
        if (!this.justCreated && this.state == 1) {
            this.xactFactory.setNewTransactionId(this.myId, this);
            this.justCreated = true;
        }
        return this.toString();
    }

    @Override
    public DataValueFactory getDataValueFactory() throws StandardException {
        return this.dataValueFactory;
    }

    String getState() {
        int n = this.state;
        switch (n) {
            case 0: {
                return "CLOSED";
            }
            case 1: {
                return "IDLE";
            }
            case 2: 
            case 3: {
                return "ACTIVE";
            }
            case 4: {
                return "PREPARED";
            }
        }
        return null;
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String string) {
        this.transName = string;
    }

    @Override
    public boolean inRollForwardRecovery() {
        return this.logFactory.inRFR();
    }

    @Override
    public void checkpointInRollForwardRecovery(LogInstant logInstant, long l, long l2) throws StandardException {
        this.logFactory.checkpointInRFR(logInstant, l, l2, this.dataFactory);
    }

    @Override
    public boolean isNestedOwner() {
        return this.parentTransactionId != null;
    }

    @Override
    public boolean nestsUnder(LockOwner lockOwner) {
        if (this.parentTransactionId == null) {
            return false;
        }
        if (!(lockOwner instanceof Xact)) {
            return false;
        }
        return this.parentTransactionId.equals(((Xact)lockOwner).getId());
    }
}

