/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSAck;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.ra.DirectAck;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;

public class DirectMDBSession
extends DirectSession {
    private static final String _className = "com.sun.messaging.jms.ra.DirectMDBSession";

    public DirectMDBSession(DirectConnection dc, JMSService jmsservice, long sessionId, JMSService.SessionAckMode ackMode) throws JMSException {
        super(dc, jmsservice, sessionId, ackMode);
    }

    @Override
    protected void _initSession() {
        _loggerOC.entering(_className, "constructor():_init()");
    }

    @Override
    protected synchronized JMSAck _deliverMessage(MessageListener msgListener, JMSPacket jmsPacket, long consumerId) {
        DirectAck jmsAck = null;
        if (this.enableThreadCheck) {
            long tId = Thread.currentThread().getId();
            if (this.deliverThreadId == 0L) {
                this.deliverThreadId = tId;
            } else if (this.deliverThreadId != tId) {
                throw new RuntimeException("Invalid to call deliver from two different threads!");
            }
        }
        Message jmsMsg = null;
        if (msgListener == null) {
            throw new RuntimeException("DirectConsumer:MessageListener not set!");
        }
        if (jmsPacket == null) {
            throw new RuntimeException("DirectConsumer:JMSPacket is null!");
        }
        try {
            jmsMsg = DirectPacket.constructMessage(jmsPacket, consumerId, this, this.jmsservice, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jmsMsg == null) {
            throw new RuntimeException("DirectConsumer:JMS Message in Packet is null!");
        }
        try {
            this.inDeliver = true;
            msgListener.onMessage(jmsMsg);
            this.inDeliver = false;
            if (this.ackMode != JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE) {
                jmsAck = new DirectAck(this.connectionId, this.sessionId, consumerId, ((DirectPacket)jmsMsg).getReceivedSysMessageID(), JMSService.MessageAckType.ACKNOWLEDGE);
            }
        }
        catch (Exception e) {
            System.out.println("DirectConsumer:Caught Exception delivering message" + e.getMessage());
        }
        return jmsAck;
    }

    protected synchronized void _acknowledgeMDBMessage() throws Exception {
    }
}

