/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.jdbc40;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.spi.ManagedConnectionFactoryImpl;
import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.gjc.spi.base.ConnectionHolder;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionRequestInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class ConnectionHolder40
extends ConnectionHolder {
    protected static final StringManager localStrings = StringManager.getManager(ManagedConnectionFactoryImpl.class);
    protected Properties defaultClientInfo;
    protected boolean jdbc30Connection;

    public ConnectionHolder40(Connection con, ManagedConnectionImpl mc, ConnectionRequestInfo cxRequestInfo, boolean jdbc30Connection) {
        super(con, mc, cxRequestInfo);
        this.jdbc30Connection = jdbc30Connection;
        if (!jdbc30Connection) {
            this.init();
        }
    }

    protected void init() {
        try {
            if (this.isSupportClientInfo()) {
                this.defaultClientInfo = this.getClientInfo();
            }
        }
        catch (Throwable e) {
            _logger.log(Level.FINEST, "jdbc.unable_to_get_client_info", e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.connection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.connection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.connection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkValidity();
        return this.connection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkValidity();
        }
        catch (SQLException sqe) {
            SQLClientInfoException sce = new SQLClientInfoException();
            sce.setStackTrace(sqe.getStackTrace());
            throw sce;
        }
        this.connection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkValidity();
        }
        catch (SQLException sqe) {
            SQLClientInfoException sce = new SQLClientInfoException();
            sce.setStackTrace(sqe.getStackTrace());
            throw sce;
        }
        this.connection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkValidity();
        return this.connection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkValidity();
        return this.connection.getClientInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSupportClientInfo() throws ResourceException, SQLException {
        Boolean isSupportClientInfo = this.getManagedConnection().isClientInfoSupported();
        if (isSupportClientInfo != null) {
            return isSupportClientInfo;
        }
        ResultSet rs = this.getManagedConnection().getCachedDatabaseMetaData().getClientInfoProperties();
        try {
            isSupportClientInfo = rs.next();
            this.getManagedConnection().setClientInfoSupported(isSupportClientInfo);
            boolean bl = isSupportClientInfo;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "jdbc.unable_to_get_client_info", ex);
                }
                return false;
            }
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkValidity();
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        if (iface.isInstance(this.connection)) {
            Class[] listIntf = new Class[]{iface};
            return this.getProxyObject(this.connection, listIntf);
        }
        T result = this.connection.unwrap(iface);
        if (Connection.class.isInstance(result)) {
            Class[] listIntf = new Class[]{iface, Connection.class};
            result = this.getProxyObject(result, listIntf);
        }
        return result;
    }

    private <T> T getProxyObject(final Object actualObject, Class<T>[] ifaces) throws SQLException {
        InvocationHandler invocationHandler;
        try {
            invocationHandler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws SQLException, IllegalAccessException, InvocationTargetException {
                    if (method.getName().equals("close") && method.getParameterTypes().length == 0) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, localStrings.getString("jdbc.close_called_on_proxy_object", actualObject));
                        }
                        ConnectionHolder40.this.close();
                        return null;
                    }
                    return method.invoke(actualObject, args);
                }
            };
        }
        catch (Exception e) {
            throw new SQLException(e.fillInStackTrace());
        }
        return (T)Proxy.newProxyInstance(actualObject.getClass().getClassLoader(), ifaces, invocationHandler);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkValidity();
        if (iface.isInstance(this)) {
            return true;
        }
        return this.connection.isWrapperFor(iface);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            _logger.log(Level.FINE, "jdbc.duplicate_close_connection", this);
            return;
        }
        if (!this.jdbc30Connection) {
            try {
                this.checkValidity();
                if (this.isSupportClientInfo()) {
                    if (this.defaultClientInfo == null) {
                        this.setClientInfo(new Properties());
                    } else {
                        this.setClientInfo(this.defaultClientInfo);
                    }
                }
            }
            catch (Throwable e) {
                _logger.log(Level.FINEST, "jdbc.unable_to_set_client_info", e);
            }
        }
        super.close();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkValidity();
        Class[] valueTypes = new Class[]{String.class};
        try {
            this.getMethodExecutor().invokeMethod(this.connection, "setSchema", valueTypes, schema);
        }
        catch (ResourceException ex) {
            _logger.log(Level.SEVERE, "jdbc.ex_connection_holder", ex);
            throw new SQLException(ex);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkValidity();
        try {
            return (String)this.getMethodExecutor().invokeMethod(this.connection, "getSchema", null, new Object[0]);
        }
        catch (ResourceException ex) {
            _logger.log(Level.SEVERE, "jdbc.ex_connection_holder", ex);
            throw new SQLException(ex);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executorObj, int milliseconds) throws SQLException {
        this.checkValidity();
        Class[] valueTypes = new Class[]{Executor.class, Integer.TYPE};
        try {
            this.getMethodExecutor().invokeMethod(this.connection, "setNetworkTimeout", valueTypes, executorObj, milliseconds);
        }
        catch (ResourceException ex) {
            _logger.log(Level.SEVERE, "jdbc.ex_connection_holder", ex);
            throw new SQLException(ex);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkValidity();
        try {
            return (Integer)this.getMethodExecutor().invokeMethod(this.connection, "getNetworkTimeout", null, new Object[0]);
        }
        catch (ResourceException ex) {
            _logger.log(Level.SEVERE, "jdbc.ex_connection_holder", ex);
            throw new SQLException(ex);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.getManagedConnection().markForRemoval(true);
        this.getManagedConnection().setAborted(true);
        if (!this.getManagedConnection().isTransactionInProgress()) {
            this.close();
        }
    }
}

