/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.RemoteType;
import com.sun.enterprise.v3.admin.cluster.CreateRemoteNodeCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="create-node-ssh")
@I18n(value="create.node.ssh")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Nodes.class, opType=RestEndpoint.OpType.POST, path="create-node-ssh", description="Create Node SSH")})
public class CreateNodeSshCommand
extends CreateRemoteNodeCommand {
    @Param(name="sshport", optional=true, defaultValue="22")
    private String sshport;
    @Param(name="sshuser", optional=true, defaultValue="${user.name}")
    private String sshuser;
    @Param(name="sshpassword", optional=true, password=true)
    private String sshpassword;
    @Param(name="sshkeyfile", optional=true)
    private String sshkeyfile;
    @Param(name="sshkeypassphrase", optional=true, password=true)
    private String sshkeypassphrase;

    public final void execute(AdminCommandContext context) {
        this.populateBaseClass();
        this.executeInternal(context);
    }

    @Override
    protected void initialize() {
    }

    @Override
    protected void validate() throws CommandValidationException {
    }

    @Override
    protected final void checkDefaults() {
        super.checkDefaults();
        if (!StringUtils.ok((String)this.remotePort)) {
            this.remotePort = "22";
        }
    }

    @Override
    protected final RemoteType getType() {
        return RemoteType.SSH;
    }

    @Override
    protected void populateBaseClass() {
        this.remotePort = this.sshport;
        this.remoteUser = this.sshuser;
        this.remotePassword = this.sshpassword;
    }

    @Override
    protected final void populateParameters(ParameterMap pmap) {
        pmap.add((Object)"sshkeyfile", (Object)this.sshkeyfile);
        pmap.add((Object)"sshkeypassphrase", (Object)this.sshkeypassphrase);
    }

    @Override
    protected final void populateCommandArgs(List<String> args) {
        File file;
        if (this.sshkeyfile == null && (file = SSHUtil.getExistingKeyFile()) != null) {
            this.sshkeyfile = file.getAbsolutePath();
        }
        if (this.sshkeyfile != null) {
            args.add("--sshkeyfile");
            args.add(this.sshkeyfile);
        }
        args.add("--sshuser");
        args.add(this.remoteUser);
        args.add("--sshport");
        args.add(this.remotePort);
    }

    @Override
    protected List<String> getPasswords() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("AS_ADMIN_SSHPASSWORD=" + SSHLauncher.expandPasswordAlias((String)this.remotePassword));
        if (this.sshkeypassphrase != null) {
            list.add("AS_ADMIN_SSHKEYPASSPHRASE=" + SSHLauncher.expandPasswordAlias((String)this.sshkeypassphrase));
        }
        return list;
    }

    @Override
    protected String getInstallNodeCommandName() {
        return "install-node-ssh";
    }
}

