/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.TransactionDetails;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class BaseTransaction {
    public static final long FORMAT_VERSION_1 = 1L;
    public static final long CURRENT_FORMAT_VERSION = 1L;
    public static final int UNDEFINED_TRANSACTION_TYPE = 0;
    public static final int LOCAL_TRANSACTION_TYPE = 1;
    public static final int REMOTE_TRANSACTION_TYPE = 2;
    public static final int CLUSTER_TRANSACTION_TYPE = 3;
    public static final int NON_TRANSACTED_MSG_TYPE = 4;
    public static final int NON_TRANSACTED_ACK_TYPE = 5;
    public static final int MSG_REMOVAL_TYPE = 6;
    TransactionDetails transactionDetails = new TransactionDetails();
    TransactionWork transactionWork;
    TransactionState transactionState;
    byte[] data;

    public BaseTransaction(int type) {
        this.transactionDetails.setType(type);
    }

    public int getType() {
        return this.transactionDetails.getType();
    }

    public int getState() {
        return this.transactionDetails.getState();
    }

    public TransactionUID getTid() {
        return this.transactionDetails.getTid();
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String toString() {
        return this.transactionDetails.toString();
    }

    public TransactionWork getTransactionWork() {
        return this.transactionWork;
    }

    public void setTransactionWork(TransactionWork transactionWork) {
        this.transactionWork = transactionWork;
    }

    public TransactionDetails getTransactionDetails() {
        return this.transactionDetails;
    }

    public void setTransactionDetails(TransactionDetails transactionDetails) {
        this.transactionDetails = transactionDetails;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionState transactionState) {
        this.transactionState = transactionState;
    }

    String getPrefix() {
        return "BaseTransaction: " + Thread.currentThread().getName() + " " + String.valueOf(this.getTid());
    }

    public void readFromBytes(byte[] data) throws IOException, BrokerException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        this.readData(dis);
        int objectBodySize = dis.readInt();
        byte[] objectBody = new byte[objectBodySize];
        dis.read(objectBody);
        ByteArrayInputStream bais2 = new ByteArrayInputStream(objectBody);
        FilteringObjectInputStream ois = new FilteringObjectInputStream(bais2);
        try {
            this.readObjects(ois);
        }
        catch (ClassNotFoundException e) {
            System.getLogger(this.getClass().getName()).log(System.Logger.Level.ERROR, e.getMessage(), (Throwable)e);
        }
        ois.close();
        bais2.close();
        dis.close();
        bais.close();
    }

    public abstract void readData(DataInputStream var1) throws IOException, BrokerException;

    public abstract void readObjects(ObjectInputStream var1) throws IOException, BrokerException, ClassNotFoundException;

    public byte[] writeToBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.writeData(dos);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream(1024);
        ObjectOutputStream oos = new ObjectOutputStream(baos2);
        this.writeObjects(oos);
        oos.close();
        byte[] data = baos2.toByteArray();
        int length = data.length;
        dos.writeInt(length);
        dos.write(data);
        baos2.close();
        dos.close();
        baos.close();
        byte[] data2 = baos.toByteArray();
        return data2;
    }

    public abstract void writeData(DataOutputStream var1) throws IOException;

    public abstract void writeObjects(ObjectOutputStream var1) throws IOException;
}

