/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;

public class GetDestinationsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetDestinationsHandler.getDEBUG();

    public GetDestinationsHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        boolean load;
        if (DEBUG) {
            this.logger.log(8, "GetDestiantionsHandler: " + String.valueOf(cmd_props));
        }
        Vector<Object> v = new Vector<Object>();
        int status = 200;
        String errMsg = null;
        String destination = (String)cmd_props.get("JMQDestination");
        Integer destType = (Integer)cmd_props.get("JMQDestType");
        Boolean val = (Boolean)cmd_props.get("JMQShowPartition");
        boolean showpartition = val != null && val != false;
        val = (Boolean)cmd_props.get("JMQLoadDestination");
        boolean bl = load = val != null && val != false;
        assert (destination == null || destType != null);
        if (destination != null) {
            try {
                Destination[] ds = DestinationList.getDestination(null, destination, DestType.isQueue((int)destType));
                Destination d = null;
                DestinationInfo dinfo = null;
                for (int i = 0; i < ds.length; ++i) {
                    d = ds[i];
                    if (d == null) continue;
                    if (DEBUG) {
                        d.debug();
                    }
                    if (load) {
                        d.load();
                    }
                    dinfo = GetDestinationsHandler.getDestinationInfo(d, dinfo, showpartition);
                    if (!showpartition) continue;
                    v.add(dinfo);
                }
                if (dinfo == null) {
                    throw new BrokerException(this.rb.getString("B4017", destination), 404);
                }
                if (!showpartition) {
                    v.add(dinfo);
                }
            }
            catch (Exception ex) {
                status = 500;
                errMsg = ex.getMessage();
                if (ex instanceof BrokerException) {
                    status = ((BrokerException)ex).getStatusCode();
                }
                this.logger.logStack(32, errMsg, (Throwable)ex);
            }
        } else {
            try {
                LinkedHashMap<DestinationUID, DestinationInfo> map = new LinkedHashMap<DestinationUID, DestinationInfo>();
                Iterator[] itrs = DestinationList.getAllDestinations(null);
                int cnt = itrs.length;
                DestinationInfo dinfo = null;
                DestinationUID duid = null;
                Destination d = null;
                for (int i = 0; i < cnt; ++i) {
                    Iterator itr = itrs[i];
                    while (itr.hasNext()) {
                        d = (Destination)itr.next();
                        if (load) {
                            d.load();
                        }
                        duid = d.getDestinationUID();
                        dinfo = (DestinationInfo)map.get(d.getDestinationUID());
                        dinfo = GetDestinationsHandler.getDestinationInfo(d, dinfo, showpartition);
                        map.put(duid, dinfo);
                        if (!showpartition) continue;
                        v.add(dinfo);
                    }
                }
                if (!showpartition) {
                    Iterator itr = map.values().iterator();
                    while (itr.hasNext()) {
                        v.add(itr.next());
                    }
                }
            }
            catch (Exception ex) {
                status = 500;
                errMsg = ex.getMessage();
                if (ex instanceof BrokerException) {
                    status = ((BrokerException)ex).getStatusCode();
                }
                this.logger.logStack(32, errMsg, (Throwable)ex);
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        GetDestinationsHandler.setProperties(reply, 21, status, errMsg);
        this.setBodyObject(reply, v);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public static DestinationInfo getDestinationInfo(Destination d) {
        return GetDestinationsHandler.getDestinationInfo(d, null, false);
    }

    private static DestinationInfo getDestinationInfo(Destination d, DestinationInfo dinfo, boolean showpartition) {
        DestinationInfo di = dinfo;
        if (di == null || showpartition) {
            di = new DestinationInfo();
        }
        d.getSizeInfo(di);
        if (dinfo == null || showpartition) {
            di.nConsumers = d.getConsumerCount();
            di.nfConsumers = d.getFailoverConsumerCount();
            di.naConsumers = d.getActiveConsumerCount();
        }
        di.nProducers += d.getProducerCount();
        if (dinfo == null || showpartition) {
            boolean bl = di.autocreated = d.isAutoCreated() || d.isInternal() || d.isDMQ() || d.isAdmin();
        }
        if (dinfo == null || showpartition) {
            di.destState = d.getState();
        }
        if (d.isAdmin() || !showpartition) {
            di.name = d.getDestinationName();
        } else {
            PartitionedStore pstore = d.getPartitionedStore();
            di.name = d.getDestinationName() + "[" + String.valueOf(pstore.getPartitionID()) + (pstore.isPrimaryPartition() ? "*]" : "]");
        }
        if (dinfo == null || showpartition) {
            di.type = d.getType() & 0xFFFFFF1F;
            di.fulltype = d.getType();
        }
        di.maxMessages += d.getCapacity();
        if (di.maxMessages < 0) {
            di.maxMessages = 0;
        }
        SizeString bc = d.getByteCapacity();
        di.maxMessageBytes = di.maxMessageBytes + (bc == null ? 0L : bc.getBytes());
        if (di.maxMessageBytes < 0L) {
            di.maxMessageBytes = 0L;
        }
        bc = d.getMaxByteSize();
        di.maxMessageSize = di.maxMessageSize + (bc == null ? 0L : bc.getBytes());
        if (di.maxMessageSize < 0L) {
            di.maxMessageSize = 0L;
        }
        if (dinfo == null || showpartition) {
            di.destScope = d.getScope();
            di.destLimitBehavior = d.getLimitBehavior();
            di.maxPrefetch = d.getMaxPrefetch();
            di.destCDP = d.getClusterDeliveryPolicy();
            di.maxActiveConsumers = d.getMaxActiveConsumers();
            di.maxFailoverConsumers = d.getMaxFailoverConsumers();
            di.maxProducers = d.getMaxProducers();
            di.maxNumSharedConsumers = d.getMaxNumSharedConsumers();
            di.sharedConsumerFlowLimit = d.getSharedConsumerFlowLimit();
            di.useDMQ = d.getUseDMQ();
            di.validateXMLSchemaEnabled = d.validateXMLSchemaEnabled();
            di.XMLSchemaUriList = d.getXMLSchemaUriList();
            di.reloadXMLSchemaOnFailure = d.reloadXMLSchemaOnFailure();
        }
        if (!d.isQueue()) {
            Integer newCount;
            Integer count;
            String wildcard;
            DestinationUID id;
            Hashtable<String, Integer> h = new Hashtable<String, Integer>();
            if (dinfo == null || showpartition) {
                if (di.nConsumers > 0) {
                    Iterator consumers = d.getConsumers();
                    while (consumers.hasNext()) {
                        Consumer oneCon = (Consumer)consumers.next();
                        if (!oneCon.isWildcard()) continue;
                        id = oneCon.getDestinationUID();
                        wildcard = id.getName();
                        count = (Integer)h.get(wildcard);
                        newCount = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                        h.put(wildcard, newCount);
                    }
                }
                if (h.size() > 0) {
                    di.consumerWildcards = h;
                }
            }
            if ((h = di.producerWildcards) == null) {
                h = new Hashtable<String, Integer>();
            }
            if (di.nProducers > 0) {
                Iterator producers = d.getProducers();
                while (producers.hasNext()) {
                    Producer oneProd = (Producer)producers.next();
                    if (!oneProd.isWildcard()) continue;
                    id = oneProd.getDestinationUID();
                    wildcard = id.getName();
                    count = (Integer)h.get(wildcard);
                    newCount = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                    h.put(wildcard, newCount);
                }
            }
            if (h.size() > 0) {
                di.producerWildcards = h;
            }
        }
        return di;
    }
}

