/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.inbound.ActiveInboundResourceAdapterImpl;
import com.sun.enterprise.connectors.jms.JMSLoggerInfo;
import com.sun.enterprise.connectors.jms.config.JmsAvailability;
import com.sun.enterprise.connectors.jms.config.JmsHost;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.inflow.MdbContainerProps;
import com.sun.enterprise.connectors.jms.system.JMSConfigListener;
import com.sun.enterprise.connectors.jms.system.MQAddressList;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JMSDestinationDefinitionDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.services.impl.DummyNetworkListener;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapterInternalException;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.rmi.Naming;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.admin.mbeanserver.JMXStartupService;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.grizzly.LazyServiceInitializer;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
@Named(value="mq-service")
public class ActiveJmsResourceAdapter
extends ActiveInboundResourceAdapterImpl
implements LazyServiceInitializer,
PostConstruct {
    private static final Logger LOG = JMSLoggerInfo.getLogger();
    private static final String SETTER = "setProperty";
    private static final String SEPARATOR = "#";
    public static final String CONNECTION_URL = "ConnectionURL";
    private static final String RECONNECTENABLED = "ReconnectEnabled";
    private static final String RECONNECTINTERVAL = "ReconnectInterval";
    private static final String RECONNECTATTEMPTS = "ReconnectAttempts";
    private static final String GROUPNAME = "GroupName";
    private static final String CLUSTERCONTAINER = "InClusteredContainer";
    private static final String BROKERTYPE = "BrokerType";
    private static final String BROKERINSTANCENAME = "BrokerInstanceName";
    private static final String BROKERBINDADDRESS = "BrokerBindAddress";
    private static final String BROKERPORT = "BrokerPort";
    private static final String BROKERARGS = "BrokerArgs";
    private static final String BROKERHOMEDIR = "BrokerHomeDir";
    private static final String BROKERLIBDIR = "BrokerLibDir";
    private static final String BROKERVARDIR = "BrokerVarDir";
    private static final String BROKERJAVADIR = "BrokerJavaDir";
    private static final String BROKERSTARTTIMEOUT = "BrokerStartTimeOut";
    public static final String ADMINUSERNAME = "AdminUsername";
    public static final String ADMINPASSWORD = "AdminPassword";
    private static final String USERNAME = "UserName";
    private static final String PASSWORD = "Password";
    private static final String MQ_PORTMAPPER_BIND = "doBind";
    private static final String MASTERBROKER = "MasterBroker";
    private static final String RMIREGISTRYPORT = "RmiRegistryPort";
    private static final String USEEXTERNALRMIREGISTRY = "startRMIRegistry";
    private static final int DEFAULTRMIREGISTRYPORT = 7776;
    private static final int BROKERRMIPORTOFFSET = 100;
    private static final String CONVENTIONAL_CLUSTER__OF_PEER_BROKERS_DB_PREFIX = "imq.cluster.sharecc.persist.jdbc.";
    private static final String ENHANCED_CLUSTER_DB_PREFIX = "imq.persist.jdbc.";
    private static final String HAREQUIRED = "HARequired";
    private static final String CLUSTERID = "ClusterId";
    private static final String BROKERID = "BrokerId";
    private static final String BROKERENABLEHA = "BrokerEnableHA";
    private static final String DB_HADB_PROPS = "DBProps";
    public static final String DESTINATION = "destination";
    public static final String DESTINATION_TYPE = "destinationType";
    private static String SUBSCRIPTION_NAME = "SubscriptionName";
    private static final String PHYSICAL_DESTINATION = "Name";
    private static String MAXPOOLSIZE = "EndpointPoolMaxSize";
    private static String MINPOOLSIZE = "EndpointPoolSteadySize";
    private static String RESIZECOUNT = "EndpointPoolResizeCount";
    private static String RESIZETIMEOUT = "EndpointPoolResizeTimeout";
    private static String REDELIVERYCOUNT = "EndpointExceptionRedeliveryAttempts";
    private static String LOWERCASE_REDELIVERYCOUNT = "endpointExceptionRedeliveryAttempts";
    public static final String ADDRESSLIST = "AddressList";
    private static String ADRLIST_BEHAVIOUR = "AddressListBehavior";
    private static String ADRLIST_ITERATIONS = "AddressListIterations";
    private static final String MDBIDENTIFIER = "MdbName";
    public static final String JMS_SERVICE = "mq-service";
    private static final String MCFADDRESSLIST = "MessageServiceAddressList";
    private static final StringManager I18N = StringManager.getManager(ActiveJmsResourceAdapter.class);
    public static final String EMBEDDED = "EMBEDDED";
    public static final String LOCAL = "LOCAL";
    public static final String REMOTE = "REMOTE";
    public static final String DIRECT = "DIRECT";
    private static String MQRmiPort = System.getProperty("com.sun.enterprise.connectors.system.MQRmiPort");
    private static final String DASRMIPORT = "31099";
    private static final String REVERT_TO_EMBEDDED_PROPERTY = "com.sun.enterprise.connectors.system.RevertToEmbedded";
    private static final String BROKER_RMI_PORT = "com.sun.enterprise.connectors.system.mq.rmiport";
    private static final String DEFAULT_SERVER = "server";
    private static final String DEFAULT_MQ_INSTANCE = "imqbroker";
    private static final String MQ_DIR_NAME = "imq";
    public static final String GRIZZLY_PROXY_PREFIX = "JMS_PROXY_";
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private GlassfishNamingManager nm;
    @Inject
    private Provider<JMSConfigListener> jmsConfigListenerProvider;
    @Inject
    private Provider<ServerEnvironmentImpl> serverEnvironmentImplProvider;
    @Inject
    @Named(value="default-instance-name")
    private Provider<AdminService> adminServiceProvider;
    @Inject
    private Provider<ServerContext> serverContextProvider;
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ApplicationRegistry appRegistry;
    private MQAddressList urlList;
    private String addressList;
    private String brkrPort;
    private boolean doBind;
    private Properties dbProps;
    private String brokerInstanceName;
    private boolean grizzlyListenerInit;
    private final Set<String> grizzlyListeners = new HashSet<String>();
    Domain domain = (Domain)Globals.get(Domain.class);

    public void postConstruct() {
        JMSConfigListener jmsConfigListener;
        try {
            jmsConfigListener = (JMSConfigListener)this.jmsConfigListenerProvider.get();
        }
        catch (RuntimeException e) {
            LOG.log(Level.FINE, "No JMSConfigListener provided, nothing to do.", e);
            return;
        }
        try {
            jmsConfigListener.setActiveResourceAdapter(this);
            JmsRaUtil raUtil = new JmsRaUtil();
            raUtil.upgradeIfNecessary();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cannot upgrade jmsra!", e);
        }
    }

    protected void loadRAConfiguration() throws ConnectorRuntimeException {
        if (this.connectorRuntime.isServer()) {
            try {
                this.setLifecycleProperties();
            }
            catch (Exception e) {
                throw new ConnectorRuntimeException(e.getMessage(), (Throwable)e);
            }
            this.setMdbContainerProperties();
            this.setJmsServiceProperties(null);
            this.setClusterRABeanProperties();
            this.setAvailabilityProperties();
        } else {
            this.setAppClientRABeanProperties();
        }
        super.loadRAConfiguration();
        this.postRAConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block12: {
            try {
                JmsService jmsService = this.getJmsService();
                if (!this.connectorRuntime.isServer() || !this.grizzlyListenerInit || jmsService == null || !EMBEDDED.equalsIgnoreCase(jmsService.getType())) break block12;
                GrizzlyService grizzlyService = null;
                try {
                    grizzlyService = (GrizzlyService)Globals.get(GrizzlyService.class);
                }
                catch (MultiException multiException) {
                    // empty catch block
                }
                if (grizzlyService != null) {
                    Set<String> set = this.grizzlyListeners;
                    synchronized (set) {
                        if (!this.grizzlyListeners.isEmpty()) {
                            String[] listeners;
                            for (String listenerName : listeners = this.grizzlyListeners.toArray(new String[this.grizzlyListeners.size()])) {
                                try {
                                    grizzlyService.removeNetworkProxy(listenerName);
                                    this.grizzlyListeners.remove(listenerName);
                                }
                                catch (Exception e) {
                                    LogHelper.log((Logger)LOG, (Level)Level.WARNING, (String)"AS-JMS-CORE-00009", (Throwable)e, (Object[])new Object[]{listenerName});
                                }
                            }
                        }
                    }
                }
                this.grizzlyListenerInit = false;
            }
            catch (Throwable th) {
                LogHelper.log((Logger)LOG, (Level)Level.SEVERE, (String)"AS-JMS-CORE-00010", (Throwable)th, (Object[])new Object[0]);
            }
        }
        super.destroy();
    }

    public Set<String> getGrizzlyListeners() {
        return this.grizzlyListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeLazyListener(JmsService jmsService) {
        GrizzlyService grizzlyService;
        if (jmsService != null && EMBEDDED.equalsIgnoreCase(jmsService.getType()) && !this.grizzlyListenerInit && (grizzlyService = (GrizzlyService)Globals.get(GrizzlyService.class)) != null) {
            List jmsHosts = jmsService.getJmsHost();
            for (JmsHost oneHost : jmsHosts) {
                if (!Boolean.parseBoolean(oneHost.getLazyInit()) || this.doBind) continue;
                String jmsHost = null;
                jmsHost = oneHost.getHost() != null && "localhost".equals(oneHost.getHost()) ? "0.0.0.0" : oneHost.getHost();
                DummyNetworkListener dummy = new DummyNetworkListener();
                dummy.setPort(oneHost.getPort());
                dummy.setAddress(jmsHost);
                dummy.setType("proxy");
                dummy.setProtocol(JMS_SERVICE);
                dummy.setTransport("tcp");
                String name = GRIZZLY_PROXY_PREFIX + oneHost.getName();
                dummy.setName(name);
                Set<String> set = this.grizzlyListeners;
                synchronized (set) {
                    grizzlyService.createNetworkProxy((NetworkListener)dummy);
                    this.grizzlyListeners.add(name);
                }
                this.grizzlyListenerInit = true;
            }
        }
    }

    protected void startResourceAdapter(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        try {
            if (this.moduleName_.equals("jmsra")) {
                if (this.connectorRuntime.isServer()) {
                    Domain domain = (Domain)Globals.get(Domain.class);
                    ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
                    Server server = domain.getServerNamed(serverContext.getInstanceName());
                    JmsService jmsService = (JmsService)server.getConfig().getExtensionByType(JmsService.class);
                    this.initializeLazyListener(jmsService);
                }
                PrivilegedExceptionAction<Void> action = () -> {
                    this.resourceadapter_.start(this.bootStrapContextImpl);
                    return null;
                };
                AccessController.doPrivileged(action);
            } else {
                this.resourceadapter_.start(this.bootStrapContextImpl);
            }
        }
        catch (PrivilegedActionException ex) {
            throw new ResourceAdapterInternalException((Throwable)ex);
        }
    }

    protected Set mergeRAConfiguration(ResourceAdapterConfig raConfig, List<Property> raConfigProps) {
        if (!this.connectorRuntime.isServer()) {
            return super.mergeRAConfiguration(raConfig, raConfigProps);
        }
        Set mergedProps = super.mergeRAConfiguration(raConfig, raConfigProps);
        String brokerType = null;
        for (ConnectorConfigProperty element : mergedProps) {
            if (!element.getName().equals(BROKERTYPE)) continue;
            brokerType = element.getValue();
        }
        boolean cluster = false;
        try {
            cluster = ActiveJmsResourceAdapter.isClustered();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!cluster && brokerType != null && (brokerType.equals(LOCAL) || brokerType.equals(EMBEDDED) || brokerType.equals(DIRECT))) {
            Iterator iter = mergedProps.iterator();
            while (iter.hasNext()) {
                ConnectorConfigProperty element = (ConnectorConfigProperty)iter.next();
                if (!element.getName().equals(CONNECTION_URL)) continue;
                iter.remove();
            }
        }
        return mergedProps;
    }

    public void setup() throws ConnectorRuntimeException {
        if (this.connectionDefs_ == null) {
            throw new ConnectorRuntimeException("No Connection Defs defined in the RA.xml");
        }
        if (this.isServer() && !this.isSystemRar(this.moduleName_)) {
            this.createAllConnectorResources();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Completed Active Resource adapter setup", this.moduleName_);
        }
    }

    private void setAvailabilityProperties() throws ConnectorRuntimeException {
        if (!ActiveJmsResourceAdapter.isClustered()) {
            return;
        }
        try {
            Domain domain = (Domain)Globals.get(Domain.class);
            ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
            Server server = domain.getServerNamed(serverContext.getInstanceName());
            JmsService jmsService = (JmsService)server.getConfig().getExtensionByType(JmsService.class);
            if (jmsService.getType().equals(REMOTE)) {
                return;
            }
            AvailabilityService as = server.getConfig().getAvailabilityService();
            if (as == null) {
                LOG.log(Level.CONFIG, "Availability Service is null. Not setting AvailabilityProperties.");
                return;
            }
            boolean useMasterBroker = true;
            if (as.getExtensionByType(JmsAvailability.class) != null && !MASTERBROKER.equalsIgnoreCase(((JmsAvailability)as.getExtensionByType(JmsAvailability.class)).getConfigStoreType())) {
                useMasterBroker = false;
            }
            boolean isJmsAvailabilityEnabled = this.isJMSAvailabilityOn(as);
            LOG.log(Level.FINEST, "Setting AvailabilityProperties ...");
            if (!useMasterBroker || isJmsAvailabilityEnabled) {
                ConnectorDescriptor cd = this.getDescriptor();
                String clusterName = this.getMQClusterName();
                ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(CLUSTERID, clusterName, "Cluster Id", String.class.getName());
                this.setProperty(cd, envProp1);
                if (this.brokerInstanceName == null) {
                    this.brokerInstanceName = ActiveJmsResourceAdapter.getBrokerInstanceName(jmsService);
                }
                ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(BROKERID, this.brokerInstanceName, "Broker Id", String.class.getName());
                this.setProperty(cd, envProp2);
                if (isJmsAvailabilityEnabled) {
                    ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(HAREQUIRED, "true", "HA Required", String.class.getName());
                    this.setProperty(cd, envProp3);
                    ConnectorConfigProperty envProp4 = new ConnectorConfigProperty(BROKERENABLEHA, "true", "BrokerEnableHA flag", "java.lang.Boolean");
                    this.setProperty(cd, envProp4);
                    String nodeHostName = domain.getNodeNamed(server.getNodeRef()).getNodeHost();
                    if (nodeHostName != null) {
                        ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(BROKERBINDADDRESS, nodeHostName, "Broker Bind Address", String.class.getName());
                        this.setProperty(cd, envProp5);
                    }
                    this.loadDBProperties((JmsAvailability)as.getExtensionByType(JmsAvailability.class), ClusterMode.ENHANCED);
                } else {
                    JmsAvailability jmsAvailability = (JmsAvailability)as.getExtensionByType(JmsAvailability.class);
                    if ("jdbc".equals(jmsAvailability.getMessageStoreType())) {
                        this.loadDBProperties(jmsAvailability, ClusterMode.ENHANCED);
                    }
                    this.loadDBProperties(jmsAvailability, ClusterMode.CONVENTIONAL_OF_PEER_BROKERS);
                }
            } else if ("jdbc".equals(((JmsAvailability)as.getExtensionByType(JmsAvailability.class)).getMessageStoreType())) {
                this.loadDBProperties((JmsAvailability)as.getExtensionByType(JmsAvailability.class), ClusterMode.CONVENTIONAL_WITH_MASTER_BROKER);
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private void loadDBProperties(JmsAvailability jmsAvailability, ClusterMode clusterMode) {
        String prefix;
        if (ClusterMode.CONVENTIONAL_WITH_MASTER_BROKER == clusterMode) {
            prefix = ENHANCED_CLUSTER_DB_PREFIX;
        } else if (ClusterMode.CONVENTIONAL_OF_PEER_BROKERS == clusterMode) {
            prefix = CONVENTIONAL_CLUSTER__OF_PEER_BROKERS_DB_PREFIX;
        } else if (ClusterMode.ENHANCED == clusterMode) {
            prefix = ENHANCED_CLUSTER_DB_PREFIX;
        } else {
            LOG.log(Level.FINE, () -> "Unknown cluster mode: " + clusterMode.name() + ", imq DB properties are not set.");
            return;
        }
        if (this.dbProps == null) {
            this.dbProps = new Properties();
        }
        this.dbProps.setProperty("imq.cluster.clusterid", this.getMQClusterName());
        this.dbProps.setProperty("imq.persist.store", jmsAvailability.getMessageStoreType());
        if (ClusterMode.CONVENTIONAL_WITH_MASTER_BROKER == clusterMode) {
            this.dbProps.setProperty("imq.cluster.nomasterbroker", "false");
        } else {
            this.dbProps.setProperty("imq.cluster.nomasterbroker", "true");
        }
        if (Boolean.parseBoolean(jmsAvailability.getAvailabilityEnabled()) || "jdbc".equals(jmsAvailability.getMessageStoreType())) {
            this.dbProps.setProperty("imq.brokerid", ActiveJmsResourceAdapter.getBrokerInstanceName(this.getJmsService()));
        }
        String dbVendor = jmsAvailability.getDbVendor();
        String dbuser = jmsAvailability.getDbUsername();
        String dbPassword = jmsAvailability.getDbPassword();
        String dbJdbcUrl = jmsAvailability.getDbUrl();
        this.dbProps.setProperty(prefix + "dbVendor", dbVendor);
        String fullprefix = prefix + dbVendor + ".";
        if (dbuser != null) {
            this.dbProps.setProperty(fullprefix + "user", dbuser);
        }
        if (dbPassword != null) {
            this.dbProps.setProperty(fullprefix + "password", dbPassword);
        }
        List dbprops = jmsAvailability.getProperty();
        String propertyPrefix = fullprefix + "property.";
        if (dbJdbcUrl != null) {
            if ("derby".equals(dbVendor)) {
                this.dbProps.setProperty(fullprefix + "opendburl", dbJdbcUrl);
            } else {
                this.dbProps.setProperty(propertyPrefix + "url", dbJdbcUrl);
            }
        }
        for (Property prop : dbprops) {
            String key = prop.getName();
            String value = prop.getValue();
            if (key.startsWith("imq.")) {
                this.dbProps.setProperty(key, value);
                continue;
            }
            this.dbProps.setProperty(propertyPrefix + key, value);
        }
    }

    protected void postRAConfiguration() throws ConnectorRuntimeException {
        try {
            if (this.dbProps == null) {
                this.dbProps = new Properties();
            }
            this.dbProps.setProperty("imq.cluster.dynamicChangeMasterBrokerEnabled", "true");
            Method mthds = this.resourceadapter_.getClass().getMethod("setBrokerProps", Properties.class);
            LOG.log(Level.FINE, () -> "Setting property: DBProps=" + String.valueOf(this.dbProps));
            mthds.invoke((Object)this.resourceadapter_, this.dbProps);
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private boolean isJMSAvailabilityOn(AvailabilityService as) {
        if (as == null) {
            return false;
        }
        JmsAvailability ja = (JmsAvailability)as.getExtensionByType(JmsAvailability.class);
        boolean jmsAvailability = false;
        if (ja != null) {
            jmsAvailability = Boolean.parseBoolean(ja.getAvailabilityEnabled());
        }
        LOG.log(Level.FINE, "JMS availability: {0}", jmsAvailability);
        return jmsAvailability;
    }

    private void setLifecycleProperties() throws Exception, ConnectorRuntimeException {
        String defaultJmsHost = this.getJmsService().getDefaultJmsHost();
        LOG.log(Level.FINE, "Default JMS Host: {0}", defaultJmsHost);
        JmsHost jmsHost = this.getJmsHost();
        if (jmsHost != null) {
            String brokerPort;
            JavaConfig javaConfig = (JavaConfig)Globals.get(JavaConfig.class);
            String java_home = javaConfig.getJavaHome();
            String brokerType = this.adjustForDirectMode(this.getJmsService().getType());
            this.brkrPort = brokerPort = jmsHost.getPort();
            String adminUserName = jmsHost.getAdminUserName();
            String adminPassword = JmsRaUtil.getUnAliasedPwd(jmsHost.getAdminPassword());
            List jmsHostProps = this.getJmsService().getProperty();
            String username = null;
            String password = null;
            if (jmsHostProps != null) {
                for (Property jmsProp : jmsHostProps) {
                    String propName = jmsProp.getName();
                    String propValue = jmsProp.getValue();
                    if ("user-name".equals(propName)) {
                        username = propValue;
                        continue;
                    }
                    if (!"password".equals(propName)) continue;
                    password = propValue;
                }
            }
            LOG.log(Level.FINE, "Broker UserName={0}", username);
            String brokerVarDir = this.getMQVarDir();
            this.createMQVarDirectoryIfNecessary(brokerVarDir);
            String tmpString = this.getJmsService().getStartArgs();
            if (tmpString == null) {
                tmpString = "";
            }
            String brokerArgs = tmpString;
            List jmsProperties = this.getJmsService().getProperty();
            List jmsHostProperties = jmsHost.getProperty();
            Properties jmsServiceProp = this.listToProperties(jmsProperties);
            Properties jmsHostProp = this.listToProperties(jmsHostProperties);
            jmsServiceProp.putAll((Map<?, ?>)jmsHostProp);
            if (!jmsServiceProp.isEmpty()) {
                if (this.dbProps == null) {
                    this.dbProps = new Properties();
                }
                this.dbProps.putAll((Map<?, ?>)jmsServiceProp);
            }
            String brokerHomeDir = this.getBrokerHomeDir();
            String brokerLibDir = this.getBrokerLibDir();
            if (this.brokerInstanceName == null) {
                this.brokerInstanceName = ActiveJmsResourceAdapter.getBrokerInstanceName(this.getJmsService());
            }
            long brokerTimeOut = this.getBrokerTimeOut(this.getJmsService());
            ConnectorDescriptor cd = this.getDescriptor();
            ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(BROKERTYPE, brokerType, "Broker Type", String.class.getName());
            this.setProperty(cd, envProp1);
            ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(BROKERINSTANCENAME, this.brokerInstanceName, "Broker Instance Name", String.class.getName());
            this.setProperty(cd, envProp2);
            ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(BROKERPORT, brokerPort, "Broker Port", "java.lang.Integer");
            this.setProperty(cd, envProp3);
            ConnectorConfigProperty envProp4 = new ConnectorConfigProperty(BROKERARGS, brokerArgs, "Broker Args", String.class.getName());
            this.setProperty(cd, envProp4);
            ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(BROKERHOMEDIR, brokerHomeDir, "Broker Home Dir", String.class.getName());
            this.setProperty(cd, envProp5);
            ConnectorConfigProperty envProp14 = new ConnectorConfigProperty(BROKERLIBDIR, brokerLibDir, "Broker Lib Dir", String.class.getName());
            this.setProperty(cd, envProp14);
            ConnectorConfigProperty envProp6 = new ConnectorConfigProperty(BROKERJAVADIR, java_home, "Broker Java Dir", String.class.getName());
            this.setProperty(cd, envProp6);
            ConnectorConfigProperty envProp7 = new ConnectorConfigProperty(BROKERVARDIR, brokerVarDir, "Broker Var Dir", String.class.getName());
            this.setProperty(cd, envProp7);
            ConnectorConfigProperty envProp8 = new ConnectorConfigProperty(BROKERSTARTTIMEOUT, "" + brokerTimeOut, "Broker Start Timeout", "java.lang.Integer");
            this.setProperty(cd, envProp8);
            ConnectorConfigProperty envProp9 = new ConnectorConfigProperty(ADMINUSERNAME, adminUserName, "Broker admin username", String.class.getName());
            this.setProperty(cd, envProp9);
            ConnectorConfigProperty envProp10 = new ConnectorConfigProperty(ADMINPASSWORD, adminPassword, "Broker admin password", String.class.getName());
            this.setProperty(cd, envProp10);
            ConnectorConfigProperty envProp11 = new ConnectorConfigProperty(USERNAME, username, "Broker username", String.class.getName());
            this.setProperty(cd, envProp11);
            ConnectorConfigProperty envProp12 = new ConnectorConfigProperty(PASSWORD, password, "Broker password", String.class.getName());
            this.setProperty(cd, envProp12);
        }
    }

    private Properties listToProperties(List<Property> props) {
        Properties properties = new Properties();
        if (props != null) {
            for (Property prop : props) {
                String key = prop.getName();
                String value = prop.getValue();
                properties.setProperty(key, value);
            }
        }
        return properties;
    }

    private String adjustForDirectMode(String brokerType) {
        if (!ActiveJmsResourceAdapter.isClustered() && brokerType.equals(EMBEDDED)) {
            String revertToEmbedded = System.getProperty(REVERT_TO_EMBEDDED_PROPERTY);
            if (revertToEmbedded != null && revertToEmbedded.equals("true")) {
                return EMBEDDED;
            }
            return DIRECT;
        }
        return brokerType;
    }

    private long getBrokerTimeOut(JmsService jmsService) {
        long defaultTimeout;
        long timeout = defaultTimeout = 30000L;
        String specifiedTimeOut = jmsService.getInitTimeoutInSeconds();
        if (specifiedTimeOut != null) {
            timeout = (long)Integer.parseInt(specifiedTimeOut) * 1000L;
        }
        return timeout;
    }

    public static String getBrokerInstanceName(JmsService js) {
        ServerEnvironmentImpl serverenv = (ServerEnvironmentImpl)Globals.get(ServerEnvironmentImpl.class);
        Domain domain = (Domain)Globals.get(Domain.class);
        String asInstance = serverenv.getInstanceName();
        String domainName = null;
        if (ActiveJmsResourceAdapter.isClustered()) {
            Server server = domain.getServerNamed(asInstance);
            domainName = server.getCluster().getName();
        } else {
            domainName = serverenv.getDomainName();
        }
        String s = ActiveJmsResourceAdapter.getBrokerInstanceName(domainName, asInstance, js);
        LOG.log(Level.FINE, "Got broker Instancename as {0}", s);
        String converted = ActiveJmsResourceAdapter.convertStringToValidMQIdentifier(s);
        LOG.log(Level.FINE, "converted instance name {0}", converted);
        return converted;
    }

    public boolean handles(ConnectorDescriptor cd, String moduleName) {
        return ConnectorsUtil.isJMSRA((String)moduleName);
    }

    public void validateActivationSpec(ActivationSpec spec) {
        boolean validate = "true".equals(System.getProperty("validate.jms.ra"));
        if (validate) {
            try {
                spec.validate();
            }
            catch (Exception ex) {
                LogHelper.log((Logger)LOG, (Level)Level.SEVERE, (String)"AS-JMS-CORE-00020", (Throwable)ex, (Object[])new Object[0]);
            }
        }
    }

    private static String getBrokerInstanceName(String asDomain, String asInstance, JmsService js) {
        List jmsProperties = js.getProperty();
        Object instanceName = null;
        Object suffix = null;
        if (jmsProperties != null) {
            for (Property p : jmsProperties) {
                String name = p.getName();
                if (name.equals("instance-name")) {
                    instanceName = p.getValue();
                }
                if (name.equals("instance-name-suffix")) {
                    suffix = p.getValue();
                }
                if (!name.equals("append-version") || !Boolean.parseBoolean(p.getValue())) continue;
                suffix = Version.getMajorVersion() + "_" + Version.getMinorVersion();
            }
        }
        if (instanceName != null) {
            return instanceName;
        }
        instanceName = asInstance.equals(DEFAULT_SERVER) ? DEFAULT_MQ_INSTANCE : asDomain + "_" + asInstance;
        if (suffix != null) {
            instanceName = (String)instanceName + "_" + suffix;
        }
        return instanceName;
    }

    private void createMQVarDirectoryIfNecessary(String mqInstanceDir) {
        File imqVarDir = new File(mqInstanceDir);
        if (imqVarDir.exists() && imqVarDir.isDirectory()) {
            LOG.log(Level.FINEST, "IMQ VAR directory already exists: {0}", imqVarDir);
            return;
        }
        if (!imqVarDir.mkdirs()) {
            LOG.log(Level.WARNING, "Failed to create dir: {0}", imqVarDir);
        }
    }

    private String getMQVarDir() {
        return new File(this.getServerEnvironment().getInstanceRoot(), MQ_DIR_NAME).getAbsolutePath();
    }

    private String getBrokerLibDir() {
        String brokerLibDir = System.getProperty(GlassFishVariable.IMQ_LIB.getSystemPropertyName());
        LOG.log(Level.FINE, "Broker lib dir from system property {0}", brokerLibDir);
        return brokerLibDir;
    }

    private String getBrokerHomeDir() {
        String brokerBinDir = System.getProperty(GlassFishVariable.IMQ_BIN.getSystemPropertyName());
        LOG.log(Level.FINEST, "Broker bin dir from system property {0}", brokerBinDir);
        String brokerHomeDir = brokerBinDir == null ? new File(System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName())).toPath().resolve(Path.of("..", "mq")).normalize().toFile().getAbsolutePath() : new File(brokerBinDir).getParentFile().getAbsolutePath();
        LOG.log(Level.INFO, "Broker Home Directory: {0}", brokerHomeDir);
        return brokerHomeDir;
    }

    private void setClusterRABeanProperties() throws ConnectorRuntimeException {
        ConnectorDescriptor cd = super.getDescriptor();
        try {
            if (!ActiveJmsResourceAdapter.isClustered()) {
                LOG.log(Level.FINE, "Instance not Clustered and hence not setting groupname");
                return;
            }
            JmsService jmsService = (JmsService)Globals.get(JmsService.class);
            String val = this.getGroupName();
            ConnectorConfigProperty envProp = new ConnectorConfigProperty(GROUPNAME, val, "Group Name", String.class.getName());
            this.setProperty(cd, envProp);
            LOG.log(Level.FINE, "CLUSTERED instance - setting groupname as {0}", val);
            boolean inClusteredContainer = false;
            if (EMBEDDED.equals(jmsService.getType()) || LOCAL.equals(jmsService.getType())) {
                inClusteredContainer = true;
            }
            ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(CLUSTERCONTAINER, Boolean.toString(inClusteredContainer), "Cluster container flag", "java.lang.Boolean");
            this.setProperty(cd, envProp1);
            LOG.log(Level.FINE, "CLUSTERED instance - setting inclusteredcontainer as {0}", inClusteredContainer);
            if (REMOTE.equals(jmsService.getType())) {
                return;
            }
            if (!this.isDBEnabled()) {
                String masterbrkr = this.getMasterBroker();
                ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(MASTERBROKER, masterbrkr, "Master  Broker", String.class.getName());
                this.setProperty(cd, envProp2);
                LOG.log(Level.FINE, "MASTERBROKER - setting master broker val {0}", masterbrkr);
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private boolean isDBEnabled() {
        ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
        Server server = this.domain.getServerNamed(serverContext.getInstanceName());
        AvailabilityService as = server.getConfig().getAvailabilityService();
        if (as != null) {
            JmsAvailability jmsAvailability = (JmsAvailability)as.getExtensionByType(JmsAvailability.class);
            if (jmsAvailability.getAvailabilityEnabled() != null && Boolean.parseBoolean(jmsAvailability.getAvailabilityEnabled())) {
                return true;
            }
            if (jmsAvailability.getConfigStoreType() != null && !"MASTERBROKER".equalsIgnoreCase(jmsAvailability.getConfigStoreType())) {
                return true;
            }
        }
        return false;
    }

    private void setAppClientRABeanProperties() throws ConnectorRuntimeException {
        LOG.log(Level.FINE, "In Appclient container!!!");
        ConnectorDescriptor cd = super.getDescriptor();
        ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(BROKERTYPE, REMOTE, "Broker Type", String.class.getName());
        this.setProperty(cd, envProp1);
        ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(GROUPNAME, "", "Group Name", String.class.getName());
        cd.removeConfigProperty(envProp2);
        ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(CLUSTERCONTAINER, "false", "Cluster flag", "java.lang.Boolean");
        this.setProperty(cd, envProp3);
    }

    private static boolean isClustered() {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        if (clusters == null) {
            return false;
        }
        List clusterList = clusters.getCluster();
        ServerContext serverctx = (ServerContext)Globals.get(ServerContext.class);
        return JmsRaUtil.isClustered(clusterList, serverctx.getInstanceName());
    }

    private String getGroupName() throws Exception {
        return this.getDomainName() + SEPARATOR + this.getClusterName();
    }

    private String getClusterName() {
        ServerContext serverctx = (ServerContext)Globals.get(ServerContext.class);
        String instanceName = serverctx.getInstanceName();
        Domain domain = (Domain)Globals.get(Domain.class);
        Server server = domain.getServerNamed(instanceName);
        return server.getCluster() == null ? null : server.getCluster().getName();
    }

    private String getMQClusterName() {
        return ActiveJmsResourceAdapter.convertStringToValidMQIdentifier(this.getClusterName()) + "_MQ";
    }

    private String getMasterBroker() throws Exception {
        return this.urlList.getMasterBroker(this.getClusterName());
    }

    private static String convertStringToValidMQIdentifier(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isLetterOrDigit(s.charAt(i))) continue;
            buf.append(s.charAt(i));
        }
        return buf.toString();
    }

    private String getDomainName() throws Exception {
        return this.domain.getName();
    }

    public void reloadRA(JmsService js) throws ConnectorRuntimeException {
        this.setMdbContainerProperties();
        this.setJmsServiceProperties(js);
        super.loadRAConfiguration();
        this.rebindDescriptor();
    }

    public void addJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.addMQUrl(host);
        this.setAddressList();
    }

    public void deleteJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.removeMQUrl(host);
        this.setAddressList();
    }

    protected JmsHost getJmsHost() {
        String defaultJmsHost = this.getJmsService().getDefaultJmsHost();
        if (defaultJmsHost == null || defaultJmsHost.isEmpty()) {
            return (JmsHost)Globals.get(JmsHost.class);
        }
        List jmsHostsList = this.getJmsService().getJmsHost();
        if (jmsHostsList == null || jmsHostsList.isEmpty()) {
            return (JmsHost)Globals.get(JmsHost.class);
        }
        JmsHost jmsHost = null;
        for (Object element : jmsHostsList) {
            JmsHost tmpJmsHost = (JmsHost)element;
            if (tmpJmsHost == null || !tmpJmsHost.getName().equals(defaultJmsHost)) continue;
            jmsHost = tmpJmsHost;
            break;
        }
        if (jmsHost == null) {
            jmsHost = (JmsHost)jmsHostsList.get(0);
        }
        return jmsHost;
    }

    public void updateJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.updateMQUrl(host);
        this.setAddressList();
    }

    public boolean getDoBind() {
        return this.doBind;
    }

    private void setMdbContainerProperties() throws ConnectorRuntimeException {
        JmsRaUtil raUtil = new JmsRaUtil(null);
        ConnectorDescriptor cd = super.getDescriptor();
        raUtil.setMdbContainerProperties();
        Object val = "" + MdbContainerProps.getReconnectEnabled();
        ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(RECONNECTENABLED, (String)val, (String)val, "java.lang.Boolean");
        this.setProperty(cd, envProp2);
        val = "" + MdbContainerProps.getReconnectDelay();
        ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(RECONNECTINTERVAL, (String)val, (String)val, "java.lang.Integer");
        this.setProperty(cd, envProp3);
        val = "" + MdbContainerProps.getReconnectMaxRetries();
        ConnectorConfigProperty envProp4 = new ConnectorConfigProperty(RECONNECTATTEMPTS, (String)val, (String)val, "java.lang.Integer");
        this.setProperty(cd, envProp4);
        String integrationMode = this.getJmsService().getType();
        boolean lazyInit = Boolean.parseBoolean(this.getJmsHost().getLazyInit());
        val = "true";
        if (EMBEDDED.equals(integrationMode) && lazyInit) {
            val = "false";
        }
        this.doBind = Boolean.parseBoolean((String)val);
        ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(MQ_PORTMAPPER_BIND, (String)val, (String)val, "java.lang.Boolean");
        this.setProperty(cd, envProp5);
    }

    private void setAddressList() throws ConnectorRuntimeException {
        try {
            JmsService jmsService = (JmsService)Globals.get(JmsService.class);
            this.setConnectionURL(jmsService, this.urlList);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "setAddressList failed.", e);
        }
        super.loadRAConfiguration();
    }

    private void setConnectionURL(JmsService jmsService, MQAddressList urlList) {
        ConnectorDescriptor cd = super.getDescriptor();
        String val = urlList.toString();
        LOG.log(Level.INFO, "AS-JMS-CORE-00001", val);
        ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(CONNECTION_URL, val, val, String.class.getName());
        this.setProperty(cd, envProp1);
    }

    private void setJmsServiceProperties(JmsService service) throws ConnectorRuntimeException {
        JmsRaUtil jmsraUtil = new JmsRaUtil(service);
        jmsraUtil.setupAddressList();
        this.urlList = jmsraUtil.getUrlList();
        this.addressList = this.urlList.toString();
        LOG.log(Level.INFO, "AS-JMS-CORE-00002", this.addressList);
        ConnectorDescriptor cd = super.getDescriptor();
        this.setConnectionURL(service, this.urlList);
        Object val = "" + jmsraUtil.getReconnectEnabled();
        ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(RECONNECTENABLED, (String)val, (String)val, "java.lang.Boolean");
        this.setProperty(cd, envProp2);
        int newval = Integer.parseInt(jmsraUtil.getReconnectInterval()) * 1000;
        val = "" + newval;
        ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(RECONNECTINTERVAL, (String)val, (String)val, "java.lang.Integer");
        this.setProperty(cd, envProp3);
        val = jmsraUtil.getReconnectAttempts();
        ConnectorConfigProperty envProp4 = new ConnectorConfigProperty(RECONNECTATTEMPTS, (String)val, (String)val, "java.lang.Integer");
        this.setProperty(cd, envProp4);
        val = jmsraUtil.getAddressListBehaviour();
        ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(ADRLIST_BEHAVIOUR, (String)val, (String)val, String.class.getName());
        this.setProperty(cd, envProp5);
        val = jmsraUtil.getAddressListIterations();
        ConnectorConfigProperty envProp6 = new ConnectorConfigProperty(ADRLIST_ITERATIONS, (String)val, (String)val, "java.lang.Integer");
        this.setProperty(cd, envProp6);
        boolean useExternal = this.shouldUseExternalRmiRegistry(jmsraUtil);
        val = Boolean.toString(useExternal);
        ConnectorConfigProperty envProp7 = new ConnectorConfigProperty(USEEXTERNALRMIREGISTRY, (String)val, (String)val, "java.lang.Boolean");
        this.setProperty(cd, envProp7);
        LOG.log(Level.FINE, "Start RMI registry set as {0}", val);
        String configuredRmiRegistryPort = null;
        configuredRmiRegistryPort = !useExternal ? this.getRmiRegistryPort() : this.getUniqueRmiRegistryPort();
        val = configuredRmiRegistryPort;
        if (val == null) {
            LOG.log(Level.WARNING, "AS-JMS-CORE-00011");
        } else {
            ConnectorConfigProperty envProp8 = new ConnectorConfigProperty(RMIREGISTRYPORT, (String)val, (String)val, "java.lang.Integer");
            this.setProperty(cd, envProp8);
            LOG.log(Level.FINE, "RMI registry port set as {0}", val);
        }
    }

    private boolean shouldUseExternalRmiRegistry(JmsRaUtil jmsraUtil) {
        boolean useExternalRmiRegistry = !this.isASRmiRegistryPortAvailable(jmsraUtil);
        return useExternalRmiRegistry;
    }

    private String getUniqueRmiRegistryPort() {
        String configuredport = System.getProperty(BROKER_RMI_PORT);
        int mqrmiport = 7776;
        try {
            mqrmiport = configuredport == null ? Integer.parseInt(this.brkrPort) + 100 : Integer.parseInt(configuredport);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Invalid IMQ Broker port: {0}", configuredport);
        }
        return Integer.toString(mqrmiport);
    }

    private String getRmiRegistryPort() {
        if (MQRmiPort != null && !MQRmiPort.isBlank()) {
            return MQRmiPort;
        }
        String configuredPort = null;
        try {
            configuredPort = this.getConfiguredRmiRegistryPort();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "AS-JMS-CORE-00015", ex);
        }
        if (configuredPort != null) {
            return configuredPort;
        }
        if (this.isDAS()) {
            return DASRMIPORT;
        }
        return null;
    }

    private boolean isDAS() {
        return DEFAULT_SERVER.equals(this.getServerContext().getInstanceName());
    }

    private String getConfiguredRmiRegistryHost() throws Exception {
        String hostName = this.getJmxConnector().getAddress();
        if (hostName.isEmpty() || hostName.equals("0.0.0.0")) {
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                hostName = "localhost";
            }
        } else if (hostName.contains(":") && !hostName.startsWith("[")) {
            return "[" + hostName + "]";
        }
        return hostName;
    }

    private String getConfiguredRmiRegistryPort() throws Exception {
        return this.getJmxConnector().getPort();
    }

    private JmxConnector getJmxConnector() throws Exception {
        List jmxConnectors = this.getAdminService().getJmxConnector();
        String sysJmsConnectorName = this.getAdminService().getSystemJmxConnectorName();
        if (jmxConnectors != null) {
            for (JmxConnector jmxConnector : jmxConnectors) {
                if (!sysJmsConnectorName.equals(jmxConnector.getName())) continue;
                return jmxConnector;
            }
        }
        return null;
    }

    private boolean isASRmiRegistryPortAvailable(JmsRaUtil jmsraUtil) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "isASRmiRegistryPortAvailable - JMSService Type: " + jmsraUtil.getJMSServiceType());
        }
        if (REMOTE.equals(jmsraUtil.getJMSServiceType()) || LOCAL.equals(jmsraUtil.getJMSServiceType())) {
            return false;
        }
        try {
            JmxConnector jmxConnector = this.getJmxConnector();
            if (!"true".equals(jmxConnector.getEnabled())) {
                return false;
            }
            if ("true".equals(jmxConnector.getSecurityEnabled())) {
                return false;
            }
            LOG.fine("Detecting JMXStartupService...");
            JMXStartupService jmxservice = (JMXStartupService)Globals.get(JMXStartupService.class);
            if (jmxservice == null) {
                return false;
            }
            jmxservice.waitUntilJMXConnectorStarted();
            LOG.fine("Found JMXStartupService");
            String name = "rmi://" + this.getConfiguredRmiRegistryHost() + ":" + this.getConfiguredRmiRegistryPort() + "/jmxrmi";
            LOG.log(Level.FINE, "Attempting to list {0}", name);
            Naming.list(name);
            LOG.log(Level.FINE, "List on {0} succeeded", name);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Failed to detect JMX RMI Registry.", e);
            return false;
        }
    }

    private void setProperty(ConnectorDescriptor cd, ConnectorConfigProperty envProp) {
        cd.removeConfigProperty(envProp);
        cd.addConfigProperty(envProp);
    }

    private void rebindDescriptor() throws ConnectorRuntimeException {
        try {
            SimpleJndiName descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor((String)super.getModuleName());
            this.nm.publishObject(descriptorJNDIName, (Object)super.getDescriptor(), true);
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ne.getMessage());
            throw (ConnectorRuntimeException)cre.initCause((Throwable)ne);
        }
    }

    public ManagedConnectionFactory[] createManagedConnectionFactories(ConnectorConnectionPool cpr, ClassLoader loader) {
        LOG.log(Level.FINE, "RECOVERY : Entering createMCFS in AJMSRA");
        ArrayList<ManagedConnectionFactory> mcfs = new ArrayList<ManagedConnectionFactory>();
        if (this.getAddressListCount() < 2) {
            mcfs.add(this.createManagedConnectionFactory(cpr, loader));
            LOG.log(Level.FINE, "Brokers are not clustered, so doing normal recovery");
        } else {
            String addlist = null;
            Set s = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
            for (ConnectorConfigProperty prop : s) {
                String propName = prop.getName();
                if (!propName.equalsIgnoreCase("imqAddressList") && !propName.equalsIgnoreCase("Addresslist")) continue;
                addlist = prop.getValue();
            }
            StringTokenizer tokenizer = null;
            tokenizer = addlist == null || addlist.trim().equalsIgnoreCase("localhost") ? new StringTokenizer(this.addressList, ",") : new StringTokenizer(addlist, ",");
            LOG.log(Level.FINE, "No of addresses found {0}", tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                String brokerurl = tokenizer.nextToken();
                ManagedConnectionFactory mcf = super.createManagedConnectionFactory(cpr, loader);
                for (ConnectorConfigProperty prop : s) {
                    String propName = prop.getName();
                    String propValue = prop.getValue();
                    if (!propName.startsWith(MQ_DIR_NAME) || "".equals(propValue)) continue;
                    try {
                        Method meth = mcf.getClass().getMethod(SETTER, String.class, String.class);
                        if (propName.trim().equalsIgnoreCase("imqAddressList")) {
                            meth.invoke((Object)mcf, prop.getName(), brokerurl);
                            continue;
                        }
                        meth.invoke((Object)mcf, prop.getName(), prop.getValueObject(String.class));
                    }
                    catch (NoSuchMethodException ex) {
                        if (!LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "AS-JMS-CORE-00012", new Object[]{SETTER, mcf.getClass().getName()});
                    }
                    catch (Exception ex) {
                        LogHelper.log((Logger)LOG, (Level)Level.SEVERE, (String)"AS-JMS-CORE-00018", (Throwable)ex, (Object[])new Object[]{SETTER, mcf.getClass().getName()});
                    }
                }
                ConnectorConfigProperty addressProp3 = new ConnectorConfigProperty(ADDRESSLIST, brokerurl, "Address List", String.class.getName());
                LOG.log(Level.INFO, "AS-JMS-CORE-00003", brokerurl);
                HashSet<ConnectorConfigProperty> addressProp = new HashSet<ConnectorConfigProperty>();
                addressProp.add(addressProp3);
                SetMethodAction setMethodAction = new SetMethodAction((Object)mcf, addressProp);
                try {
                    setMethodAction.run();
                }
                catch (Exception e) {
                    LOG.log(Level.FINEST, "SetMethodAction failed for AddressList value " + brokerurl, e);
                }
                mcfs.add(mcf);
            }
        }
        return mcfs.toArray(new ManagedConnectionFactory[mcfs.size()]);
    }

    protected ManagedConnectionFactory instantiateMCF(String mcfClass, ClassLoader loader) throws Exception {
        if (this.moduleName_.equals("jmsra")) {
            PrivilegedExceptionAction<ManagedConnectionFactory> action = () -> this.instantiateManagedConnectionFactory(mcfClass, loader);
            return AccessController.doPrivileged(action);
        }
        return null;
    }

    private ManagedConnectionFactory instantiateManagedConnectionFactory(String mcfClass, ClassLoader loader) throws Exception {
        return super.instantiateMCF(mcfClass, loader);
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ConnectorConnectionPool cpr, ClassLoader loader) {
        ManagedConnectionFactory mcf = super.createManagedConnectionFactory(cpr, loader);
        if (mcf != null) {
            Set s = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
            for (ConnectorConfigProperty prop : s) {
                String propName = prop.getName();
                if (!propName.startsWith(MQ_DIR_NAME) || "".equals(prop.getValue())) continue;
                try {
                    Method meth = mcf.getClass().getMethod(SETTER, String.class, String.class);
                    meth.invoke((Object)mcf, prop.getName(), prop.getValueObject(String.class));
                }
                catch (NoSuchMethodException ex) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "AS-JMS-CORE-00012", new Object[]{SETTER, mcf.getClass().getName()});
                }
                catch (Exception ex) {
                    LogHelper.log((Logger)LOG, (Level)Level.SEVERE, (String)"AS-JMS-CORE-00018", (Throwable)ex, (Object[])new Object[]{SETTER, mcf.getClass().getName()});
                }
            }
            String moduleName = this.getModuleName();
            if (ConnectorAdminServiceUtils.isJMSRA((String)moduleName)) {
                try {
                    ConnectorConfigProperty[] array;
                    Set configProperties = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
                    for (ConnectorConfigProperty property : array = (ConnectorConfigProperty[])configProperties.toArray(ConnectorConfigProperty[]::new)) {
                        if (!ADDRESSLIST.equals(property.getName()) || property.getValue() != null && !"".equals(property.getValue()) && !"localhost".equals(property.getValue())) continue;
                        LOG.log(Level.FINE, "{0} default value: {1}", new Object[]{ADDRESSLIST, property.getValue()});
                        configProperties.remove(property);
                    }
                    SetMethodAction setMethodAction = new SetMethodAction((Object)mcf, configProperties);
                    setMethodAction.run();
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "Resource adapter connection factory initialization failed. ", e);
                }
            }
        }
        return mcf;
    }

    public void updateMDBRuntimeInfo(EjbMessageBeanDescriptor ejbDescriptor, BeanPoolDescriptor poolDescriptor) throws ConnectorRuntimeException {
        String mdbCF;
        SimpleJndiName jndiName = this.getJndiName(ejbDescriptor);
        String destinationLookup = ejbDescriptor.getActivationConfigValue("destinationLookup");
        String destinationProp = ejbDescriptor.getActivationConfigValue(DESTINATION);
        if (destinationLookup == null && destinationProp == null && (jndiName == null || jndiName.isEmpty())) {
            LOG.log(Level.SEVERE, "AS-JMS-CORE-00019");
            String msg = I18N.getString("ajra.error_in_dd");
            throw new ConnectorRuntimeException(msg);
        }
        String resourceAdapterMid = "jmsra";
        ejbDescriptor.setResourceAdapterMid(resourceAdapterMid);
        if (destinationLookup == null && destinationProp == null) {
            String appName = ejbDescriptor.getApplication().getAppName();
            String moduleName = ConnectorsUtil.getModuleName((EjbDescriptor)ejbDescriptor);
            JMSDestinationDefinitionDescriptor destination = this.getJMSDestinationFromDescriptor(jndiName, ejbDescriptor);
            String destName = null;
            destName = this.isValidDestination(destination) ? destination.getDestinationName() : this.getPhysicalDestinationFromConfiguration(jndiName, appName, moduleName);
            ejbDescriptor.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION, destName, null));
            if (ejbDescriptor.getDestinationType() != null && !ejbDescriptor.getDestinationType().isEmpty()) {
                ejbDescriptor.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, ejbDescriptor.getDestinationType(), null));
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "AS-JMS-CORE-00004", new Object[]{ejbDescriptor.getDestinationType(), jndiName, ejbDescriptor.getName()});
                }
            } else if (this.isValidDestination(destination) && "jmsra".equals(destination.getResourceAdapter())) {
                ejbDescriptor.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, destination.getInterfaceName(), null));
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "AS-JMS-CORE-00004", new Object[]{destination.getInterfaceName(), destination.getName(), ejbDescriptor.getName()});
                }
            } else {
                try {
                    AdminObjectResource aor = (AdminObjectResource)ResourcesUtil.createInstance().getResource(jndiName, appName, moduleName, AdminObjectResource.class);
                    if (aor != null && "jmsra".equals(aor.getResAdapter())) {
                        ejbDescriptor.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, aor.getResType(), null));
                        LOG.log(Level.INFO, "AS-JMS-CORE-00004", new Object[]{aor.getResType(), aor.getJndiName(), ejbDescriptor.getName()});
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.FINEST, "Failed to put runtime activation config property for default JMS adapter.", e);
                }
            }
        }
        ejbDescriptor.putRuntimeActivationConfigProperty(new EnvironmentProperty(SUBSCRIPTION_NAME, ejbDescriptor.getDurableSubscriptionName(), null));
        try {
            mdbCF = ejbDescriptor.getMdbConnectionFactoryJndiName();
        }
        catch (NullPointerException ne) {
            mdbCF = null;
        }
        if (mdbCF != null && !mdbCF.isEmpty()) {
            this.setValuesFromConfiguration(mdbCF, ejbDescriptor);
        }
        if (poolDescriptor != null) {
            ejbDescriptor.putRuntimeActivationConfigProperty(new EnvironmentProperty(MAXPOOLSIZE, "" + poolDescriptor.getMaxPoolSize(), "", "java.lang.Integer"));
            ejbDescriptor.putRuntimeActivationConfigProperty(new EnvironmentProperty(MINPOOLSIZE, "" + poolDescriptor.getSteadyPoolSize(), "", "java.lang.Integer"));
            ejbDescriptor.putRuntimeActivationConfigProperty(new EnvironmentProperty(RESIZECOUNT, "" + poolDescriptor.getPoolResizeQuantity(), "", "java.lang.Integer"));
            ejbDescriptor.putRuntimeActivationConfigProperty(new EnvironmentProperty(RESIZETIMEOUT, "" + poolDescriptor.getPoolIdleTimeoutInSeconds(), "", "java.lang.Integer"));
            if (ejbDescriptor.getActivationConfigValue(REDELIVERYCOUNT) == null && ejbDescriptor.getActivationConfigValue(LOWERCASE_REDELIVERYCOUNT) == null) {
                ejbDescriptor.putRuntimeActivationConfigProperty(new EnvironmentProperty(REDELIVERYCOUNT, "" + MdbContainerProps.getMaxRuntimeExceptions(), "", "java.lang.Integer"));
            }
        }
        try {
            boolean clustered = ActiveJmsResourceAdapter.isClustered();
            LOG.log(Level.FINE, "Are we in a Clustered contained? {0}", clustered);
            if (clustered) {
                this.setClusterActivationSpecProperties(ejbDescriptor);
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private void setClusterActivationSpecProperties(EjbMessageBeanDescriptor descriptor_) throws Exception {
        String identifier = this.getMDBIdentifier((EjbDescriptor)descriptor_);
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MDBIDENTIFIER, identifier, "MDB Identifier", String.class.getName()));
        LOG.log(Level.FINE, "CLUSTERED instance - setting MDB identifier as {0}", identifier);
    }

    private String getMDBIdentifier(EjbDescriptor descriptor) throws Exception {
        return this.getDomainName() + SEPARATOR + this.getClusterName() + SEPARATOR + descriptor.getUniqueId();
    }

    private String getPhysicalDestinationFromConfiguration(SimpleJndiName logicalDest, String appName, String moduleName) throws ConnectorRuntimeException {
        Property ep = null;
        try {
            AdminObjectResource res = (AdminObjectResource)ResourcesUtil.createInstance().getResource(logicalDest, appName, moduleName, AdminObjectResource.class);
            if (res == null) {
                String msg = I18N.getString("ajra.err_getting_dest", (Object)logicalDest);
                throw new ConnectorRuntimeException(msg);
            }
            ep = res.getProperty(PHYSICAL_DESTINATION);
        }
        catch (Exception ce) {
            String msg = I18N.getString("ajra.err_getting_dest", (Object)logicalDest);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(msg);
            cre.initCause((Throwable)ce);
            throw cre;
        }
        if (ep == null) {
            String msg = I18N.getString("ajra.cannot_find_phy_dest", null);
            throw new ConnectorRuntimeException(msg);
        }
        return ep.getValue();
    }

    private JMSDestinationDefinitionDescriptor getJMSDestinationFromDescriptor(SimpleJndiName jndiName, EjbMessageBeanDescriptor ejbMessageBeanDescriptor) {
        JMSDestinationDefinitionDescriptor destination = null;
        if (jndiName.isJavaComponent() || !jndiName.hasJavaPrefix()) {
            destination = this.isEjbInWar(ejbMessageBeanDescriptor) ? this.getJMSDestination(jndiName, ejbMessageBeanDescriptor.getEjbBundleDescriptor().getModuleDescriptor()) : this.getJMSDestination(jndiName, ejbMessageBeanDescriptor);
        } else if (jndiName.isJavaModule()) {
            destination = this.isEjbInWar(ejbMessageBeanDescriptor) ? this.getJMSDestination(jndiName, ejbMessageBeanDescriptor.getEjbBundleDescriptor().getModuleDescriptor()) : this.getJMSDestination(jndiName, ejbMessageBeanDescriptor.getEjbBundleDescriptor());
        } else if (jndiName.isJavaApp()) {
            destination = this.getJMSDestination(jndiName, ejbMessageBeanDescriptor.getApplication());
        } else if (jndiName.isJavaGlobal() && !this.isValidDestination(destination = this.getJMSDestination(jndiName, ejbMessageBeanDescriptor.getApplication()))) {
            destination = this.getJMSDestination(jndiName);
        }
        if (this.isValidDestination(destination)) {
            return destination;
        }
        return null;
    }

    private boolean isValidDestination(JMSDestinationDefinitionDescriptor descriptor) {
        return descriptor != null && descriptor.getName() != null && !"".equals(descriptor.getName());
    }

    private boolean isEjbInWar(EjbBundleDescriptor ejbBundleDescriptor) {
        RootDeploymentDescriptor rootDeploymentDescriptor = ejbBundleDescriptor.getModuleDescriptor().getDescriptor();
        return rootDeploymentDescriptor != ejbBundleDescriptor && rootDeploymentDescriptor instanceof WebBundleDescriptor;
    }

    private boolean isEjbInWar(EjbMessageBeanDescriptor ejbMessageBeanDescriptor) {
        return this.isEjbInWar(ejbMessageBeanDescriptor.getEjbBundleDescriptor());
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(SimpleJndiName logicalDestination, EjbMessageBeanDescriptor ejbMessageBeanDescriptor) {
        return this.getJMSDestination(logicalDestination, ejbMessageBeanDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(SimpleJndiName logicalDestination, EjbBundleDescriptor ejbBundleDescriptor) {
        JMSDestinationDefinitionDescriptor destination = this.getJMSDestination(logicalDestination, ejbBundleDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
        if (this.isValidDestination(destination)) {
            return destination;
        }
        Set ejbDescriptors = ejbBundleDescriptor.getEjbs();
        for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
            destination = this.getJMSDestination(logicalDestination, ejbDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
            if (!this.isValidDestination(destination)) continue;
            return destination;
        }
        return null;
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(SimpleJndiName logicalDestination, ModuleDescriptor moduleDescriptor) {
        WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)moduleDescriptor.getDescriptor();
        JMSDestinationDefinitionDescriptor destination = this.getJMSDestination(logicalDestination, webBundleDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
        if (this.isValidDestination(destination)) {
            return destination;
        }
        Collection ejbBundleDescriptors = moduleDescriptor.getDescriptor().getExtensionsDescriptors(EjbBundleDescriptor.class);
        for (EjbBundleDescriptor ejbBundleDescriptor : ejbBundleDescriptors) {
            destination = this.getJMSDestination(logicalDestination, ejbBundleDescriptor);
            if (!this.isValidDestination(destination)) continue;
            return destination;
        }
        return null;
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(SimpleJndiName logicalDestination, Application application) {
        if (application == null) {
            return null;
        }
        JMSDestinationDefinitionDescriptor destination = this.getJMSDestination(logicalDestination, application.getResourceDescriptors(JavaEEResourceType.JMSDD));
        if (this.isValidDestination(destination)) {
            return destination;
        }
        Set webBundleDescriptors = application.getBundleDescriptors(WebBundleDescriptor.class);
        for (Object webBundleDescriptor : webBundleDescriptors) {
            destination = this.getJMSDestination(logicalDestination, webBundleDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
            if (!this.isValidDestination(destination)) continue;
            return destination;
        }
        Set ejbBundleDescriptors = application.getBundleDescriptors(EjbBundleDescriptor.class);
        for (EjbBundleDescriptor ejbBundleDescriptor : ejbBundleDescriptors) {
            destination = this.getJMSDestination(logicalDestination, ejbBundleDescriptor);
            if (!this.isValidDestination(destination)) continue;
            return destination;
        }
        Set appClientDescriptors = application.getBundleDescriptors(ApplicationClientDescriptor.class);
        for (ApplicationClientDescriptor appClientDescriptor : appClientDescriptors) {
            destination = this.getJMSDestination(logicalDestination, appClientDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
            if (!this.isValidDestination(destination)) continue;
            return destination;
        }
        return null;
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(SimpleJndiName logicalDestination) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Applications applications = domain.getApplications();
        for (com.sun.enterprise.config.serverbeans.Application app : applications.getApplications()) {
            Application application;
            JMSDestinationDefinitionDescriptor destination;
            ApplicationInfo appInfo = this.appRegistry.get(app.getName());
            if (appInfo == null || !this.isValidDestination(destination = this.getJMSDestination(logicalDestination, application = (Application)appInfo.getMetaData(Application.class)))) continue;
            return destination;
        }
        return null;
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(SimpleJndiName jndiName, Set<? extends Descriptor> descriptors) {
        for (Descriptor descriptor : descriptors) {
            if (!(descriptor instanceof JMSDestinationDefinitionDescriptor) || !jndiName.toString().equals(((JMSDestinationDefinitionDescriptor)descriptor).getName())) continue;
            return (JMSDestinationDefinitionDescriptor)descriptor;
        }
        return null;
    }

    private void setValuesFromConfiguration(String cfName, EjbMessageBeanDescriptor descriptor_) throws ConnectorRuntimeException {
        List ep = null;
        try {
            String appName = descriptor_.getApplication().getAppName();
            String moduleName = ConnectorsUtil.getModuleName((EjbDescriptor)descriptor_);
            ResourcesUtil resourcesUtil = ResourcesUtil.createInstance();
            ConnectorResource res = (ConnectorResource)resourcesUtil.getResource(new SimpleJndiName(cfName), appName, moduleName, ConnectorResource.class);
            if (res == null) {
                String msg = I18N.getString("ajra.mdb_cf_not_created", (Object)cfName);
                throw new ConnectorRuntimeException(msg);
            }
            org.glassfish.connectors.config.ConnectorConnectionPool ccp = (org.glassfish.connectors.config.ConnectorConnectionPool)resourcesUtil.getResource(new SimpleJndiName(res.getPoolName()), appName, moduleName, org.glassfish.connectors.config.ConnectorConnectionPool.class);
            ep = ccp.getProperty();
        }
        catch (Exception ce) {
            String msg = I18N.getString("ajra.mdb_cf_not_created", (Object)cfName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(msg);
            cre.initCause((Throwable)ce);
            throw cre;
        }
        if (ep == null) {
            String msg = I18N.getString("ajra.cannot_find_phy_dest");
            throw new ConnectorRuntimeException(msg);
        }
        for (Property prop : ep) {
            String val;
            String name = prop.getName();
            if (name.equals(MCFADDRESSLIST)) {
                name = ADDRESSLIST;
            }
            if ((val = prop.getValue()) == null || val.isEmpty()) continue;
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(name, val, null));
        }
    }

    public int getAddressListCount() {
        StringTokenizer tokenizer = null;
        int count = 1;
        if (this.addressList != null) {
            tokenizer = new StringTokenizer(this.addressList, ",");
            count = tokenizer.countTokens();
        }
        LOG.log(Level.FINE, "Address list count is {0}", count);
        return count;
    }

    private ServerEnvironmentImpl getServerEnvironment() {
        return (ServerEnvironmentImpl)this.serverEnvironmentImplProvider.get();
    }

    private AdminService getAdminService() {
        return (AdminService)this.adminServiceProvider.get();
    }

    private JmsService getJmsService() {
        return (JmsService)this.habitat.getService(JmsService.class, "default-instance-name", new Annotation[0]);
    }

    private ServerContext getServerContext() {
        return (ServerContext)this.serverContextProvider.get();
    }

    public boolean initializeService() {
        try {
            String module = "jmsra";
            String loc = ConnectorsUtil.getSystemModuleLocation((String)module);
            ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.connectorRuntimeProvider.get();
            connectorRuntime.createActiveResourceAdapter(loc, module, null);
            return true;
        }
        catch (ConnectorRuntimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void handleRequest(SelectableChannel selectableChannel) {
        SocketChannel socketChannel = null;
        if (selectableChannel instanceof SocketChannel) {
            socketChannel = (SocketChannel)selectableChannel;
            try {
                Class c = this.resourceadapter_.getClass();
                Method m = c.getMethod("getPortMapperClientHandler", new Class[0]);
                Object handler = m.invoke((Object)this.resourceadapter_, new Object[0]);
                m = handler.getClass().getMethod("handleRequest", SocketChannel.class);
                m.invoke(handler, socketChannel);
            }
            catch (Exception ex) {
                String message = I18N.getString("error.invoke.portmapper", (Object)ex.getLocalizedMessage());
                throw new RuntimeException(message, ex);
            }
        } else {
            throw new IllegalArgumentException(I18N.getString("invalid.socket.channel"));
        }
    }

    public void setMasterBroker(String newMasterBroker) {
        block2: {
            try {
                Class c = this.resourceadapter_.getClass();
                Method m = c.getMethod("setMasterBroker", String.class);
                m.invoke((Object)this.resourceadapter_, newMasterBroker);
                LOG.log(Level.INFO, "AS-JMS-CORE-00005", new Object[]{newMasterBroker});
            }
            catch (Exception ex) {
                if (!LOG.isLoggable(Level.INFO)) break block2;
                LOG.log(Level.INFO, "AS-JMS-CORE-00006", new Object[]{newMasterBroker, ex.getMessage()});
            }
        }
    }

    protected void setClusterBrokerList(String brokerList) {
        block2: {
            try {
                Class c = this.resourceadapter_.getClass();
                Method m = c.getMethod("setClusterBrokerList", String.class);
                m.invoke((Object)this.resourceadapter_, brokerList);
                LOG.log(Level.INFO, "AS-JMS-CORE-00007", new Object[]{brokerList});
            }
            catch (Exception ex) {
                if (!LOG.isLoggable(Level.WARNING)) break block2;
                LOG.log(Level.WARNING, "AS-JMS-CORE-00008", new Object[]{brokerList, ex.getMessage()});
            }
        }
    }

    private SimpleJndiName getJndiName(EjbMessageBeanDescriptor ejbDescriptor) {
        SimpleJndiName jndiName = ejbDescriptor.getJndiName();
        if (jndiName != null && !jndiName.isEmpty()) {
            return jndiName;
        }
        MessageDestinationDescriptor destDescriptor = ejbDescriptor.getMessageDestination();
        if (destDescriptor != null) {
            return destDescriptor.getJndiName();
        }
        return jndiName;
    }

    private static enum ClusterMode {
        ENHANCED,
        CONVENTIONAL_WITH_MASTER_BROKER,
        CONVENTIONAL_OF_PEER_BROKERS;

    }
}

