/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.impl.sql.execute.MatchingClauseConstantAction;
import org.apache.derby.impl.sql.execute.MergeConstantAction;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.shared.common.error.StandardException;

class MergeResultSet
extends NoRowsResultSetImpl {
    private NoPutResultSet _drivingLeftJoin;
    private MergeConstantAction _constants;
    private ExecRow _row;
    private long _rowCount;
    private TemporaryRowHolderImpl[] _thenRows;
    private BackingStoreHashtable _subjectRowIDs;
    private int _numOpens;

    MergeResultSet(NoPutResultSet noPutResultSet, Activation activation) throws StandardException {
        super(activation);
        this._drivingLeftJoin = noPutResultSet;
        this._constants = (MergeConstantAction)activation.getConstantAction();
        this._thenRows = new TemporaryRowHolderImpl[this._constants.matchingClauseCount()];
    }

    @Override
    public final long modifiedRowCount() {
        return this._rowCount + RowUtil.getRowCountBase();
    }

    @Override
    public void open() throws StandardException {
        this.setup();
        if (this._numOpens++ == 0) {
            this._drivingLeftJoin.openCore();
        } else {
            this._drivingLeftJoin.reopenCore();
        }
        boolean bl = this.collectAffectedRows();
        if (!bl) {
            this.activation.addWarning(StandardException.newWarning("02000", new Object[0]));
        }
        int n = this._constants.matchingClauseCount();
        for (int i = 0; i < n; ++i) {
            this._constants.getMatchingClause(i).executeConstantAction(this.activation, this._thenRows[i]);
        }
        this.cleanUp();
        this.endTime = this.getCurrentTimeMillis();
    }

    @Override
    void setup() throws StandardException {
        super.setup();
        int n = this._constants.matchingClauseCount();
        for (int i = 0; i < n; ++i) {
            this._constants.getMatchingClause(i).init();
        }
        this._rowCount = 0L;
    }

    @Override
    public void close() throws StandardException {
        this.close(false);
    }

    @Override
    public void cleanUp() throws StandardException {
        int n = this._constants.matchingClauseCount();
        for (int i = 0; i < n; ++i) {
            TemporaryRowHolderImpl temporaryRowHolderImpl = this._thenRows[i];
            if (temporaryRowHolderImpl != null) {
                temporaryRowHolderImpl.close();
                this._thenRows[i] = null;
            }
            this._constants.getMatchingClause(i).cleanUp();
        }
        if (this._drivingLeftJoin != null) {
            this._drivingLeftJoin.close();
        }
        if (this._subjectRowIDs != null) {
            this._subjectRowIDs.close();
            this._subjectRowIDs = null;
        }
        this._numOpens = 0;
    }

    @Override
    public void finish() throws StandardException {
        if (this._drivingLeftJoin != null) {
            this._drivingLeftJoin.finish();
        }
        super.finish();
    }

    boolean collectAffectedRows() throws StandardException {
        boolean bl = false;
        while (true) {
            int n;
            this._row = this._drivingLeftJoin.getNextRowCore();
            if (this._row == null) break;
            bl = true;
            DataValueDescriptor dataValueDescriptor = this._row.getColumn(this._row.nColumns());
            SQLRef sQLRef = null;
            boolean bl2 = false;
            if (dataValueDescriptor != null && !dataValueDescriptor.isNull()) {
                bl2 = true;
                sQLRef = new SQLRef((RowLocation)dataValueDescriptor.getObject());
                this._row.setColumn(this._row.nColumns(), sQLRef);
            }
            MatchingClauseConstantAction matchingClauseConstantAction = null;
            int n2 = this._constants.matchingClauseCount();
            for (n = 0; n < n2; ++n) {
                boolean bl3;
                MatchingClauseConstantAction matchingClauseConstantAction2 = this._constants.getMatchingClause(n);
                boolean bl4 = false;
                switch (matchingClauseConstantAction2.clauseType()) {
                    case 1: 
                    case 2: {
                        bl4 = true;
                    }
                }
                boolean bl5 = bl3 = bl2 == bl4;
                if (!bl3 || !matchingClauseConstantAction2.evaluateRefinementClause(this.activation)) continue;
                matchingClauseConstantAction = matchingClauseConstantAction2;
                break;
            }
            if (matchingClauseConstantAction == null) continue;
            if (sQLRef != null) {
                this.addSubjectRow(sQLRef);
            }
            for (int i = 0; i < this._row.nColumns(); ++i) {
                DataValueDescriptor dataValueDescriptor2 = this._row.getColumn(i + 1);
                if (!(dataValueDescriptor2 instanceof StreamStorable) || !dataValueDescriptor2.hasStream()) continue;
                this._row.setColumn(i + 1, dataValueDescriptor2.cloneValue(true));
            }
            this._thenRows[n] = matchingClauseConstantAction.bufferThenRow(this.activation, this._thenRows[n], this._row);
            ++this._rowCount;
        }
        return bl;
    }

    private void addSubjectRow(SQLRef sQLRef) throws StandardException {
        if (this._subjectRowIDs == null) {
            this.createSubjectRowIDhashtable();
        }
        if (this._subjectRowIDs.get(sQLRef) != null) {
            throw StandardException.newException("21000.S.1", new Object[0]);
        }
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[]{sQLRef};
        this._subjectRowIDs.putRow(true, dataValueDescriptorArray, null);
    }

    private void createSubjectRowIDhashtable() throws StandardException {
        int[] nArray = new int[]{0};
        this._subjectRowIDs = new BackingStoreHashtable(this.getActivation().getLanguageConnectionContext().getTransactionExecute(), null, nArray, false, -1L, -1L, -1, -1.0f, false, false);
    }
}

