/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.util.FacesLogger;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpSession;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class ByteArrayGuard {
    private static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();
    private static final int MAC_LENGTH = 32;
    private static final int KEY_LENGTH = 128;
    private static final int IV_LENGTH = 16;
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_CODE = "AES/CBC/PKCS5Padding";
    private static final String MAC_CODE = "HmacSHA256";
    private static final String SK_SESSION_KEY = "com.sun.faces.SK";
    private SecretKey sk;

    public ByteArrayGuard() {
        try {
            this.setupKeyAndMac();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", e);
            }
            System.err.println("ERROR: Initializing Ciphers");
        }
    }

    public byte[] encrypt(FacesContext facesContext, byte[] bytes) {
        byte[] securedata = null;
        try {
            SecureRandom rand = new SecureRandom();
            byte[] iv = new byte[16];
            rand.nextBytes(iv);
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            Cipher encryptCipher = Cipher.getInstance(CIPHER_CODE);
            SecretKey secKey = this.getSecretKey(facesContext);
            encryptCipher.init(1, (Key)secKey, ivspec);
            Mac encryptMac = Mac.getInstance(MAC_CODE);
            encryptMac.init(secKey);
            encryptMac.update(iv);
            byte[] encdata = encryptCipher.doFinal(bytes);
            byte[] macBytes = encryptMac.doFinal(encdata);
            byte[] tmp = ByteArrayGuard.concatBytes(macBytes, iv);
            securedata = ByteArrayGuard.concatBytes(tmp, encdata);
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", e);
            }
            return null;
        }
        return securedata;
    }

    public byte[] decrypt(FacesContext facesContext, byte[] bytes) {
        try {
            byte[] macBytes = new byte[32];
            System.arraycopy(bytes, 0, macBytes, 0, macBytes.length);
            byte[] iv = new byte[16];
            System.arraycopy(bytes, macBytes.length, iv, 0, iv.length);
            byte[] encdata = new byte[bytes.length - macBytes.length - iv.length];
            System.arraycopy(bytes, macBytes.length + iv.length, encdata, 0, encdata.length);
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            SecretKey secKey = this.getSecretKey(facesContext);
            Cipher decryptCipher = Cipher.getInstance(CIPHER_CODE);
            decryptCipher.init(2, (Key)secKey, ivspec);
            Mac decryptMac = Mac.getInstance(MAC_CODE);
            decryptMac.init(secKey);
            decryptMac.update(iv);
            decryptMac.update(encdata);
            byte[] macBytesCalculated = decryptMac.doFinal();
            if (this.areArrayEqualsConstantTime(macBytes, macBytesCalculated)) {
                byte[] plaindata = decryptCipher.doFinal(encdata);
                return plaindata;
            }
            System.err.println("ERROR: MAC did not verify!");
            return null;
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            System.err.println("ERROR: Decrypting:" + e.getCause());
            return null;
        }
    }

    private boolean areArrayEqualsConstantTime(byte[] array1, byte[] array2) {
        boolean result = true;
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            result = false;
        }
        return result;
    }

    private void setupKeyAndMac() {
        block5: {
            try {
                InitialContext context = new InitialContext();
                String encodedKeyArray = (String)context.lookup("java:comp/env/faces/ClientSideSecretKey");
                byte[] keyArray = Base64.getDecoder().decode(encodedKeyArray);
                this.sk = new SecretKeySpec(keyArray, KEY_ALGORITHM);
            }
            catch (NamingException exception) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block5;
                LOGGER.log(Level.FINEST, "Unable to find the encoded key.", exception);
            }
        }
        if (this.sk == null) {
            try {
                KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
                kg.init(128);
                this.sk = kg.generateKey();
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
    }

    private static byte[] concatBytes(byte[] array1, byte[] array2) {
        byte[] cBytes = new byte[array1.length + array2.length];
        try {
            System.arraycopy(array1, 0, cBytes, 0, array1.length);
            System.arraycopy(array2, 0, cBytes, array1.length, array2.length);
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
        return cBytes;
    }

    private SecretKey getSecretKey(FacesContext facesContext) {
        HttpSession session;
        SecretKey result = this.sk;
        Object sessionObj = facesContext.getExternalContext().getSession(false);
        if (null != sessionObj && sessionObj instanceof HttpSession && null == (result = (SecretKey)(session = (HttpSession)sessionObj).getAttribute(SK_SESSION_KEY))) {
            session.setAttribute(SK_SESSION_KEY, (Object)this.sk);
            result = this.sk;
        }
        return result;
    }
}

