/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ReferencedTablesVisitor;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.shared.common.error.StandardException;

public abstract class ValueNode
extends QueryTreeNode {
    private DataTypeDescriptor dataTypeServices;
    boolean transformed;

    ValueNode(ContextManager contextManager) {
        super(contextManager);
    }

    final void setType(TypeId typeId, boolean bl, int n) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, bl, n));
    }

    final void setType(TypeId typeId, int n, int n2, boolean bl, int n3) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, n, n2, bl, n3));
    }

    @Override
    public String toString() {
        return "";
    }

    DataTypeDescriptor getTypeServices() {
        return this.dataTypeServices;
    }

    public void setNullability(boolean bl) throws StandardException {
        this.setType(this.getTypeServices().getNullabilityType(bl));
    }

    public void setCollationInfo(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        this.setCollationInfo(dataTypeDescriptor.getCollationType(), dataTypeDescriptor.getCollationDerivation());
    }

    public void setCollationInfo(int n, int n2) throws StandardException {
        this.setType(this.getTypeServices().getCollatedType(n, n2));
    }

    TypeId getTypeId() throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = this.getTypeServices();
        if (dataTypeDescriptor != null) {
            return dataTypeDescriptor.getTypeId();
        }
        return null;
    }

    protected final DataValueFactory getDataValueFactory() {
        return this.getLanguageConnectionContext().getDataValueFactory();
    }

    final TypeCompiler getTypeCompiler() throws StandardException {
        return this.getTypeCompiler(this.getTypeId());
    }

    void setType(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        if (dataTypeDescriptor != null) {
            dataTypeDescriptor = this.bindUserType(dataTypeDescriptor);
        }
        this.dataTypeServices = dataTypeDescriptor;
        if (dataTypeDescriptor != null) {
            this.createTypeDependency(dataTypeDescriptor);
        }
    }

    protected final void setCollationUsingCompilationSchema() throws StandardException {
        this.setCollationUsingCompilationSchema(1);
    }

    protected final void setCollationUsingCompilationSchema(int n) throws StandardException {
        this.setCollationInfo(this.getSchemaDescriptor(null, false).getCollationType(), n);
    }

    ResultColumn getSourceResultColumn() {
        return null;
    }

    void setTransformed() {
        this.transformed = true;
    }

    boolean getTransformed() {
        return this.transformed;
    }

    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        return this.bindExpression(fromList, subqueryList, list, false);
    }

    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list, boolean bl) throws StandardException {
        return this;
    }

    ValueNode genSQLJavaSQLTree() throws StandardException {
        ContextManager contextManager = this.getContextManager();
        SQLToJavaValueNode sQLToJavaValueNode = new SQLToJavaValueNode(this, contextManager);
        JavaToSQLValueNode javaToSQLValueNode = new JavaToSQLValueNode(sQLToJavaValueNode, contextManager);
        DataTypeDescriptor dataTypeDescriptor = this.getTypeServices() != null && this.getTypeId().userType() ? this.getTypeServices() : DataTypeDescriptor.getSQLDataTypeDescriptor(((JavaValueNode)sQLToJavaValueNode).getJavaTypeName());
        javaToSQLValueNode.setType(dataTypeDescriptor);
        return javaToSQLValueNode;
    }

    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        return this;
    }

    ValueNode evaluateConstantExpressions() throws StandardException {
        return this;
    }

    ValueNode eliminateNots(boolean bl) throws StandardException {
        if (!bl) {
            return this;
        }
        return this.genEqualsFalseTree();
    }

    ValueNode genEqualsFalseTree() throws StandardException {
        BooleanConstantNode booleanConstantNode = new BooleanConstantNode(false, this.getContextManager());
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(0, this, booleanConstantNode, false, this.getContextManager());
        boolean bl = this.getTypeServices().isNullable();
        binaryRelationalOperatorNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, bl));
        return binaryRelationalOperatorNode;
    }

    ValueNode genIsNullTree(boolean bl) throws StandardException {
        IsNullNode isNullNode = new IsNullNode(this, bl, this.getContextManager());
        isNullNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, false));
        return isNullNode;
    }

    boolean verifyEliminateNots() {
        return true;
    }

    ValueNode putAndsOnTop() throws StandardException {
        BooleanConstantNode booleanConstantNode = new BooleanConstantNode(true, this.getContextManager());
        AndNode andNode = new AndNode(this, booleanConstantNode, this.getContextManager());
        andNode.postBindFixup();
        return andNode;
    }

    boolean verifyPutAndsOnTop() {
        return true;
    }

    ValueNode changeToCNF(boolean bl) throws StandardException {
        return this;
    }

    boolean verifyChangeToCNF() {
        return true;
    }

    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return true;
    }

    String getSchemaName() throws StandardException {
        return null;
    }

    String getTableName() {
        return null;
    }

    public boolean updatableByCursor() {
        return false;
    }

    String getColumnName() {
        return null;
    }

    JBitSet getTablesReferenced() throws StandardException {
        ReferencedTablesVisitor referencedTablesVisitor = new ReferencedTablesVisitor(new JBitSet(0));
        this.accept(referencedTablesVisitor);
        return referencedTablesVisitor.getTableMap();
    }

    boolean isCloneable() {
        return false;
    }

    ValueNode getClone() throws StandardException {
        return null;
    }

    void copyFields(ValueNode valueNode) throws StandardException {
        this.dataTypeServices = valueNode.getTypeServices();
    }

    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        return this;
    }

    boolean isConstantExpression() {
        return false;
    }

    boolean constantExpression(PredicateList predicateList) {
        return false;
    }

    protected int getOrderableVariantType() throws StandardException {
        return 0;
    }

    public ValueNode checkIsBoolean() throws StandardException {
        ValueNode valueNode = this;
        TypeId typeId = valueNode.getTypeId();
        if (typeId.userType()) {
            valueNode = valueNode.genSQLJavaSQLTree();
            typeId = valueNode.getTypeId();
        }
        if (!typeId.equals(TypeId.BOOLEAN_ID)) {
            throw StandardException.newException("42X19.S.1", typeId.getSQLTypeName());
        }
        return valueNode;
    }

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    @Override
    final void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateExpression(activationClassBuilder, methodBuilder);
    }

    public double selectivity(Optimizable optimizable) throws StandardException {
        if (this.transformed) {
            return 1.0;
        }
        return 0.5;
    }

    void checkTopPredicatesForEqualsConditions(int n, boolean[] blArray, int[] nArray, JBitSet[] jBitSetArray, boolean bl) throws StandardException {
        ValueNode valueNode = this;
        while (valueNode instanceof AndNode) {
            AndNode andNode = (AndNode)valueNode;
            if (andNode.getLeftOperand().isRelationalOperator() && ((RelationalOperator)((Object)andNode.getLeftOperand())).getOperator() == 1) {
                int n2;
                BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)andNode.getLeftOperand();
                ValueNode valueNode2 = binaryRelationalOperatorNode.getLeftOperand();
                ValueNode valueNode3 = binaryRelationalOperatorNode.getRightOperand();
                if (bl) {
                    for (n2 = 0; n2 < nArray.length && nArray[n2] != n; ++n2) {
                    }
                } else {
                    n2 = -1;
                }
                if (valueNode2 instanceof ColumnReference && ((ColumnReference)valueNode2).getTableNumber() == n) {
                    this.updateMaps(jBitSetArray, blArray, nArray, n, n2, valueNode3, valueNode2);
                } else if (valueNode3 instanceof ColumnReference && ((ColumnReference)valueNode3).getTableNumber() == n) {
                    this.updateMaps(jBitSetArray, blArray, nArray, n, n2, valueNode2, valueNode3);
                }
            }
            valueNode = ((AndNode)valueNode).getRightOperand();
        }
    }

    boolean isBooleanTrue() {
        return false;
    }

    boolean isBooleanFalse() {
        return false;
    }

    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }

    private void updateMaps(JBitSet[] jBitSetArray, boolean[] blArray, int[] nArray, int n, int n2, ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        if (valueNode instanceof ConstantNode || valueNode.requiresTypeFromContext()) {
            this.setValueCols(jBitSetArray, blArray, ((ColumnReference)valueNode2).getColumnNumber(), n2);
        } else if (valueNode instanceof ColumnReference && ((ColumnReference)valueNode).getTableNumber() != n) {
            int n3;
            int n4 = ((ColumnReference)valueNode).getTableNumber();
            int n5 = ((ColumnReference)valueNode2).getColumnNumber();
            for (n3 = 0; n3 < nArray.length && n4 != nArray[n3]; ++n3) {
            }
            if (n3 == nArray.length) {
                this.setValueCols(jBitSetArray, blArray, n5, n2);
            } else if (jBitSetArray != null) {
                jBitSetArray[n3].set(n5);
            }
        } else {
            int n6;
            JBitSet jBitSet = valueNode.getTablesReferenced();
            int n7 = ((ColumnReference)valueNode2).getColumnNumber();
            for (n6 = 0; n6 < nArray.length && !jBitSet.get(nArray[n6]); ++n6) {
            }
            if (n6 == nArray.length) {
                this.setValueCols(jBitSetArray, blArray, n7, n2);
            } else if (jBitSetArray != null && !jBitSet.get(n)) {
                jBitSetArray[n6].set(n7);
            }
        }
    }

    private void setValueCols(JBitSet[] jBitSetArray, boolean[] blArray, int n, int n2) {
        if (blArray != null) {
            blArray[n] = true;
        }
        if (jBitSetArray != null) {
            if (n2 == -1) {
                for (int i = 0; i < jBitSetArray.length; ++i) {
                    jBitSetArray[i].set(n);
                }
            } else {
                jBitSetArray[n2].set(n);
            }
        }
    }

    boolean isRelationalOperator() {
        return false;
    }

    boolean isBinaryEqualsOperatorNode() {
        return false;
    }

    boolean isInListProbeNode() {
        return false;
    }

    boolean optimizableEqualityNode(Optimizable optimizable, int n, boolean bl) throws StandardException {
        return false;
    }

    boolean requiresTypeFromContext() {
        return false;
    }

    boolean isParameterNode() {
        return false;
    }

    abstract boolean isEquivalent(ValueNode var1) throws StandardException;

    boolean isSameNodeKind(ValueNode valueNode) {
        return valueNode != null && valueNode.getClass().equals(this.getClass());
    }
}

