/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class ProcessManager {
    private static final System.Logger LOG = System.getLogger(ProcessManager.class.getName());
    private String[] stdinLines;
    private boolean echo = true;
    private String stdout;
    private String stderr;
    private String textToWaitFor;
    private int timeout;
    private boolean forceExit = true;
    private final ProcessBuilder builder;

    public ProcessManager(String ... cmds) {
        this.builder = new ProcessBuilder(cmds);
    }

    public ProcessManager(List<String> cmdline) {
        this.builder = new ProcessBuilder(cmdline);
    }

    public String toString() {
        return this.builder.command().toString();
    }

    public void setTimeout(int millis) {
        this.setTimeout(millis, true);
    }

    public void setTimeout(int millis, boolean forceExit) {
        if (millis < 0) {
            throw new IllegalArgumentException("Timeout cannot be negative: " + millis);
        }
        this.timeout = millis;
        this.forceExit = forceExit;
    }

    public void setEnvironment(String name, String value) {
        this.builder.environment().put(name, value);
    }

    public void setWorkingDir(File directory) {
        this.builder.directory(directory);
    }

    public void setStdinLines(List<String> list) {
        this.stdinLines = list == null || list.isEmpty() ? null : (String[])list.toArray(String[]::new);
    }

    public void setEcho(boolean newEcho) {
        this.echo = newEcho;
    }

    public void setTextToWaitFor(String textToWaitFor) {
        this.textToWaitFor = textToWaitFor;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws ProcessManagerException {
        LOG.log(System.Logger.Level.DEBUG, "Executing command:\n  command={0}  \nenv={1}", this.builder.command(), this.builder.environment());
        Process process = this.startProcess();
        try {
            boolean textDetected = this.listenProcess(process);
            int n = this.evaluateResult(process, this.timeout, textDetected);
            return n;
        }
        finally {
            if (process.isAlive() && this.forceExit) {
                ProcessManager.destroy(process);
            }
        }
    }

    private Process startProcess() throws ProcessManagerException {
        try {
            return this.builder.start();
        }
        catch (IOException e) {
            throw new ProcessManagerException("Could not execute command: " + String.valueOf(this.builder.command()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean listenProcess(Process process) throws ProcessManagerException {
        boolean isDead = false;
        ReaderThread threadErr = ReaderThread.start("stderr", process.getErrorStream(), this.echo, this.textToWaitFor);
        ReaderThread threadOut = ReaderThread.start("stdout", process.getInputStream(), this.echo, this.textToWaitFor);
        try {
            if (this.stdinLines != null && this.stdinLines.length > 0) {
                ProcessManager.writeStdin(process, this.stdinLines);
            }
            isDead = ProcessManager.waitForDeath(process, this.timeout);
        }
        finally {
            this.stderr = threadErr.finish(100L, isDead);
            this.stdout = threadOut.finish(100L, isDead);
        }
        return threadOut.isTextFound() || threadErr.isTextFound();
    }

    private int evaluateResult(Process process, int timeoutInMillis, boolean textDetected) throws ProcessManagerException {
        if (this.textToWaitFor == null) {
            if (process.isAlive()) {
                throw new ProcessManagerTimeoutException("Process with pid " + process.pid() + " is still running, timeout " + timeoutInMillis + " ms exceeded: " + process.info().commandLine().orElse(process.info().command().orElse("<unknown>")));
            }
            int exitCode = process.exitValue();
            LOG.log(System.Logger.Level.DEBUG, "Process finished with exit code {0}", exitCode);
            return exitCode;
        }
        if (textDetected) {
            LOG.log(System.Logger.Level.DEBUG, "The process produced the expected text in the output: {0}", this.textToWaitFor);
            return 0;
        }
        if (process.isAlive()) {
            throw new ProcessManagerTimeoutException("Process did not produce the expected output " + this.textToWaitFor + ", timeout " + timeoutInMillis + " ms exceeded.");
        }
        int exitCode = process.exitValue();
        throw new ProcessManagerException("Process finished with exit code " + exitCode + ", but did not produce expected output: " + this.textToWaitFor);
    }

    private static void writeStdin(Process process, String[] stdinLines) throws ProcessManagerException {
        try (OutputStreamWriter pipe = new OutputStreamWriter(process.getOutputStream(), Charset.defaultCharset());){
            for (String stdinLine : stdinLines) {
                LOG.log(System.Logger.Level.DEBUG, "InputLine --> {0} <--", stdinLine);
                try {
                    pipe.append(stdinLine);
                    pipe.append('\n');
                    pipe.flush();
                }
                catch (IOException e) {
                    throw new ProcessManagerException("Could not write " + stdinLine + " to stdin of process: " + String.valueOf(process), e);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to close the writer to STDIN: " + String.valueOf(process), e);
        }
    }

    private static void destroy(Process process) {
        process.destroy();
        boolean terminated = ProcessManager.waitForDeath(process, 10000);
        if (!terminated) {
            LOG.log(System.Logger.Level.WARNING, "Process did not exit after waiting, attempting to forcibly destroy it");
            process.destroyForcibly();
        }
    }

    private static boolean waitForDeath(Process process, int timeoutInMillis) {
        block5: {
            if (timeoutInMillis <= 0) break block5;
            LOG.log(System.Logger.Level.TRACE, "Started waiting for process death with timeout {0} ms", timeoutInMillis);
            boolean bl = process.waitFor(timeoutInMillis, TimeUnit.MILLISECONDS);
            LOG.log(System.Logger.Level.TRACE, "Finished waiting for process death: {0}", process);
            return bl;
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            try {
                LOG.log(System.Logger.Level.TRACE, "Interrupted while waiting for the process death.", (Throwable)e);
            }
            catch (Throwable throwable) {
                LOG.log(System.Logger.Level.TRACE, "Finished waiting for process death: {0}", process);
                throw throwable;
            }
            LOG.log(System.Logger.Level.TRACE, "Finished waiting for process death: {0}", process);
        }
        LOG.log(System.Logger.Level.TRACE, "Finished waiting for process death: {0}", process);
        return !process.isAlive();
    }

    private static class ReaderThread
    extends Thread {
        private final BufferedReader reader;
        private final StringBuilder output;
        private final boolean echo;
        private final Thread threadWaitingForProcess;
        private final String textToWaitFor;
        private volatile boolean textFound;

        private ReaderThread(String name, InputStream stream, boolean echo, String textToWaitFor) {
            this.setName(name);
            this.reader = new BufferedReader(new InputStreamReader(stream, Charset.defaultCharset()));
            this.output = new StringBuilder();
            this.echo = echo;
            this.textToWaitFor = textToWaitFor;
            this.threadWaitingForProcess = Thread.currentThread();
        }

        boolean isTextFound() {
            return this.textFound;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    if (this.isInterrupted()) {
                        LOG.log(System.Logger.Level.TRACE, "ReaderThread " + this.getName() + " was interrupted.");
                        return;
                    }
                    if (!this.reader.ready()) {
                        Thread.onSpinWait();
                        continue;
                    }
                    String line = this.reader.readLine();
                    boolean textDetected = this.processLine(line);
                    if (textDetected) {
                        this.textFound = true;
                        this.threadWaitingForProcess.interrupt();
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                if (this.isInterrupted()) return;
                LOG.log(System.Logger.Level.WARNING, () -> "ReaderThread " + this.getName() + " cannot read the process output.", (Throwable)e);
                return;
            }
            finally {
                LOG.log(System.Logger.Level.TRACE, "ReaderThread " + this.getName() + " stopped.");
            }
        }

        String finish(long timeoutInMillis, boolean isProcessDead) {
            this.interrupt();
            try {
                this.join(timeoutInMillis);
            }
            catch (InterruptedException ex) {
                LOG.log(System.Logger.Level.TRACE, "Interrupted while waiting for " + this.getName() + " to finish", (Throwable)ex);
            }
            if (isProcessDead) {
                this.readRemainingOutput();
            }
            return this.output.toString();
        }

        void readRemainingOutput() {
            try {
                if (this.reader.lines().filter(this::processLine).findFirst().isPresent()) {
                    this.textFound = true;
                }
            }
            catch (UncheckedIOException e) {
                LOG.log(System.Logger.Level.ERROR, "Failed to read remaining output in " + this.getName(), (Throwable)e);
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to close reader in " + this.getName(), e);
                }
            }
        }

        private boolean processLine(String line) {
            this.output.append(line).append('\n');
            if (this.echo) {
                System.out.println(line);
            }
            return this.textToWaitFor != null && line.contains(this.textToWaitFor);
        }

        static ReaderThread start(String name, InputStream errorStream, boolean echo, String textToWaitFor) {
            ReaderThread thread = new ReaderThread(name, errorStream, echo, textToWaitFor);
            thread.start();
            return thread;
        }
    }
}

