/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterView {
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    private final TreeMap<PeerID, SystemAdvertisement> view;
    private final long viewId;
    public final long masterViewId;
    private ReentrantLock viewLock = new ReentrantLock(true);

    ClusterView(TreeMap<PeerID, SystemAdvertisement> advertisements, long viewId, long masterViewId) {
        this.view = new TreeMap<PeerID, SystemAdvertisement>((SortedMap<PeerID, SystemAdvertisement>)advertisements);
        this.viewId = viewId;
        this.masterViewId = masterViewId;
    }

    ClusterView(SystemAdvertisement advertisement) {
        this.view = new TreeMap();
        this.lockLog("constructor()");
        this.viewLock.lock();
        try {
            this.view.put(advertisement.getID(), advertisement);
        }
        finally {
            this.viewLock.unlock();
        }
        this.viewId = 0L;
        this.masterViewId = 0L;
    }

    public SystemAdvertisement get(PeerID id) {
        return this.view.get(id);
    }

    public void add(SystemAdvertisement adv) {
        this.lockLog("add()");
        this.viewLock.lock();
        try {
            this.view.put(adv.getID(), adv);
        }
        finally {
            this.viewLock.unlock();
        }
    }

    public boolean containsKey(PeerID id) {
        boolean hasKey = false;
        this.lockLog("containsKey()");
        this.viewLock.lock();
        try {
            hasKey = this.view.containsKey(id);
        }
        finally {
            this.viewLock.unlock();
        }
        return hasKey;
    }

    public List<SystemAdvertisement> getView() {
        ArrayList<SystemAdvertisement> viewCopy;
        this.lockLog("getView()");
        this.viewLock.lock();
        try {
            viewCopy = new ArrayList<SystemAdvertisement>(this.view.values());
        }
        finally {
            this.viewLock.unlock();
        }
        return viewCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPeerNamesInView() {
        ArrayList<String> peerNamesList = new ArrayList<String>();
        this.lockLog("getPeerNamesInView()");
        this.viewLock.lock();
        try {
            for (PeerID peerID : this.view.keySet()) {
                peerNamesList.add(peerID.toString());
            }
        }
        finally {
            this.viewLock.unlock();
        }
        return peerNamesList;
    }

    public int getSize() {
        int size = 0;
        this.lockLog("getSize()");
        this.viewLock.lock();
        try {
            size = this.view.size();
        }
        finally {
            this.viewLock.unlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemAdvertisement getMasterCandidate() {
        this.lockLog("getMasterCandidate()");
        this.viewLock.lock();
        try {
            PeerID id = this.view.firstKey();
            SystemAdvertisement adv = this.view.get(id);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Returning Master Candidate Node :" + adv.getName() + ' ' + adv.getID());
            }
            SystemAdvertisement systemAdvertisement = adv;
            return systemAdvertisement;
        }
        finally {
            this.viewLock.unlock();
        }
    }

    public boolean isFirst(SystemAdvertisement advertisement) {
        PeerID id = this.view.firstKey();
        return advertisement.getID().equals(id);
    }

    public long getClusterViewId() {
        return this.viewId;
    }

    public void clear() {
        this.lockLog("clear()");
        this.viewLock.lock();
        try {
            this.view.clear();
        }
        finally {
            this.viewLock.unlock();
        }
    }

    private void lockLog(String method) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, MessageFormat.format("{0} viewLock Hold count :{1}, lock queue count:{2}", method, this.viewLock.getHoldCount(), this.viewLock.getQueueLength()));
        }
    }
}

