/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.api;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreMBean;

public class ReplicatedDataStoreStatsHolder<K, V>
implements DataStoreMBean {
    private DataStoreContext<K, V> dsc;
    private String keyClassName;
    private String valueClassName;
    private String keyTransformerClassName;
    private String entryUpdaterClassName;
    private AtomicInteger saveCount = new AtomicInteger(0);
    private AtomicInteger executedSaveCount = new AtomicInteger(0);
    private AtomicInteger loadCount = new AtomicInteger(0);
    private AtomicInteger loadSuccessCount = new AtomicInteger(0);
    private AtomicInteger localLoadSuccessCount = new AtomicInteger(0);
    private AtomicInteger simpleLoadSuccessCount = new AtomicInteger(0);
    private AtomicInteger broadcastLoadSuccessCount = new AtomicInteger(0);
    private AtomicInteger saveOnLoadCount = new AtomicInteger(0);
    private AtomicInteger loadFailureCount = new AtomicInteger(0);
    private AtomicInteger removeCount = new AtomicInteger(0);
    private AtomicInteger executedRemoveCount = new AtomicInteger(0);
    private AtomicInteger batchSentCount = new AtomicInteger(0);
    private AtomicInteger batchReceivedCount = new AtomicInteger(0);
    private AtomicInteger flushThreadWakeupCount = new AtomicInteger(0);
    private AtomicInteger flushThreadFlushedCount = new AtomicInteger(0);
    private AtomicInteger removeExpiredCallCount = new AtomicInteger(0);
    private AtomicInteger removeExpiredEntriesCount = new AtomicInteger(0);
    private AtomicInteger gmsSendCount = new AtomicInteger(0);
    private AtomicLong gmsSendBytesCount = new AtomicLong(0L);

    public ReplicatedDataStoreStatsHolder(DataStoreContext<K, V> dsc) {
        this.dsc = dsc;
        this.keyClassName = dsc.getKeyClazz() != null ? dsc.getKeyClazz().getName() : "?";
        this.valueClassName = dsc.getValueClazz() != null ? dsc.getValueClazz().getName() : "?";
        this.keyTransformerClassName = dsc.getKeyTransformer() != null ? dsc.getKeyTransformer().getClass().getName() : "?";
        this.entryUpdaterClassName = dsc.getDataStoreEntryUpdater() != null ? dsc.getDataStoreEntryUpdater().getClass().getName() : "?";
    }

    @Override
    public String getStoreName() {
        return this.dsc.getStoreName();
    }

    @Override
    public String getKeyClassName() {
        return this.keyClassName;
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    @Override
    public String getEntryUpdaterClassName() {
        return this.entryUpdaterClassName;
    }

    @Override
    public String getKeyTransformerClassName() {
        return this.keyTransformerClassName;
    }

    @Override
    public int getSize() {
        return this.dsc.getReplicaStore().size();
    }

    @Override
    public int getSentSaveCount() {
        return this.saveCount.get();
    }

    @Override
    public int getExecutedSaveCount() {
        return this.executedSaveCount.get();
    }

    @Override
    public int getBatchSentCount() {
        return this.batchSentCount.get();
    }

    @Override
    public int getLoadCount() {
        return this.loadCount.get();
    }

    @Override
    public int getLoadSuccessCount() {
        return this.loadSuccessCount.get();
    }

    @Override
    public int getLocalLoadSuccessCount() {
        return this.localLoadSuccessCount.get();
    }

    @Override
    public int getSimpleLoadSuccessCount() {
        return this.simpleLoadSuccessCount.get();
    }

    @Override
    public int getBroadcastLoadSuccessCount() {
        return this.broadcastLoadSuccessCount.get();
    }

    @Override
    public int getLoadFailureCount() {
        return this.loadFailureCount.get();
    }

    @Override
    public int getBatchReceivedCount() {
        return this.batchReceivedCount.get();
    }

    @Override
    public int getSentRemoveCount() {
        return this.removeCount.get();
    }

    @Override
    public int getExecutedRemoveCount() {
        return this.executedRemoveCount.get();
    }

    @Override
    public int getFlushThreadFlushedCount() {
        return this.flushThreadFlushedCount.get();
    }

    @Override
    public int getFlushThreadWakeupCount() {
        return this.flushThreadWakeupCount.get();
    }

    @Override
    public int getSaveOnLoadCount() {
        return this.saveOnLoadCount.get();
    }

    @Override
    public int getExpiredEntriesCount() {
        return this.removeExpiredEntriesCount.get();
    }

    @Override
    public int getRemoveExpiredCallCount() {
        return this.removeExpiredCallCount.get();
    }

    @Override
    public int getGmsSendCount() {
        return this.gmsSendCount.get();
    }

    @Override
    public long getGmsSendBytesCount() {
        return this.gmsSendBytesCount.get();
    }

    public int incrementBatchSentCount() {
        return this.batchSentCount.incrementAndGet();
    }

    public int incrementSaveCount() {
        return this.saveCount.incrementAndGet();
    }

    public int incrementExecutedSaveCount() {
        return this.executedSaveCount.incrementAndGet();
    }

    public int incrementLoadCount() {
        return this.loadCount.incrementAndGet();
    }

    public int incrementLoadSuccessCount() {
        return this.loadSuccessCount.incrementAndGet();
    }

    public int incrementLocalLoadSuccessCount() {
        return this.localLoadSuccessCount.incrementAndGet();
    }

    public int incrementSimpleLoadSuccessCount() {
        return this.simpleLoadSuccessCount.incrementAndGet();
    }

    public int incrementBroadcastLoadSuccessCount() {
        return this.broadcastLoadSuccessCount.incrementAndGet();
    }

    public int incrementLoadFailureCount() {
        return this.loadFailureCount.incrementAndGet();
    }

    public int incrementRemoveCount() {
        return this.removeCount.incrementAndGet();
    }

    public int incrementExecutedRemoveCount() {
        return this.executedRemoveCount.incrementAndGet();
    }

    public int incrementBatchReceivedCount() {
        return this.batchReceivedCount.incrementAndGet();
    }

    public int incrementFlushThreadWakeupCount() {
        return this.flushThreadWakeupCount.incrementAndGet();
    }

    public int incrementFlushThreadFlushedCount() {
        return this.flushThreadFlushedCount.incrementAndGet();
    }

    public int incrementSaveOnLoadCount() {
        return this.saveOnLoadCount.incrementAndGet();
    }

    public int incrementRemoveExpiredCallCount() {
        return this.removeExpiredCallCount.incrementAndGet();
    }

    public int incrementRemoveExpiredEntriesCount(int delta) {
        return this.removeExpiredEntriesCount.addAndGet(delta);
    }

    public int incrementGmsSendCount() {
        return this.gmsSendCount.incrementAndGet();
    }

    public long incrementGmsSendBytesCount(int delta) {
        return this.gmsSendBytesCount.addAndGet(delta);
    }

    public int updateExecutedRemoveCount(int delta) {
        return this.executedRemoveCount.addAndGet(delta);
    }

    public String toString() {
        return "ReplicatedDataStoreStatsHolder{name=" + this.getStoreName() + ", keyClassName='" + this.getKeyClassName() + "', valueClassName='" + this.getValueClassName() + "', sentSaveCount=" + this.getSentSaveCount() + ", executedSaveCount=" + this.getExecutedSaveCount() + ", saveOnLoadCount=" + this.getSaveOnLoadCount() + ", loadCount=" + this.getLoadCount() + ", localLoadSuccessCount=" + this.getLocalLoadSuccessCount() + ", simpleLoadSuccessCount=" + this.getSimpleLoadSuccessCount() + ", broadcastLoadSuccessCount=" + this.getBroadcastLoadSuccessCount() + ", loadSuccessCount=" + this.getLoadSuccessCount() + ", loadFailureCount=" + this.getLoadFailureCount() + ", sentRemoveCount=" + this.getSentRemoveCount() + ", executedRemoveCount=" + this.getExecutedRemoveCount() + ", batchSentCount=" + this.getBatchSentCount() + ", batchReceivedCount=" + this.getBatchReceivedCount() + ", flushThreadWakeupCount=" + this.getFlushThreadWakeupCount() + ", flushThreadFlushedCount=" + this.getFlushThreadFlushedCount() + ", removeExpiredCallCount=" + this.getRemoveExpiredCallCount() + ", expiredEntriesCount=" + this.getExpiredEntriesCount() + ", gmsSendCount=" + this.getGmsSendCount() + ", gmsSendBytesCount=" + this.getGmsSendBytesCount() + "}";
    }
}

