/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPAttribute;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPModification;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

@NotExtensible
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class LDAPModificationSet
implements Serializable {
    private static final long serialVersionUID = -1789929614205832665L;
    private final ArrayList<LDAPModification> mods = new ArrayList(1);

    public void add(int op, LDAPAttribute attr) {
        this.mods.add(new LDAPModification(op, attr));
    }

    public LDAPModification elementAt(int index) throws IndexOutOfBoundsException {
        return this.mods.get(index);
    }

    public void removeElementAt(int index) throws IndexOutOfBoundsException {
        this.mods.remove(index);
    }

    public void remove(String name) {
        Iterator<LDAPModification> iterator = this.mods.iterator();
        while (iterator.hasNext()) {
            LDAPModification mod = iterator.next();
            if (!mod.getAttribute().getName().equalsIgnoreCase(name)) continue;
            iterator.remove();
            return;
        }
    }

    public int size() {
        return this.mods.size();
    }

    public LDAPModification[] toArray() {
        LDAPModification[] modArray = new LDAPModification[this.mods.size()];
        return this.mods.toArray(modArray);
    }

    public String toString() {
        return this.mods.toString();
    }
}

