/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.config;

import com.sun.ts.tests.jaspic.tssv.config.TSServerAuthConfig;
import com.sun.ts.tests.jaspic.tssv.util.TSFileHandler;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import com.sun.ts.tests.jaspic.tssv.util.TSXMLFormatter;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ServerAuthConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.callback.CallbackHandler;

public class TSAuthConfigProviderServlet
implements AuthConfigProvider {
    private static TSLogger logger;
    private HashMap serverAuthConfigMap = new HashMap();
    private static Map properties;

    public TSAuthConfigProviderServlet(Map props, AuthConfigFactory factory) {
        properties = props;
        if (factory != null) {
            factory.registerConfigProvider((AuthConfigProvider)this, null, null, "TSAuthConfigProviderServlet self registration");
        }
        if (logger == null) {
            TSAuthConfigProviderServlet.initializeTSLogger();
        }
        logger.log(Level.INFO, "invoked TSAuthConfigProviderServlet() constructor(2 args)");
    }

    public TSAuthConfigProviderServlet(Map props, TSLogger tsLogger, AuthConfigFactory factory) {
        properties = props;
        if (factory != null) {
            factory.registerConfigProvider((AuthConfigProvider)this, null, null, "TSAuthConfigProviderServlet self registration");
        }
        if (tsLogger != null) {
            logger = tsLogger;
        }
        logger.log(Level.INFO, "invoked TSAuthConfigProviderServlet() constructor(3 args)");
    }

    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        logger.log(Level.INFO, "WARNING:  shouldn't get into ClientAuthConfig() for servlet profile");
        return null;
    }

    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        logger.log(Level.INFO, "TSAuthConfigProviderServlet.getServerAuthConfig() called");
        String logStr = "TSAuthConfigProviderServlet.getServerAuthConfig : layer=" + layer + " : appContext=" + appContext;
        logger.log(Level.INFO, logStr);
        try {
            String msg;
            if (handler == null) {
                msg = "FAILURE: layer=" + layer + " appContext=" + appContext;
                msg = msg + " getServerAuthConfig() received CallbackHandler=null";
                logger.log(Level.INFO, msg);
            } else {
                msg = "layer=" + layer + " appContext=" + appContext;
                msg = msg + " getServerAuthConfig() received CallbackHandler=non-null";
                logger.log(Level.INFO, msg);
            }
            TSServerAuthConfig serverAuthConfig = new TSServerAuthConfig(layer, appContext, handler, properties, logger);
            this.serverAuthConfigMap.put(layer + appContext, serverAuthConfig);
            return serverAuthConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AuthException(e.getMessage());
        }
    }

    public void refresh() {
    }

    private static void initializeTSLogger() {
        String logFileLocation = null;
        if (logger != null) {
            return;
        }
        try {
            logFileLocation = System.getProperty("log.file.location");
            if (logFileLocation == null) {
                throw new RuntimeException("log.file.location not set");
            }
            logger = TSLogger.getTSLogger("jsr196");
            boolean appendMode = true;
            TSFileHandler fileHandler = new TSFileHandler(logFileLocation + "/TSSVLog.txt", appendMode);
            fileHandler.setFormatter(new TSXMLFormatter());
            logger.addHandler(fileHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("TSLogger Initialization failed", e);
        }
    }

    static {
        properties = null;
    }
}

