/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.CustomTestResultViewer;
import com.sun.javatest.exec.FeatureManager;
import com.sun.javatest.exec.TP_CustomSubpanel;
import com.sun.javatest.exec.TP_DescSubpanel;
import com.sun.javatest.exec.TP_DocumentationSubpanel;
import com.sun.javatest.exec.TP_EnvSubpanel;
import com.sun.javatest.exec.TP_FilesSubpanel;
import com.sun.javatest.exec.TP_OutputSubpanel;
import com.sun.javatest.exec.TP_ResultsSubpanel;
import com.sun.javatest.exec.TP_Subpanel;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TestPanel
extends JPanel {
    static final String lineSeparator = System.getProperty("line.separator");
    private UIFactory uif;
    private TP_Subpanel[] panels;
    private TP_Subpanel[] stdPanels;
    private JTabbedPane tabs;
    private TP_DescSubpanel descPanel;
    private TP_DocumentationSubpanel docPanel;
    private TP_FilesSubpanel filesPanel;
    private TP_ResultsSubpanel resultPanel;
    private TP_EnvSubpanel envPanel;
    private TP_OutputSubpanel outputPanel;
    private JTextField statusField;
    private HashMap customViewTable;
    private Harness harness;
    private ContextManager contextManager;
    private TestResult currTest;
    private TP_Subpanel currPanel;
    private TestDescription currDesc;
    private boolean needToUpdateGUIWhenShown = true;
    private boolean updatePending = false;
    private final Observer observer = new Observer();

    TestPanel(UIFactory uif, Harness harness, ContextManager contextManager) {
        this.uif = uif;
        this.harness = harness;
        this.contextManager = contextManager;
        this.initGUI();
    }

    @Override
    public Dimension getPreferredSize() {
        int dpi = this.uif.getDotsPerInch();
        return new Dimension(5 * dpi, 4 * dpi);
    }

    void setTestSuite(TestSuite ts) {
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i].setTestSuite(ts);
        }
    }

    TestResult getTest() {
        return this.currTest;
    }

    void setTest(TestResult tr) {
        for (int i = this.stdPanels.length; i < this.panels.length; ++i) {
            TP_CustomSubpanel sp;
            sp.onCangedTestResult(tr, (sp = (TP_CustomSubpanel)this.panels[i]) == this.currPanel);
        }
        this.updatePanel(tr, this.currPanel);
    }

    private synchronized void updatePanel(TestResult newTest, TP_Subpanel newPanel) {
        if (newTest != this.currTest) {
            this.currTest = newTest;
            this.currDesc = null;
        }
        if (newPanel != this.currPanel) {
            ContextHelpManager.setHelpIDString(this.tabs, ContextHelpManager.getHelpIDString(newPanel));
            this.currPanel = newPanel;
        }
        if (EventQueue.isDispatchThread()) {
            this.updateGUIWhenVisible();
        } else if (!this.updatePending && !this.needToUpdateGUIWhenShown) {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TestPanel testPanel = TestPanel.this;
                    synchronized (testPanel) {
                        TestPanel.this.updateGUIWhenVisible();
                        TestPanel.this.updatePending = false;
                    }
                }
            });
            this.updatePending = true;
        }
    }

    private void updateGUIWhenVisible() {
        if (this.isVisible()) {
            this.updateGUI();
        } else {
            this.needToUpdateGUIWhenShown = true;
        }
    }

    private synchronized void updateGUI() {
        if (this.currTest == null) {
            for (int i = 0; i < this.tabs.getComponentCount(); ++i) {
                this.tabs.setEnabledAt(i, false);
            }
            this.statusField.setEnabled(false);
        } else {
            boolean hasEnv;
            try {
                if (this.currDesc == null) {
                    this.currDesc = this.currTest.getDescription();
                }
            }
            catch (TestResult.Fault e) {
                JavaTestError.unexpectedException(e);
            }
            this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.descPanel), true);
            this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.filesPanel), true);
            try {
                Map map = this.currTest.getEnvironment();
                hasEnv = map != null && map.size() > 0;
            }
            catch (TestResult.Fault f) {
                hasEnv = false;
            }
            this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.envPanel), hasEnv);
            boolean hasResults = this.currTest.getPropertyNames().hasMoreElements();
            this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.resultPanel), hasResults);
            boolean hasOutput = this.currTest.getSectionCount() > 0;
            this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.outputPanel), hasOutput);
            for (int i = this.stdPanels.length; i < this.tabs.getTabCount(); ++i) {
                this.tabs.setEnabledAt(i, true);
            }
            this.updateStatus();
            if (this.currPanel.isUpdateRequired(this.currTest)) {
                this.currPanel.updateSubpanel(this.currTest);
            }
            FeatureManager fm = this.contextManager.getFeatureManager();
            if (fm.isEnabled(6)) {
                if (this.docPanel.isUpdateRequired(this.currTest)) {
                    this.docPanel.updateSubpanel(this.currTest);
                }
                this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.docPanel), this.docPanel.getDocuments() != null);
            }
        }
    }

    private void updateStatus() {
        if (this.isShowing()) {
            Status s = this.currTest.getStatus();
            this.statusField.setText(I18NUtils.getStatusMessage(s));
            Color c = I18NUtils.getStatusBarColor(s.getType());
            this.statusField.setBackground(c);
            this.statusField.setEnabled(true);
        }
    }

    private void updateCustomPanels(TestResult tr, TP_Subpanel currPanel) {
        for (int i = this.stdPanels.length; i < this.panels.length; ++i) {
            TP_CustomSubpanel sp = (TP_CustomSubpanel)this.panels[i];
            if (sp == currPanel) continue;
            sp.updateSubpanel(tr);
        }
    }

    private void initGUI() {
        CustomTestResultViewer[] cv;
        this.setName("test");
        this.descPanel = new TP_DescSubpanel(this.uif);
        this.filesPanel = new TP_FilesSubpanel(this.uif);
        this.resultPanel = new TP_ResultsSubpanel(this.uif);
        this.envPanel = new TP_EnvSubpanel(this.uif);
        this.outputPanel = new TP_OutputSubpanel(this.uif);
        Vector<TP_Subpanel> vpanels = new Vector<TP_Subpanel>();
        vpanels.add(this.descPanel);
        FeatureManager fm = this.contextManager.getFeatureManager();
        if (fm.isEnabled(6)) {
            this.docPanel = new TP_DocumentationSubpanel(this.uif);
            vpanels.add(this.docPanel);
        }
        vpanels.add(this.filesPanel);
        vpanels.add(this.resultPanel);
        vpanels.add(this.envPanel);
        vpanels.add(this.outputPanel);
        this.stdPanels = new TP_Subpanel[vpanels.size()];
        this.stdPanels = vpanels.toArray(this.stdPanels);
        this.tabs = this.uif.createTabbedPane("test", this.stdPanels);
        this.panels = this.stdPanels;
        if (this.contextManager != null && (cv = this.contextManager.getCustomResultViewers()) != null) {
            int i;
            this.customViewTable = new HashMap();
            this.panels = new TP_Subpanel[this.stdPanels.length + cv.length];
            System.arraycopy(this.stdPanels, 0, this.panels, 0, this.stdPanels.length);
            for (i = 0; i < cv.length; ++i) {
                this.panels[this.stdPanels.length + i] = new TP_CustomSubpanel(this.uif, cv[i]);
                this.customViewTable.put(cv[i], this.panels[this.stdPanels.length + i]);
                if (!cv[i].isViewerVisible()) continue;
                this.tabs.addTab(cv[i].getDescription(), null, cv[i], cv[i].getDescription());
            }
            for (i = 0; i < cv.length; ++i) {
                cv[i].addPropertyChangeListener("visibleTab", new ViewerStateListener(cv, i, this.stdPanels.length));
            }
        }
        this.tabs.setTabPlacement(1);
        this.tabs.setName("testTabs");
        this.tabs.setSelectedComponent(this.outputPanel);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = TestPanel.this.tabs.getSelectedComponent();
                if (c instanceof TP_Subpanel) {
                    TestPanel.this.updatePanel(TestPanel.this.currTest, (TP_Subpanel)c);
                }
                if (c instanceof CustomTestResultViewer) {
                    TestPanel.this.updatePanel(TestPanel.this.currTest, (TP_CustomSubpanel)TestPanel.this.customViewTable.get(c));
                }
            }
        });
        this.currPanel = this.outputPanel;
        ContextHelpManager.setHelpIDString(this.tabs, ContextHelpManager.getHelpIDString(this.currPanel));
        this.statusField = this.uif.createOutputField("test.status");
        this.statusField.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.statusField, "South");
        ComponentListener cl = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (TestPanel.this.needToUpdateGUIWhenShown) {
                    TestPanel.this.updateGUI();
                    TestPanel.this.needToUpdateGUIWhenShown = false;
                }
                TestPanel.this.harness.addObserver(TestPanel.this.observer);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                TestPanel.this.harness.removeObserver(TestPanel.this.observer);
            }
        };
        this.addComponentListener(cl);
    }

    private class Observer
    implements Harness.Observer,
    TestResult.Observer {
        private Observer() {
        }

        @Override
        public void startingTestRun(Parameters params) {
        }

        @Override
        public void startingTest(TestResult tr) {
            try {
                if (tr.getDescription() == TestPanel.this.currDesc) {
                    TestPanel.this.updatePanel(tr, TestPanel.this.currPanel);
                    TestPanel.this.updateCustomPanels(tr, TestPanel.this.currPanel);
                }
            }
            catch (TestResult.Fault fault) {
                // empty catch block
            }
        }

        @Override
        public void finishedTest(TestResult tr) {
            if (tr == TestPanel.this.currTest) {
                TestPanel.this.updatePanel(tr, TestPanel.this.currPanel);
                TestPanel.this.updateCustomPanels(tr, TestPanel.this.currPanel);
            }
        }

        @Override
        public void stoppingTestRun() {
        }

        @Override
        public void finishedTesting() {
        }

        @Override
        public void finishedTestRun(boolean allOK) {
        }

        @Override
        public void error(String msg) {
        }

        @Override
        public void completed(TestResult tr) {
            tr.removeObserver(this);
            TestPanel.this.updateStatus();
        }

        @Override
        public void createdSection(TestResult tr, TestResult.Section section) {
        }

        @Override
        public void completedSection(TestResult tr, TestResult.Section section) {
        }

        @Override
        public void createdOutput(TestResult tr, TestResult.Section section, String outputName) {
        }

        @Override
        public void completedOutput(TestResult tr, TestResult.Section section, String outputName) {
        }

        @Override
        public void updatedOutput(TestResult tr, TestResult.Section section, String outputName, int start, int end, String text) {
        }

        @Override
        public void updatedProperty(TestResult tr, String name, String value) {
        }
    }

    class ViewerStateListener
    implements PropertyChangeListener {
        private CustomTestResultViewer[] cv;
        private int pos;
        private int offset;

        ViewerStateListener(CustomTestResultViewer[] cv, int pos, int offset) {
            this.cv = cv;
            this.pos = pos;
            this.offset = offset;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Boolean state = (Boolean)evt.getNewValue();
            if (state.booleanValue()) {
                int j = this.offset;
                for (int i = 0; i < this.pos; ++i) {
                    if (TestPanel.this.tabs.indexOfComponent(this.cv[i]) < 0) continue;
                    ++j;
                }
                TestPanel.this.tabs.insertTab(this.cv[this.pos].getDescription(), null, this.cv[this.pos], this.cv[this.pos].getDescription(), j);
            } else {
                TestPanel.this.tabs.remove(this.cv[this.pos]);
            }
        }
    }
}

