/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.implementation.sun.jms;

import com.sun.ts.lib.porting.TSJMSObjectsInterface;
import com.sun.ts.lib.util.TestUtil;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SunRIJMSObjects
implements TSJMSObjectsInterface {
    private static Context jndiContext = null;
    private static QueueConnectionFactory qcf = null;
    private static TopicConnectionFactory tcf = null;
    private static ConnectionFactory cf = null;
    private Topic testTopic = null;
    private Queue testQueue = null;

    private void getJNDIContext() throws Exception {
        if (jndiContext == null) {
            try {
                TestUtil.logTrace((String)"Getting initial context");
                jndiContext = new InitialContext();
            }
            catch (NamingException ne) {
                TestUtil.logErr((String)"Could not create JNDI context because: ", (Throwable)ne);
                TestUtil.printStackTrace((Throwable)ne);
                throw ne;
            }
        }
    }

    public Queue getQueue(String name) throws Exception {
        this.getJNDIContext();
        try {
            this.testQueue = (Queue)jndiContext.lookup(name);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Failed to lookup Queue");
            TestUtil.printStackTrace((Throwable)e);
            throw e;
        }
        return this.testQueue;
    }

    public Topic getTopic(String name) throws Exception {
        this.getJNDIContext();
        try {
            this.testTopic = (Topic)jndiContext.lookup(name);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Failed to lookup Topic");
            TestUtil.printStackTrace((Throwable)e);
            throw e;
        }
        return this.testTopic;
    }

    public QueueConnectionFactory getQueueConnectionFactory(String name) throws Exception {
        this.getJNDIContext();
        try {
            qcf = (QueueConnectionFactory)jndiContext.lookup(name);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Failed to lookup QueueConnectionFactory");
            TestUtil.printStackTrace((Throwable)e);
            throw e;
        }
        return qcf;
    }

    public TopicConnectionFactory getTopicConnectionFactory(String name) throws Exception {
        this.getJNDIContext();
        try {
            tcf = (TopicConnectionFactory)jndiContext.lookup(name);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Failed to lookup TopicConnectionFactory");
            TestUtil.printStackTrace((Throwable)e);
            throw e;
        }
        return tcf;
    }

    public ConnectionFactory getConnectionFactory(String name) throws Exception {
        this.getJNDIContext();
        try {
            cf = (ConnectionFactory)jndiContext.lookup(name);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Failed to lookup ConnectionFactory");
            TestUtil.printStackTrace((Throwable)e);
            throw e;
        }
        return cf;
    }
}

