/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.IconFactory;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.FileInfoCache;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class TestSuiteChooser
extends JFileChooser {
    private FileInfoCache cache = new FileInfoCache();
    private TestSuite selectedTestSuite;
    private UIFactory uif;
    private Icon icon;

    public TestSuiteChooser() {
        this(new File(System.getProperty("user.dir")));
    }

    public TestSuiteChooser(File initialDir) {
        super(TestSuiteChooser.normalize(initialDir));
        this.setName("tsc");
        this.uif = new UIFactory(this, null);
        this.icon = IconFactory.getSelectableFolderIcon();
        this.setDialogTitle(this.uif.getI18NString("tsc.title"));
        this.setApproveButtonText(this.uif.getI18NString("tsc.open.btn"));
        this.setApproveButtonMnemonic(this.uif.getI18NMnemonic("tsc.open.mne"));
        this.setApproveButtonToolTipText(this.uif.getI18NString("tsc.open.tip"));
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(new TSC_FileFilter());
        this.setFileView(new TSC_FileView());
        this.setFileSelectionMode(2);
    }

    public TestSuite getSelectedTestSuite() {
        return this.selectedTestSuite;
    }

    public void setSelectedTestSuite(TestSuite ts) {
        if (ts != null) {
            this.setSelectedFile(ts.getRoot());
        }
        this.selectedTestSuite = ts;
    }

    public int showDialog(Component parent) {
        return this.showDialog(parent, this.getApproveButtonText());
    }

    @Override
    public void approveSelection() {
        File file = this.getSelectedFile();
        if (this.isTraversable(file)) {
            this.setCurrentDirectory(file);
            this.setSelectedFile(null);
            this.setSelectedFiles(null);
            return;
        }
        try {
            this.selectedTestSuite = TestSuite.open(file);
            super.approveSelection();
        }
        catch (FileNotFoundException e) {
            this.uif.showError("tsc.cantFindTestSuite", e.getMessage());
        }
        catch (TestSuite.Fault e) {
            this.uif.showError("tsc.unableToOpen", e.getMessage());
        }
    }

    private boolean isDirectory(File f) {
        return f.isDirectory();
    }

    private boolean isTestSuite(File f) {
        if (TestSuiteChooser.isIgnoreable(f)) {
            return false;
        }
        Boolean b = this.cache.get(f);
        if (b == null) {
            boolean v = TestSuite.isTestSuite(f);
            this.cache.put(f, v);
            return v;
        }
        return b;
    }

    private static boolean isIgnoreable(File f) {
        return f.getName().equals("");
    }

    private static File normalize(File dir) {
        for (File d = dir; d != null && !TestSuiteChooser.isIgnoreable(d); d = d.getParentFile()) {
            if (!TestSuite.isTestSuite(d)) continue;
            File p = d.getParentFile();
            return p != null ? p : dir;
        }
        return dir;
    }

    private class TSC_FileFilter
    extends FileFilter {
        private TSC_FileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return TestSuiteChooser.this.isDirectory(f) ? true : TestSuiteChooser.this.isTestSuite(f);
        }

        @Override
        public String getDescription() {
            return TestSuiteChooser.this.uif.getI18NString("tsc.ft");
        }
    }

    private class TSC_FileView
    extends FileView {
        private TSC_FileView() {
        }

        @Override
        public String getDescription(File f) {
            return null;
        }

        @Override
        public Icon getIcon(File f) {
            return TestSuiteChooser.this.isTestSuite(f) ? TestSuiteChooser.this.icon : null;
        }

        @Override
        public String getName(File f) {
            String name = f.getName();
            return name.length() == 0 ? f.getPath() : name;
        }

        @Override
        public String getTypeDescription(File f) {
            return null;
        }

        @Override
        public Boolean isTraversable(File f) {
            return TestSuiteChooser.this.isDirectory(f) && !TestSuiteChooser.this.isTestSuite(f) ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

