/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.Animal;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.Bar;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.BarServlet;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.Cat;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.Dog;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.Foo;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.FooServlet;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.MyBinding;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.MyInterceptor;
import org.jboss.cdi.tck.shrinkwrap.ee.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@RunAsClient
@SpecVersion(spec="interceptors", version="1.2")
public class InterceptorEnvironmentJNDISessionBeanTest
extends AbstractTest {
    private static final String GREETING = "greeting";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String HELLO = "Hello";
    private static final String BYE = "Bye";
    private static final String FOO_GET = "foo?get=";
    private static final String BAR_GET = "bar?get=";
    @ArquillianResource(value=FooServlet.class)
    URL fooContextPath;
    @ArquillianResource(value=BarServlet.class)
    URL barContextPath;

    @Deployment(testable=false)
    public static EnterpriseArchive createTestArchive() {
        EnterpriseArchive enterpriseArchive = (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().notTestArchive()).withClasses(new Class[]{MyBinding.class, MyInterceptor.class, Animal.class})).noDefaultWebModule().build();
        WebArchive fooArchive = (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withClasses(new Class[]{FooServlet.class, Foo.class, Dog.class})).withWebXml((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createEnvEntry().envEntryName(GREETING).envEntryType(JAVA_LANG_STRING).envEntryValue(BYE).up())).withDefaultEjbModuleDependency().build();
        enterpriseArchive.addAsModule((Archive)fooArchive);
        WebArchive barArchive = (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withClasses(new Class[]{BarServlet.class, Bar.class, Cat.class})).withWebXml((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createEnvEntry().envEntryName(GREETING).envEntryType(JAVA_LANG_STRING).envEntryValue(HELLO).up())).withDefaultEjbModuleDependency().build();
        enterpriseArchive.addAsModule((Archive)barArchive);
        return enterpriseArchive;
    }

    @Test(groups={"javaee-full"})
    @SpecAssertion(section="interceptor_environment", id="a")
    public void testInterceptorEnvironment() throws FailingHttpStatusCodeException, MalformedURLException, IOException {
        WebClient webClient = new WebClient();
        webClient.getPage(this.fooContextPath + FOO_GET + "init");
        String fooAnimalName = webClient.getPage(this.fooContextPath + FOO_GET + "name").getWebResponse().getContentAsString();
        String fooGreeting = webClient.getPage(this.fooContextPath + FOO_GET + GREETING).getWebResponse().getContentAsString();
        String fooInterceptorAnimalName = webClient.getPage(this.fooContextPath + FOO_GET + "intName").getWebResponse().getContentAsString();
        String fooInterceptorGreeting = webClient.getPage(this.fooContextPath + FOO_GET + "intGreeting").getWebResponse().getContentAsString();
        Assert.assertEquals((String)fooInterceptorAnimalName, (String)fooAnimalName);
        Assert.assertEquals((String)fooInterceptorGreeting, (String)fooGreeting);
        Assert.assertEquals((String)fooGreeting, (String)BYE);
        Assert.assertEquals((String)fooAnimalName, (String)"Dog");
        webClient.getPage(this.barContextPath + BAR_GET + "init");
        String barAnimalName = webClient.getPage(this.barContextPath + BAR_GET + "name").getWebResponse().getContentAsString();
        String barGreeting = webClient.getPage(this.barContextPath + BAR_GET + GREETING).getWebResponse().getContentAsString();
        String barInterceptorAnimalName = webClient.getPage(this.barContextPath + BAR_GET + "intName").getWebResponse().getContentAsString();
        String barInterceptorGreeting = webClient.getPage(this.barContextPath + BAR_GET + "intGreeting").getWebResponse().getContentAsString();
        Assert.assertEquals((String)barInterceptorAnimalName, (String)barAnimalName);
        Assert.assertEquals((String)barInterceptorGreeting, (String)barGreeting);
        Assert.assertEquals((String)barGreeting, (String)HELLO);
        Assert.assertEquals((String)barAnimalName, (String)"Cat");
    }
}

