/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.annotation.enventry;

import com.sun.ts.tests.ejb30.common.annotation.enventry.EnvEntryIF;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import jakarta.ejb.EJBContext;
import javax.naming.Context;
import javax.naming.NamingException;

public abstract class EnvEntryBeanBase
implements EnvEntryIF {
    protected abstract EJBContext getEJBContext();

    protected abstract String getString();

    protected abstract String getStringExpected();

    protected abstract String getStringName();

    protected abstract char getChar();

    protected abstract char getCharExpected();

    protected abstract String getCharName();

    protected abstract int getInt();

    protected abstract int getIntExpected();

    protected abstract String getIntName();

    protected abstract boolean getBoolean();

    protected abstract boolean getBooleanExpected();

    protected abstract String getBooleanName();

    protected abstract double getDouble();

    protected abstract double getDoubleExpected();

    protected abstract String getDoubleName();

    protected abstract byte getByte();

    protected abstract byte getByteExpected();

    protected abstract String getByteName();

    protected abstract short getShort();

    protected abstract short getShortExpected();

    protected abstract String getShortName();

    protected abstract long getLong();

    protected abstract long getLongExpected();

    protected abstract String getLongName();

    protected abstract float getFloat();

    protected abstract float getFloatExpected();

    protected abstract String getFloatName();

    protected abstract String getStringDeep();

    protected abstract String getStringDeepExpected();

    protected abstract String getStringDeepName();

    protected abstract char getCharDeep();

    protected abstract char getCharDeepExpected();

    protected abstract String getCharDeepName();

    protected abstract int getIntDeep();

    protected abstract int getIntDeepExpected();

    protected abstract String getIntDeepName();

    protected abstract boolean getBooleanDeep();

    protected abstract boolean getBooleanDeepExpected();

    protected abstract String getBooleanDeepName();

    protected abstract double getDoubleDeep();

    protected abstract double getDoubleDeepExpected();

    protected abstract String getDoubleDeepName();

    protected abstract byte getByteDeep();

    protected abstract byte getByteDeepExpected();

    protected abstract String getByteDeepName();

    protected abstract short getShortDeep();

    protected abstract short getShortDeepExpected();

    protected abstract String getShortDeepName();

    protected abstract long getLongDeep();

    protected abstract long getLongDeepExpected();

    protected abstract String getLongDeepName();

    protected abstract float getFloatDeep();

    protected abstract float getFloatDeepExpected();

    protected abstract String getFloatDeepName();

    @Override
    public void stringTest() throws TestFailedException {
        String expected = this.getStringExpected();
        String actual = this.getString();
        this.verify(expected, actual, "injected String env-entry");
        actual = null;
        actual = (String)this.getEJBContext().lookup(this.getStringName());
        this.verify(expected, actual, "EJBContext lookup of String env-entry " + this.getStringName());
        actual = null;
        try {
            actual = (String)ServiceLocator.lookup("java:comp/env/" + this.getStringName(), new Context[0]);
            this.verify(expected, actual, "Naming Context lookup of String env-entry " + this.getStringName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void charTest() throws TestFailedException {
        char expected = this.getCharExpected();
        char actual = this.getChar();
        this.verify(expected, actual, "injected char env-entry");
        Character big = (Character)this.getEJBContext().lookup(this.getCharName());
        actual = big.charValue();
        this.verify(expected, actual, "EJBContext lookup of char env-entry " + this.getCharName());
        try {
            big = (Character)ServiceLocator.lookup("java:comp/env/" + this.getCharName(), new Context[0]);
            actual = big.charValue();
            this.verify(expected, actual, "Naming Context lookup of char env-entry " + this.getCharName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void intTest() throws TestFailedException {
        int expected = this.getIntExpected();
        int actual = this.getInt();
        this.verify(expected, actual, "injected int env-entry");
        Integer big = (Integer)this.getEJBContext().lookup(this.getIntName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of int env-entry " + this.getIntName());
        try {
            big = (Integer)ServiceLocator.lookup("java:comp/env/" + this.getIntName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of int env-entry " + this.getIntName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void booleanTest() throws TestFailedException {
        boolean expected = this.getBooleanExpected();
        boolean actual = this.getBoolean();
        this.verify(expected, actual, "injected boolean env-entry");
        Boolean big = (Boolean)this.getEJBContext().lookup(this.getBooleanName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of boolean env-entry " + this.getBooleanName());
        try {
            big = (Boolean)ServiceLocator.lookup("java:comp/env/" + this.getBooleanName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of boolean env-entry " + this.getBooleanName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void doubleTest() throws TestFailedException {
        double expected = this.getDoubleExpected();
        double actual = this.getDouble();
        this.verify(expected, actual, "injected double env-entry");
        Double big = (Double)this.getEJBContext().lookup(this.getDoubleName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of double env-entry " + this.getDoubleName());
        try {
            big = (Double)ServiceLocator.lookup("java:comp/env/" + this.getDoubleName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of double env-entry " + this.getDoubleName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void byteTest() throws TestFailedException {
        byte expected = this.getByteExpected();
        byte actual = this.getByte();
        this.verify(expected, actual, "injected byte env-entry");
        Byte big = (Byte)this.getEJBContext().lookup(this.getByteName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of byte env-entry " + this.getByteName());
        try {
            big = (Byte)ServiceLocator.lookup("java:comp/env/" + this.getByteName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of byte env-entry " + this.getByteName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void shortTest() throws TestFailedException {
        short expected = this.getShortExpected();
        short actual = this.getShort();
        this.verify(expected, actual, "injected short env-entry");
        Short big = (Short)this.getEJBContext().lookup(this.getShortName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of short env-entry " + this.getShortName());
        try {
            big = (Short)ServiceLocator.lookup("java:comp/env/" + this.getShortName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of short env-entry " + this.getShortName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void longTest() throws TestFailedException {
        long expected = this.getLongExpected();
        long actual = this.getLong();
        this.verify(expected, actual, "injected long env-entry");
        Long big = (Long)this.getEJBContext().lookup(this.getLongName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of long env-entry " + this.getLongName());
        try {
            big = (Long)ServiceLocator.lookup("java:comp/env/" + this.getLongName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of long env-entry " + this.getLongName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void floatTest() throws TestFailedException {
        float expected = this.getFloatExpected();
        float actual = this.getFloat();
        this.verify(expected, actual, "injected float env-entry");
        Float big = (Float)this.getEJBContext().lookup(this.getFloatName());
        actual = big.floatValue();
        this.verify(expected, actual, "EJBContext lookup of float env-entry " + this.getFloatName());
        try {
            big = (Float)ServiceLocator.lookup("java:comp/env/" + this.getFloatName(), new Context[0]);
            actual = big.floatValue();
            this.verify(expected, actual, "Naming Context lookup of float env-entry " + this.getFloatName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void stringDeepTest() throws TestFailedException {
        String expected = this.getStringDeepExpected();
        String actual = this.getStringDeep();
        this.verify(expected, actual, "injected String env-entry with subcontexts");
        actual = null;
        actual = (String)this.getEJBContext().lookup(this.getStringDeepName());
        this.verify(expected, actual, "EJBContext lookup of String env-entry with subcontexts " + this.getStringDeepName());
        actual = null;
        try {
            actual = (String)ServiceLocator.lookup("java:comp/env/" + this.getStringDeepName(), new Context[0]);
            this.verify(expected, actual, "Naming Context lookup of String env-entry with subcontexts " + this.getStringDeepName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void charDeepTest() throws TestFailedException {
        char expected = this.getCharDeepExpected();
        char actual = this.getCharDeep();
        this.verify(expected, actual, "injected char env-entry with subcontexts");
        Character big = (Character)this.getEJBContext().lookup(this.getCharDeepName());
        actual = big.charValue();
        this.verify(expected, actual, "EJBContext lookup of char env-entry with subcontexts " + this.getCharDeepName());
        try {
            big = (Character)ServiceLocator.lookup("java:comp/env/" + this.getCharDeepName(), new Context[0]);
            actual = big.charValue();
            this.verify(expected, actual, "Naming Context lookup of char env-entry with subcontexts " + this.getCharDeepName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void intDeepTest() throws TestFailedException {
        int expected = this.getIntDeepExpected();
        int actual = this.getIntDeep();
        this.verify(expected, actual, "injected int env-entry with subcontexts");
        Integer big = (Integer)this.getEJBContext().lookup(this.getIntDeepName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of int env-entry with subcontexts " + this.getIntDeepName());
        try {
            big = (Integer)ServiceLocator.lookup("java:comp/env/" + this.getIntDeepName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of int env-entry with subcontexts " + this.getIntDeepName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void booleanDeepTest() throws TestFailedException {
        boolean expected = this.getBooleanDeepExpected();
        boolean actual = this.getBooleanDeep();
        this.verify(expected, actual, "injected boolean env-entry with subcontexts");
        Boolean big = (Boolean)this.getEJBContext().lookup(this.getBooleanDeepName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of boolean env-entry with subcontexts " + this.getBooleanDeepName());
        try {
            big = (Boolean)ServiceLocator.lookup("java:comp/env/" + this.getBooleanDeepName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of boolean env-entry with subcontexts " + this.getBooleanDeepName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void doubleDeepTest() throws TestFailedException {
        double expected = this.getDoubleDeepExpected();
        double actual = this.getDoubleDeep();
        this.verify(expected, actual, "injected double env-entry with subcontexts");
        Double big = (Double)this.getEJBContext().lookup(this.getDoubleDeepName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of double env-entry with subcontexts " + this.getDoubleDeepName());
        try {
            big = (Double)ServiceLocator.lookup("java:comp/env/" + this.getDoubleDeepName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of double env-entry with subcontexts " + this.getDoubleDeepName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void byteDeepTest() throws TestFailedException {
        byte expected = this.getByteDeepExpected();
        byte actual = this.getByteDeep();
        this.verify(expected, actual, "injected byte env-entry with subcontexts");
        Byte big = (Byte)this.getEJBContext().lookup(this.getByteDeepName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of byte env-entry with subcontexts " + this.getByteDeepName());
        try {
            big = (Byte)ServiceLocator.lookup("java:comp/env/" + this.getByteDeepName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of byte env-entry with subcontexts " + this.getByteDeepName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void shortDeepTest() throws TestFailedException {
        short expected = this.getShortDeepExpected();
        short actual = this.getShortDeep();
        this.verify(expected, actual, "injected short env-entry with subcontexts");
        Short big = (Short)this.getEJBContext().lookup(this.getShortDeepName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of short env-entry with subcontexts " + this.getShortDeepName());
        try {
            big = (Short)ServiceLocator.lookup("java:comp/env/" + this.getShortDeepName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of short env-entry with subcontexts " + this.getShortDeepName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void longDeepTest() throws TestFailedException {
        long expected = this.getLongDeepExpected();
        long actual = this.getLongDeep();
        this.verify(expected, actual, "injected long env-entry with subcontexts");
        Long big = (Long)this.getEJBContext().lookup(this.getLongDeepName());
        actual = big;
        this.verify(expected, actual, "EJBContext lookup of long env-entry with subcontexts " + this.getLongDeepName());
        try {
            big = (Long)ServiceLocator.lookup("java:comp/env/" + this.getLongDeepName(), new Context[0]);
            actual = big;
            this.verify(expected, actual, "Naming Context lookup of long env-entry with subcontexts " + this.getLongDeepName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void floatDeepTest() throws TestFailedException {
        float expected = this.getFloatDeepExpected();
        float actual = this.getFloatDeep();
        this.verify(expected, actual, "injected float env-entry with subcontexts");
        Float big = (Float)this.getEJBContext().lookup(this.getFloatDeepName());
        actual = big.floatValue();
        this.verify(expected, actual, "EJBContext lookup of float env-entry with subcontexts " + this.getFloatDeepName());
        try {
            big = (Float)ServiceLocator.lookup("java:comp/env/" + this.getFloatDeepName(), new Context[0]);
            actual = big.floatValue();
            this.verify(expected, actual, "Naming Context lookup of float env-entry with subcontexts " + this.getFloatDeepName());
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    protected void verify(String expected, String actual, String description) throws TestFailedException {
        if (!expected.equals(actual)) {
            if (description == null) {
                description = "Obtaiing env-entry of type java.lang.String ";
            }
            throw new TestFailedException(description + ": expected " + expected + ", actual " + actual + ". " + String.valueOf(this));
        }
    }

    protected void verify(char expected, char actual, String description) throws TestFailedException {
        if (expected != actual) {
            if (description == null) {
                description = "Obtaining env-entry of type char ";
            }
            throw new TestFailedException(description + ": expected " + expected + ", actual " + actual + ". " + String.valueOf(this));
        }
    }

    protected void verify(int expected, int actual, String description) throws TestFailedException {
        if (expected != actual) {
            if (description == null) {
                description = "Obtaining env-entry of type int ";
            }
            throw new TestFailedException(description + ": expected " + expected + ", actual " + actual + ". " + String.valueOf(this));
        }
    }

    protected void verify(boolean expected, boolean actual, String description) throws TestFailedException {
        if (expected != actual) {
            if (description == null) {
                description = "Obtaining env-entry of type boolean ";
            }
            throw new TestFailedException(description + ": expected " + expected + ", actual " + actual + ". " + String.valueOf(this));
        }
    }

    protected void verify(double expected, double actual, String description) throws TestFailedException {
        if (expected != actual) {
            if (description == null) {
                description = "Obtaining env-entry of type double ";
            }
            throw new TestFailedException(description + ": expected " + expected + ", actual " + actual + ". " + String.valueOf(this));
        }
    }

    protected void verify(byte expected, byte actual, String description) throws TestFailedException {
        if (expected != actual) {
            if (description == null) {
                description = "Obtaining env-entry of type byte ";
            }
            throw new TestFailedException(description + ": expected " + expected + ", actual " + actual + ". " + String.valueOf(this));
        }
    }

    protected void verify(short expected, short actual, String description) throws TestFailedException {
        if (expected != actual) {
            if (description == null) {
                description = "Obtaining env-entry of type short ";
            }
            throw new TestFailedException(description + ": expected " + expected + ", actual " + actual + ". " + String.valueOf(this));
        }
    }

    protected void verify(long expected, long actual, String description) throws TestFailedException {
        if (expected != actual) {
            if (description == null) {
                description = "Obtaining env-entry of type long ";
            }
            throw new TestFailedException(description + ": expected " + expected + ", actual " + actual + ". " + String.valueOf(this));
        }
    }

    protected void verify(float expected, float actual, String description) throws TestFailedException {
        if (expected != actual) {
            if (description == null) {
                description = "Obtaining env-entry of type float ";
            }
            throw new TestFailedException(description + ": expected " + expected + ", actual " + actual + ". " + String.valueOf(this));
        }
    }
}

