/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.helper;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ServiceLocator {
    private ServiceLocator() {
    }

    public static Object lookup(String name, Context ... context) throws NamingException {
        return ServiceLocator.lookup(name, (Class)null, context);
    }

    public static Object lookupNoTry(String name, Context ... context) {
        Object obj = null;
        try {
            obj = ServiceLocator.lookup(name, (Class)null, context);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(e);
        }
        return obj;
    }

    public static Object lookupByShortName(String shortName) throws NamingException {
        return ServiceLocator.lookup("java:comp/env/" + shortName, (Class)null, new Context[0]);
    }

    public static Object lookupByShortNameNoTry(String shortName) {
        Object obj = null;
        try {
            obj = ServiceLocator.lookup("java:comp/env/" + shortName, (Class)null, new Context[0]);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(e);
        }
        return obj;
    }

    public static Object lookup(Class type) throws NamingException {
        return ServiceLocator.lookup((String)null, type, new Context[0]);
    }

    public static Object lookup(String name, Class type, Context ... context) throws NamingException {
        String nameToUse = null;
        nameToUse = name == null ? type.getName() : name;
        Context c = null;
        c = context.length != 0 && context[0] != null ? context[0] : new InitialContext();
        return c.lookup(nameToUse);
    }

    public static void lookupShouldFail(String name, StringBuilder reason) {
        reason.append("\t").append(ServiceLocator.lookupShouldFail(name));
    }

    public static String lookupShouldFail(String name) {
        String result = null;
        try {
            InitialContext ic = new InitialContext();
            Object obj = ic.lookup(name);
            throw new RuntimeException("Expecting NamingException, but got " + String.valueOf(obj) + ", when looking up " + name);
        }
        catch (NamingException e) {
            result = "Got expected " + String.valueOf(e) + ", when looking up " + name;
            return result;
        }
    }
}

