/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.naming.context;

import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public final class Test {
    public static final String NOT_ALLOWED_TO_MODIFY_ENV = "Application component instances are not allowed to modify the environment at runtime";

    private Test() {
    }

    public static InitialContext initialContext() throws NamingException {
        return new InitialContext();
    }

    public static Context javaCompContext() throws NamingException {
        return (Context)InitialContext.doLookup("java:comp");
    }

    public static Context javaCompEnvContext() throws NamingException {
        return (Context)InitialContext.doLookup("java:comp/env");
    }

    public static Context javaModuleContext() throws NamingException {
        return (Context)InitialContext.doLookup("java:module");
    }

    public static Context javaModuleEnvContext() throws NamingException {
        return (Context)InitialContext.doLookup("java:module/env");
    }

    public static Context javaAppContext() throws NamingException {
        return (Context)InitialContext.doLookup("java:app");
    }

    public static Context javaAppEnvContext() throws NamingException {
        return (Context)InitialContext.doLookup("java:app/env");
    }

    public static Context[] java3Contexts(boolean ... excludeAppEnvs) throws NamingException {
        boolean excludeAppEnv;
        boolean bl = excludeAppEnv = excludeAppEnvs.length == 0 ? false : excludeAppEnvs[0];
        if (excludeAppEnv) {
            return new Context[]{Test.javaCompContext(), Test.javaModuleContext(), Test.javaModuleEnvContext(), Test.javaAppContext()};
        }
        return new Context[]{Test.javaCompContext(), Test.javaModuleContext(), Test.javaModuleEnvContext(), Test.javaAppContext(), Test.javaAppEnvContext()};
    }

    public static Context[] envContexts(boolean ... excludeAppEnvs) throws NamingException {
        boolean excludeAppEnv;
        boolean bl = excludeAppEnv = excludeAppEnvs.length == 0 ? false : excludeAppEnvs[0];
        if (excludeAppEnv) {
            return new Context[]{Test.javaModuleEnvContext()};
        }
        return new Context[]{Test.javaModuleEnvContext(), Test.javaAppEnvContext()};
    }

    public static Context[] nonEnvContexts() throws NamingException {
        return new Context[]{Test.javaCompContext(), Test.javaModuleContext(), Test.javaAppContext()};
    }

    public static Context[] initialAndJava3Contexts(boolean ... excludeAppEnvs) throws NamingException {
        boolean excludeAppEnv;
        boolean bl = excludeAppEnv = excludeAppEnvs.length == 0 ? false : excludeAppEnvs[0];
        if (excludeAppEnv) {
            return new Context[]{Test.initialContext(), Test.javaCompContext(), Test.javaModuleContext(), Test.javaModuleEnvContext(), Test.javaAppContext()};
        }
        return new Context[]{Test.initialContext(), Test.javaCompContext(), Test.javaModuleContext(), Test.javaModuleEnvContext(), Test.javaAppContext(), Test.javaAppEnvContext()};
    }

    public static Object lookupInContextOrNull(Context context, String name) {
        try {
            return context.lookup(name);
        }
        catch (NamingException e) {
            return null;
        }
    }

    public static String getEnvironment(Context ... contexts) throws TestFailedException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : contexts) {
            pw.println("Context under test: " + String.valueOf(context));
            try {
                Hashtable<?, ?> environment = context.getEnvironment();
                if (environment == null) {
                    pw.println("Expecting not null from getEnvironment, but got null.");
                    throw new TestFailedException(sw.toString());
                }
                pw.println("Got the expected result from getEnvironment: " + String.valueOf(environment));
            }
            catch (TestFailedException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new TestFailedException(sw.toString(), e);
            }
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bind(Context ... contexts) throws TestFailedException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : contexts) {
            pw.println("Context under test: " + String.valueOf(context));
            String newEntryName = "newName";
            String newEntryValue = "newValue";
            try {
                context.bind(newEntryName, (Object)newEntryValue);
                Object obj = Test.lookupInContextOrNull(context, newEntryName);
                if (obj != null) {
                    pw.println("Expecting not exist, but got " + String.valueOf(obj) + ", from looking up " + newEntryName);
                    throw new TestFailedException(sw.toString());
                }
                pw.println("Got the expected result: not exist.");
            }
            catch (TestFailedException e) {
                throw e;
            }
            catch (Throwable e) {
                pw.println("Got the expected exception: " + String.valueOf(e));
            }
            finally {
                try {
                    context.unbind(newEntryName);
                }
                catch (Exception exception) {}
            }
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String rebind(Context ... contexts) throws TestFailedException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : contexts) {
            pw.println("Context under test: " + String.valueOf(context));
            String newEntryName = "newName";
            String newEntryValue = "newValue";
            try {
                context.rebind(newEntryName, (Object)newEntryValue);
                Object obj = Test.lookupInContextOrNull(context, newEntryName);
                if (obj != null) {
                    pw.println("Expecting not exist, but got " + String.valueOf(obj) + ", from looking up " + newEntryName);
                    throw new TestFailedException(sw.toString());
                }
                pw.println("Got the expected result: not exist.");
            }
            catch (TestFailedException e) {
                throw e;
            }
            catch (Throwable e) {
                pw.println("Got the expected exception: " + String.valueOf(e));
            }
            finally {
                try {
                    context.unbind(newEntryName);
                }
                catch (Exception exception) {}
            }
        }
        return sw.toString();
    }

    public static String unbind(Context ... contexts) throws TestFailedException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : contexts) {
            pw.println("Context under test: " + String.valueOf(context));
            try {
                String entryName = "name";
                context.unbind(entryName);
                Object obj = Test.lookupInContextOrNull(context, entryName);
                if (obj == null) {
                    pw.println("Expecting still exist, but got null from looking up " + entryName);
                    throw new TestFailedException(sw.toString());
                }
                pw.println("Got the expected result: entry not unbound: " + String.valueOf(obj));
            }
            catch (TestFailedException e) {
                throw e;
            }
            catch (Throwable e) {
                pw.println("Got the expected exception: " + String.valueOf(e));
            }
        }
        return sw.toString();
    }

    public static String rename(Context ... contexts) throws TestFailedException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : contexts) {
            pw.println("Context under test: " + String.valueOf(context));
            try {
                String entryName = "name";
                String renameTo = "renameTo";
                context.rename(entryName, renameTo);
                Object obj = Test.lookupInContextOrNull(context, entryName);
                if (obj == null) {
                    pw.println("Expecting still exist, but got null from looking up " + entryName);
                    throw new TestFailedException(sw.toString());
                }
                pw.println("Got the expected result: entry not renamed: " + String.valueOf(obj));
                obj = Test.lookupInContextOrNull(context, renameTo);
                if (obj != null) {
                    pw.println("Expecting renameTo not exist, but got " + String.valueOf(obj));
                    throw new TestFailedException(sw.toString());
                }
                pw.println("Got the expected result: renameTo not exist.");
            }
            catch (TestFailedException e) {
                throw e;
            }
            catch (Throwable e) {
                pw.println("Got the expected exception: " + String.valueOf(e));
            }
        }
        return sw.toString();
    }

    public static String close(Context ... contexts) throws TestFailedException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : contexts) {
            pw.println("Context under test: " + String.valueOf(context));
            try {
                for (int i = 0; i < 3; ++i) {
                    context.close();
                    pw.println("Context closed successfully.");
                }
            }
            catch (Throwable e) {
                throw new TestFailedException(sw.toString(), e);
            }
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createSubcontext(Context ... contexts) throws TestFailedException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : contexts) {
            pw.println("Context under test: " + String.valueOf(context));
            String newEntryName = "newName";
            try {
                context.createSubcontext(newEntryName);
                Object obj = Test.lookupInContextOrNull(context, newEntryName);
                if (obj != null) {
                    pw.println("Expecting not exist, but got " + String.valueOf(obj) + ", from looking up " + newEntryName);
                    throw new TestFailedException(sw.toString());
                }
                pw.println("Got the expected result: not exist.");
            }
            catch (TestFailedException e) {
                throw e;
            }
            catch (Throwable e) {
                pw.println("Got the expected exception: " + String.valueOf(e));
            }
            finally {
                try {
                    context.destroySubcontext(newEntryName);
                }
                catch (Exception exception) {}
            }
        }
        return sw.toString();
    }

    public static String destroySubcontext(Context ... contexts) throws TestFailedException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : contexts) {
            pw.println("Context under test: " + String.valueOf(context));
            try {
                String entryName = "sub";
                context.destroySubcontext(entryName);
                Object obj = Test.lookupInContextOrNull(context, entryName);
                if (obj == null) {
                    pw.println("Expecting still exist, but got null from looking up " + entryName);
                    throw new TestFailedException(sw.toString());
                }
                pw.println("Got the expected result: entry not unbound: " + String.valueOf(obj));
            }
            catch (TestFailedException e) {
                throw e;
            }
            catch (Throwable e) {
                pw.println("Got the expected exception: " + String.valueOf(e));
            }
        }
        return sw.toString();
    }

    public static String lookup(Map<Context, String> context2LookupResult) throws TestFailedException, NamingException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : context2LookupResult.keySet()) {
            pw.println("Context under test: " + String.valueOf(context));
            String entryName = "name";
            Object obj = context.lookup(entryName);
            String expected = context2LookupResult.get(context);
            if (!expected.equals(obj)) {
                pw.println("Expecting " + expected + " from lookup " + entryName + ", but got " + String.valueOf(obj));
                throw new TestFailedException(sw.toString());
            }
            pw.println("Got the expected result " + expected + " from lookup: " + entryName);
        }
        return sw.toString();
    }

    public static String list(Context ... contexts) throws TestFailedException, NamingException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : contexts) {
            pw.println("Context under test: " + String.valueOf(context));
            NamingEnumeration<NameClassPair> list = context.list("");
            int count = 0;
            int expectedCount = 2;
            while (list.hasMoreElements()) {
                ++count;
                pw.println("NameClassPair: " + String.valueOf(list.nextElement()));
            }
            if (count != expectedCount) {
                pw.println("Expecting # of NameClassPair: " + expectedCount + ", but actual " + count);
                throw new TestFailedException(sw.toString());
            }
            pw.println("Got the expected NameClassPair.");
        }
        return sw.toString();
    }

    public static String listBindings(Context ... contexts) throws TestFailedException, NamingException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Context context : contexts) {
            pw.println("Context under test: " + String.valueOf(context));
            NamingEnumeration<Binding> list = context.listBindings("");
            int count = 0;
            int expectedCount = 2;
            while (list.hasMoreElements()) {
                ++count;
                pw.println("Binding: " + String.valueOf(list.nextElement()));
            }
            if (count != expectedCount) {
                pw.println("Expecting # of Binding: " + expectedCount + ", but actual " + count);
                throw new TestFailedException(sw.toString());
            }
            pw.println("Got the expected Binding.");
        }
        return sw.toString();
    }
}

