/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.packaging.war.enventry;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.packaging.war.enventry.InterceptorBase;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBContext;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.util.List;

public class Interceptor3
extends InterceptorBase {
    @Resource
    private EJBContext ejbContext;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.OneBean/myFloat", description="declared in ejb-jar.xml#OneBean")
    private float myFloatFromOne;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.TwoBean/myFloat", description="declared in ejb-jar.xml#TwoBean")
    private float myFloatFromTwo;
    @Resource(lookup="java:comp/env/com.sun.ts.tests.ejb30.lite.packaging.war.enventry.ThreeBean/myFloat", description="declared in ejb-jar.xml#ThreeBean")
    private float myFloatFromThree;
    private boolean injectionStatusAndRecordsVerified;

    private void verifySuperAndSelf() throws RuntimeException {
        if (!this.injectionStatusAndRecordsVerified) {
            this.verifyInterceptorBase();
            this.checkInjections(1);
            this.injectionStatusAndRecordsVerified = true;
        }
    }

    @Override
    protected final void verify(StringBuilder sb) throws RuntimeException {
        Helper.assertNotEquals("Check injected EJBContext ", this.ejbContext, null);
        Helper.assertEquals("Check myFloatFromOne ", Float.valueOf(1.0f), Float.valueOf(this.myFloatFromOne), sb);
        Helper.assertEquals("Check myFloatFromTwo ", Float.valueOf(2.0f), Float.valueOf(this.myFloatFromTwo), sb);
        Helper.assertEquals("Check myFloatFromThree ", Float.valueOf(3.0f), Float.valueOf(this.myFloatFromThree), sb);
    }

    @AroundInvoke
    private Object intercept(InvocationContext inv) throws Exception {
        String methodName = inv.getMethod().getName();
        Object[] params = inv.getParameters();
        if (methodName.equals("getInjectionStatusForInterceptors")) {
            this.verifySuperAndSelf();
            Object param = params[0];
            List sta = (List)param;
            sta.add(this.getInjectionStatus());
        } else if (methodName.equals("getInjectionRecordsForInterceptors")) {
            this.verifySuperAndSelf();
            Object param = params[0];
            List rec = (List)param;
            rec.add(this.getInjectionRecords());
        } else {
            String s = "This interceptor should be triggered only for getInjectionRecords and getInjectionStatus methods, but current method is " + methodName + ", current interceptor is " + String.valueOf(this);
            this.setInjectionStatusAndRecord(false, s, new Throwable[0]);
            throw new IllegalStateException(s);
        }
        return inv.proceed();
    }
}

