/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.tx.cm.stateful.rw;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeEJBLite;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeUtil;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.RWTxBeanBase;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.ejb.AfterBegin;
import jakarta.ejb.AfterCompletion;
import jakarta.ejb.BeforeCompletion;
import jakarta.ejb.Stateful;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import java.util.logging.Level;

@Stateful
public class TxBean
extends RWTxBeanBase {
    public static final String AFTER_BEGIN = "afterBegin";
    public static final String BEFORE_COMPLETION = "beforeCompletion";
    public static final String AFTER_COMPLETION = "afterCompletion";
    public static final int AFTER_BEGIN_COFFEE_ID = 1602;
    public static final int BEFORE_COMPLETION_COFFEE_ID = 2503;
    public static final int AFTER_COMPLETION_COFFEE_ID = 1603;

    @AfterBegin
    public void afterBegin() {
        CoffeeUtil.findDeletePersist(1602, AFTER_BEGIN, this.em);
    }

    @BeforeCompletion
    public void beforeCompletion() {
        CoffeeUtil.verifyCoffee(1602, AFTER_BEGIN, this.em, true);
        CoffeeUtil.findDeletePersist(2503, BEFORE_COMPLETION, this.em);
        CoffeeUtil.verifyCoffee(2503, BEFORE_COMPLETION, this.em, true);
    }

    @AfterCompletion
    public void afterCompletion(boolean arg0) {
    }

    @PostConstruct
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void postConstruct() {
        int id = 9582176;
        String brandName = "postConstruct";
        float price = id;
        CoffeeUtil.findDelete(id, false, this.em);
        this.postConstructCoffee = new CoffeeEJBLite(id, brandName, price);
        this.updatePersist(this.postConstructCoffee, false);
        Helper.getLogger().logp(Level.FINE, "TxBean", "postConstruct", "Updated and persisted coffee: " + String.valueOf(this.postConstructCoffee));
    }

    @PreDestroy
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void preDestroy() {
        if (System.getProperty("ejbembed", null) == null) {
            Helper.getLogger().logp(Level.FINE, "TxBean", "preDestroy", "About to merge and remove: " + String.valueOf(this.postConstructCoffee));
            this.em.remove(this.em.merge((Object)this.postConstructCoffee));
            this.em.getEntityManagerFactory().getCache().evictAll();
        }
    }
}

