/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.basic.concurrency;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import com.sun.ts.tests.ejb32.lite.timer.basic.concurrency.TimerIF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.ejb.AccessTimeout;
import jakarta.ejb.AsyncResult;
import jakarta.ejb.Asynchronous;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.ConcurrencyManagementType;
import jakarta.ejb.Lock;
import jakarta.ejb.LockType;
import jakarta.ejb.NoMoreTimeoutsException;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerService;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;

@TransactionManagement(value=TransactionManagementType.BEAN)
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class LockSingletonTimerBeanBase
implements TimerIF {
    private static final String KEY_TIMER_SERVICE_FROM_GLOBAL_LOOKUP = "KEY_TIMER_SERVICE_FROM_GLOBAL_LOOKUP";
    private static final String KEY_TIMER_SERVICE_FROM_COMPONENT_LOOKUP = "KEY_TIMER_SERVICE_FROM_COMPONENT_LOOKUP";
    private static final String KEY_TIMER_SERVICE_SESSION_CONTEXT = "KEY_TIMER_SERVICE_SESSION_CONTEXT";
    protected int increment;
    protected int sum;
    @Resource(name="timerService")
    protected TimerService timerService;
    private Map<String, TimerService> postConstructTimerServices = new HashMap<String, TimerService>();
    private Map<String, TimerService> preDestroyTimerServices = new HashMap<String, TimerService>();
    private Map<String, TimerService> asyncMethodTimerServices = new HashMap<String, TimerService>();

    @PostConstruct
    private void postConstruct() {
        this.lookupTimerService(this.postConstructTimerServices);
    }

    @PreDestroy
    private void preDestroy() {
        this.lookupTimerService(this.preDestroyTimerServices);
        Helper.getLogger().info("TimerService lookup results in preDestroy: " + String.valueOf(this.preDestroyTimerServices));
    }

    @Timeout
    protected void timeout(Timer timer) {
        Helper.getLogger().finer("Timeout method for timer: " + String.valueOf(timer.getInfo()) + ". sum=" + this.sum + ", increment=" + this.increment);
        this.busyAdd0();
    }

    @Override
    @Lock(value=LockType.READ)
    @Asynchronous
    @AccessTimeout(unit=TimeUnit.NANOSECONDS, value=9000000000L)
    public void readLockBusyAdd() {
        this.busyAdd0();
    }

    @Override
    public int getAndResetResult() {
        int result = this.sum;
        this.sum = 0;
        Helper.getLogger().fine("getAndResetSum about to return " + result);
        return result;
    }

    @Override
    @Lock(value=LockType.READ)
    public boolean isResultComplete(int expected) {
        return this.sum == expected;
    }

    @Override
    public void resetResult() {
        this.sum = 0;
    }

    @Override
    @Lock(value=LockType.READ)
    public void setIncrement(int i) {
        this.increment = i;
    }

    @Override
    @Asynchronous
    @AccessTimeout(unit=TimeUnit.MINUTES, value=10L)
    @Lock(value=LockType.READ)
    public Future<Timer> createTimer(String name, Date d) {
        Timer timer = this.timerService.createSingleActionTimer(d, new TimerConfig((Serializable)new TimerInfo(name), false));
        return new AsyncResult((Object)timer);
    }

    @Override
    @Lock(value=LockType.READ)
    public void cancelAllTimers() {
        TimerUtil.cancelAllTimers((TimerService)this.timerService, (boolean)false);
    }

    @Override
    public Future<String> lookupTimerService() {
        this.asyncMethodTimerServices.clear();
        this.lookupTimerService(this.asyncMethodTimerServices);
        return new AsyncResult((Object)("postConstructTimerServices :" + String.valueOf(this.postConstructTimerServices) + ", asyncMethodTimerServices: " + String.valueOf(this.asyncMethodTimerServices)));
    }

    private void busyAdd0() {
        for (int i = 0; i < this.increment; ++i) {
            ++this.sum;
        }
    }

    private void lookupTimerService(Map<String, TimerService> timerServiceMap) {
        timerServiceMap.put(KEY_TIMER_SERVICE_FROM_GLOBAL_LOOKUP, (TimerService)ServiceLocator.lookupNoTry((String)"java:comp/TimerService", (Context[])new Context[0]));
        SessionContext sessionContext = (SessionContext)ServiceLocator.lookupNoTry((String)"java:comp/EJBContext", (Context[])new Context[0]);
        timerServiceMap.put(KEY_TIMER_SERVICE_FROM_COMPONENT_LOOKUP, (TimerService)sessionContext.lookup("timerService"));
        timerServiceMap.put(KEY_TIMER_SERVICE_SESSION_CONTEXT, sessionContext.getTimerService());
        for (String key : timerServiceMap.keySet()) {
            Helper.getLogger().fine("About to getTimers from TimerService " + key);
            TimerService ts = timerServiceMap.get(key);
            TimerUtil.createSecondLaterTimer((TimerService)ts, (TimerConfig)new TimerConfig(null, false));
            for (Object o : ts.getTimers()) {
                Timer t = (Timer)o;
                if (t.isPersistent()) {
                    t.getHandle();
                }
                t.getInfo();
                try {
                    t.getNextTimeout();
                }
                catch (NoMoreTimeoutsException noMoreTimeoutsException) {
                    // empty catch block
                }
                if (t.isCalendarTimer()) {
                    t.getSchedule();
                }
                try {
                    t.getTimeRemaining();
                }
                catch (NoMoreTimeoutsException noMoreTimeoutsException) {
                    // empty catch block
                }
                try {
                    t.cancel();
                }
                catch (NoSuchObjectLocalException noSuchObjectLocalException) {}
            }
        }
    }
}

