/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.setattribute;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.setattribute.A;
import ee.jakarta.tck.persistence.core.metamodelapi.setattribute.Address;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getSet() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(A.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                SetAttribute setAttrib = mType.getSet("address", Address.class);
                Type t = setAttrib.getElementType();
                if (t != null) {
                    this.logTrace("element Java Type  = " + String.valueOf(t.getJavaType()));
                    if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.setattribute.Address")) {
                        pass = true;
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSet Test  failed");
        }
    }

    public void getCollectionType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(A.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                SetAttribute setAttrib = mType.getSet("address", Address.class);
                PluralAttribute.CollectionType setAttribColType = setAttrib.getCollectionType();
                this.logTrace("collection Type = " + String.valueOf(setAttrib.getCollectionType()));
                if (setAttribColType == PluralAttribute.CollectionType.SET) {
                    this.logTrace("Received expected result = " + String.valueOf(setAttribColType));
                    pass = true;
                } else {
                    this.logErr("Received unexpected result = " + String.valueOf(setAttribColType));
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionType Test  failed");
        }
    }

    public void getElementType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(A.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                SetAttribute setAttrib = mType.getSet("address", Address.class);
                this.logTrace("collection Element Type = " + setAttrib.getElementType().getJavaType().getName());
                String elementTypeName = setAttrib.getElementType().getJavaType().getName();
                if (elementTypeName.equals("ee.jakarta.tck.persistence.core.metamodelapi.setattribute.Address")) {
                    this.logTrace("Received expected result = " + elementTypeName);
                    pass = true;
                } else {
                    this.logErr("Received unexpected result = " + elementTypeName);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getElementType Test  failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

