/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.errors;

import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.errors.Chain;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.errors.MessageType;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.PatternSyntaxException;

public abstract class Handler {
    private Handler next;
    private Level level = Level.SEVERE;
    protected static final ArrayList EMPTY_ARRAY_LIST = new ArrayList();

    public Handler setNext(Handler h) {
        this.next = h;
        return this;
    }

    void process(List l, Chain ch) {
        if (this.acceptMessageList(l)) {
            this.writeMessage(l, ch);
        }
        if (this.next != null) {
            this.next.process(l, ch);
        }
    }

    boolean acceptMessageList(List l) {
        if (l.size() < 2) {
            return false;
        }
        ErrorFormatter.Message e1 = (ErrorFormatter.Message)l.get(0);
        ErrorFormatter.Message e2 = (ErrorFormatter.Message)l.get(1);
        return !this.isAnnotationMessage(e1) && !this.isAnnotationMessage(e2);
    }

    protected abstract void writeMessage(List var1, Chain var2);

    boolean isAnnotationMessage(ErrorFormatter.Message m) {
        return m.messageType == MessageType.ADD_ANNO || m.messageType == MessageType.MISS_ANNO;
    }

    protected static ArrayList stringToArrayList(String source, String delimiter) {
        String[] strA;
        if (source == null || source.length() == 0) {
            return EMPTY_ARRAY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            strA = source.split(delimiter);
        }
        catch (PatternSyntaxException e) {
            result.add(source);
            return result;
        }
        for (int i = 0; i < strA.length; ++i) {
            result.add(strA[i]);
        }
        return result;
    }

    protected boolean canBeSubclassed(String className, ClassHierarchy clHier) {
        try {
            ClassDescription cd = clHier.load(className);
            return SwissKnife.canBeSubclassed(cd);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected boolean isAssignableTo(String origType, String newType, ClassHierarchy clHier) {
        if (origType.equals(newType)) {
            return true;
        }
        try {
            ClassDescription cd = clHier.load(newType);
            SuperInterface[] ints = cd.getInterfaces();
            for (int i = 0; i < ints.length; ++i) {
                if (!origType.equals(ints[i].getQualifiedName())) continue;
                return true;
            }
            return clHier.isSubclass(newType, origType);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected Level getLevel() {
        return this.level;
    }

    protected void setLevel(Level level) {
        this.level = level;
    }

    protected void setMessageLevel(ErrorFormatter.Message m) {
        m.setLevel(this.level);
    }
}

