/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.util.AppException;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.util.TSMessageListenerInterface;
import com.sun.ts.tests.common.connector.whitebox.LocalTxMessageXAResource;
import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.transaction.xa.XAResource;

public class LocalTxMessageWork1
implements Work {
    private String name;
    private boolean stop = false;
    private MessageEndpointFactory factory;
    private LocalTxMessageXAResource msgxa = new LocalTxMessageXAResource("LocalTxMessageXAResource1");
    private MessageEndpoint xaep;
    private MessageEndpoint ep2;

    public LocalTxMessageWork1(String name, MessageEndpointFactory factory) {
        this.factory = factory;
        this.name = name;
        System.out.println("LocalTxMessageWork1.constructor");
    }

    public void run() {
        while (!this.stop) {
            try {
                System.out.println("Inside the LocalTxMessageWork1 run ");
                this.xaep = this.factory.createEndpoint((XAResource)this.msgxa);
                this.ep2 = this.factory.createEndpoint(null);
                Method onMessagexa = this.getOnMessageMethod();
                this.xaep.beforeDelivery(onMessagexa);
                ((TSMessageListenerInterface)this.xaep).onMessage("LocalTx MDB2 Transacted Message To MDB");
                this.xaep.afterDelivery();
                ConnectorStatus.getConnectorStatus().logState("LocalTx MDB2 Transacted Message To MDB");
                this.callSysExp();
                this.callAppExp();
                System.out.println("LocalTx MDB2 Transacted Message To MDB");
                boolean de = this.factory.isDeliveryTransacted(onMessagexa);
                if (!de) break;
                ConnectorStatus.getConnectorStatus().logState("LocalTx MDB2 delivery is transacted");
                System.out.println("LocalTx MDB2 delivery is transacted");
                break;
            }
            catch (AppException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (UnavailableException ex) {
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (ResourceException re) {
                re.printStackTrace();
            }
        }
    }

    public void callSysExp() {
        try {
            Method onMessage = this.getOnMessageMethod();
            this.ep2.beforeDelivery(onMessage);
            ((TSMessageListenerInterface)this.ep2).onMessage("Throw EJBException from Required");
        }
        catch (NoSuchMethodException e) {
            System.out.println("LocalTxMessageWork1: NoSuchMethodException");
            e.getMessage();
            e.printStackTrace();
        }
        catch (UnavailableException e) {
            System.out.println("LocalTxMessageWork1: UnavailableException");
            e.printStackTrace();
        }
        catch (ResourceException re) {
            System.out.println("LocalTxMessageWork1: ResourceException");
            re.printStackTrace();
        }
        catch (AppException ae) {
            System.out.println("LocalTxMessageWork1: AppException");
            ae.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("EJBException thrown by Required");
            ConnectorStatus.getConnectorStatus().logState("EJBException thrown by Required");
            e.printStackTrace();
        }
        finally {
            try {
                this.ep2.afterDelivery();
            }
            catch (ResourceException re2) {
                re2.printStackTrace();
            }
        }
    }

    public void callAppExp() {
        try {
            Method onMessage = this.getOnMessageMethod();
            this.ep2.beforeDelivery(onMessage);
            ((TSMessageListenerInterface)this.ep2).onMessage("Throw AppException from Required");
        }
        catch (AppException ejbe) {
            System.out.println("AppException thrown by Required MDB");
            ConnectorStatus.getConnectorStatus().logState("AppException thrown by Required");
        }
        catch (NoSuchMethodException ns) {
            ns.printStackTrace();
        }
        catch (ResourceException re) {
            re.printStackTrace();
        }
        finally {
            try {
                this.ep2.afterDelivery();
            }
            catch (ResourceException re2) {
                re2.printStackTrace();
            }
        }
    }

    public Method getOnMessageMethod() {
        Method onMessageMethod = null;
        try {
            Class<TSMessageListenerInterface> msgListenerClass = TSMessageListenerInterface.class;
            Class[] paramTypes = new Class[]{String.class};
            onMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return onMessageMethod;
    }

    public void release() {
    }

    public void stop() {
        this.stop = true;
    }

    public String toString() {
        return this.name;
    }
}

