/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class CE_ExecutionPane
extends CE_StdPane {
    private Parameters.ConcurrencyParameters concurrencyParameters;
    private Parameters.MutableConcurrencyParameters mutableConcurrencyParameters;
    private JLabel concurrencyLabel;
    private JTextField concurrencyField;
    private Parameters.TimeoutFactorParameters timeoutFactorParameters;
    private Parameters.MutableTimeoutFactorParameters mutableTimeoutFactorParameters;
    private JLabel timeoutFactorLabel;
    private JTextField timeoutFactorField;

    CE_ExecutionPane(UIFactory uif, InterviewParameters config) {
        super(uif, config, "exec");
        this.updateConfig();
        this.initGUI();
    }

    @Override
    boolean isOKToClose() {
        ParsePosition pos;
        ParsePosition pos2;
        if (this.mutableConcurrencyParameters == null && this.mutableTimeoutFactorParameters == null) {
            return true;
        }
        String cs = this.concurrencyField.getText();
        if (cs == null || cs.length() == 0) {
            this.uif.showError("ce.exec.noConcurrency");
            return false;
        }
        NumberFormat fmt = NumberFormat.getIntegerInstance();
        Number num = fmt.parse(cs, pos2 = new ParsePosition(0));
        if (num != null && pos2.getIndex() == cs.length()) {
            int c = num.intValue();
            if (c < 1 || c > 256) {
                this.uif.showError("ce.exec.badRangeConcurrency", new Object[]{new Integer(1), new Integer(256)});
                return false;
            }
        } else {
            this.uif.showError("ce.exec.badConcurrency");
            return false;
        }
        String ts = this.timeoutFactorField.getText();
        if (ts == null || ts.length() == 0) {
            this.uif.showError("ce.exec.noTimeoutFactor");
            return false;
        }
        NumberFormat fmt2 = NumberFormat.getNumberInstance();
        Number num2 = fmt2.parse(ts, pos = new ParsePosition(0));
        if (num2 != null && pos.getIndex() == ts.length()) {
            float t = num2.floatValue();
            if (t < 0.1f || t > 100.0f) {
                this.uif.showError("ce.exec.badRangeTimeoutFactor", new Object[]{new Float(0.1f), new Float(100.0f)});
                return false;
            }
        } else {
            this.uif.showError("ce.exec.badTimeoutFactor");
            return false;
        }
        return true;
    }

    @Override
    void load() {
        this.updateConfig();
        this.concurrencyField.setText(String.valueOf(this.config.getConcurrency()));
        this.concurrencyField.setEnabled(this.mutableConcurrencyParameters != null);
        NumberFormat fmt = NumberFormat.getNumberInstance();
        this.timeoutFactorField.setText(fmt.format(new Double(this.config.getTimeoutFactor())));
        this.timeoutFactorField.setEnabled(this.mutableTimeoutFactorParameters != null);
    }

    void updateConfig() {
        this.concurrencyParameters = this.config.getConcurrencyParameters();
        this.mutableConcurrencyParameters = this.concurrencyParameters instanceof Parameters.MutableConcurrencyParameters ? (Parameters.MutableConcurrencyParameters)this.concurrencyParameters : null;
        this.timeoutFactorParameters = this.config.getTimeoutFactorParameters();
        this.mutableTimeoutFactorParameters = this.timeoutFactorParameters instanceof Parameters.MutableTimeoutFactorParameters ? (Parameters.MutableTimeoutFactorParameters)this.timeoutFactorParameters : null;
    }

    @Override
    void save() {
        if (this.mutableConcurrencyParameters != null) {
            int c = this.getInt(this.concurrencyField.getText(), 1);
            this.mutableConcurrencyParameters.setConcurrency(c);
        }
        if (this.mutableTimeoutFactorParameters != null) {
            float t = this.getFloat(this.timeoutFactorField.getText(), 1.0f);
            this.mutableTimeoutFactorParameters.setTimeoutFactor(t);
        }
    }

    private void initGUI() {
        ContextHelpManager.setHelpIDString(this, "confEdit.execTab.csh");
        JPanel p = this.uif.createPanel("ce.exec", new GridBagLayout(), false);
        GridBagConstraints lc = new GridBagConstraints();
        lc.anchor = 13;
        lc.gridwidth = 1;
        lc.insets.right = 5;
        lc.weightx = 0.0;
        GridBagConstraints fc = new GridBagConstraints();
        fc.anchor = 17;
        fc.gridwidth = 0;
        this.concurrencyLabel = this.uif.createLabel("ce.exec.concurrency", true);
        p.add((Component)this.concurrencyLabel, lc);
        this.concurrencyField = this.uif.createInputField("ce.exec.concurrency", 5);
        this.concurrencyField.setEnabled(this.mutableConcurrencyParameters != null);
        this.concurrencyLabel.setLabelFor(this.concurrencyField);
        p.add((Component)this.concurrencyField, fc);
        this.timeoutFactorLabel = this.uif.createLabel("ce.exec.timeoutFactor", true);
        p.add((Component)this.timeoutFactorLabel, lc);
        this.timeoutFactorField = this.uif.createInputField("ce.exec.timeoutFactor", 5);
        this.timeoutFactorField.setEnabled(this.mutableTimeoutFactorParameters != null);
        this.timeoutFactorLabel.setLabelFor(this.timeoutFactorField);
        p.add((Component)this.timeoutFactorField, fc);
        this.addBody(p);
    }

    private int getInt(String s, int dflt) {
        ParsePosition pos;
        NumberFormat fmt = NumberFormat.getIntegerInstance();
        Number num = fmt.parse(s, pos = new ParsePosition(0));
        return num != null && pos.getIndex() == s.length() ? num.intValue() : dflt;
    }

    private float getFloat(String s, float dflt) {
        ParsePosition pos;
        NumberFormat fmt = NumberFormat.getNumberInstance();
        Number num = fmt.parse(s, pos = new ParsePosition(0));
        return num != null && pos.getIndex() == s.length() ? num.floatValue() : dflt;
    }
}

