/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

class ToolBarPanel
extends JPanel {
    private ToolBarLayout theLayout = new ToolBarLayout();
    private BevelBorder b = new BevelBorder(0);
    public static final String PB_PROP_NAME = "PAINT_BORDER";

    ToolBarPanel() {
        this.setLayout(this.theLayout);
        this.setName("toolbarPanel");
    }

    @Override
    public void paint(Graphics g) {
        int indent = 0;
        super.paint(g);
        int[] separators = this.theLayout.getRowPositions();
        Color oldColor = g.getColor();
        for (int i = 0; i < separators.length; ++i) {
            g.setColor(this.b.getShadowInnerColor(this));
            g.drawLine(indent, separators[i], this.getWidth() - indent, separators[i]);
            g.setColor(this.b.getHighlightInnerColor(this));
            g.drawLine(indent, separators[i] + 1, this.getWidth() - indent, separators[i] + 1);
        }
        g.setColor(oldColor);
    }

    class ToolBarLayout
    extends FlowLayout {
        private int[] separators;

        public ToolBarLayout() {
            super(0, 0, 0);
            this.separators = new int[0];
            this.setHgap(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int i;
                int realW = target.getSize().width;
                int commponentsPerRow = 0;
                ArrayList<Integer> hs = new ArrayList<Integer>();
                if (realW == 0) {
                    return super.preferredLayoutSize(target);
                }
                Dimension dim = new Dimension(0, 0);
                int nmembers = target.getComponentCount();
                boolean firstVisibleComponent = true;
                Insets insets = target.getInsets();
                int maxWidth = 0;
                int maxHeight = 0;
                int row = 1;
                for (i = 0; i < nmembers; ++i) {
                    Component m = target.getComponent(i);
                    Dimension d = m.getPreferredSize();
                    if (!m.isVisible()) continue;
                    dim.height = Math.max(dim.height, d.height);
                    ++commponentsPerRow;
                    if (firstVisibleComponent) {
                        firstVisibleComponent = false;
                    } else {
                        dim.width += this.getHgap();
                    }
                    int newFullWidth = dim.width + d.width + insets.left + insets.right + this.getHgap() * 2;
                    if (newFullWidth < realW || commponentsPerRow == 1) {
                        dim.width += d.width;
                        maxHeight = Math.max(maxHeight, d.height);
                    } else {
                        ++row;
                        hs.add(new Integer(dim.height));
                        dim.height += maxHeight + this.getVgap();
                        maxHeight = 0;
                        maxWidth = Math.max(maxWidth, dim.width);
                        maxHeight = Math.max(maxHeight, d.height);
                        dim.width = d.width;
                        firstVisibleComponent = true;
                        commponentsPerRow = 1;
                    }
                    if (!(m instanceof JComponent)) continue;
                    ((JComponent)m).putClientProperty(ToolBarPanel.PB_PROP_NAME, new Boolean(!firstVisibleComponent));
                }
                dim.width = Math.max(maxWidth, dim.width);
                dim.width += insets.left + insets.right + this.getHgap() * 2;
                dim.height += insets.top + insets.bottom + this.getVgap() * 2;
                this.separators = new int[hs.size()];
                for (i = 0; i < hs.size(); ++i) {
                    this.separators[i] = (Integer)hs.get(i);
                }
                return dim;
            }
        }

        synchronized int[] getRowPositions() {
            return this.separators;
        }
    }
}

