/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.util;

import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.visitor.XSSimpleTypeVisitor;
import com.sun.xml.xsom.visitor.XSTermVisitor;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import org.xml.sax.Locator;

public class SchemaTreeTraverser
implements XSVisitor,
XSSimpleTypeVisitor {
    private SchemaTreeModel model = SchemaTreeModel.getInstance();
    private SchemaTreeNode currNode = (SchemaTreeNode)this.model.getRoot();

    public SchemaTreeModel getModel() {
        return this.model;
    }

    public void visit(XSSchemaSet s) {
        for (XSSchema schema : s.getSchemas()) {
            this.schema(schema);
        }
    }

    public void schema(XSSchema s) {
        SchemaTreeNode newNode;
        if (s.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        this.currNode = newNode = new SchemaTreeNode("Schema " + s.getLocator().getSystemId(), s.getLocator());
        this.model.addSchemaNode(newNode);
        for (XSAttGroupDecl groupDecl : s.getAttGroupDecls().values()) {
            this.attGroupDecl(groupDecl);
        }
        for (XSAttributeDecl attrDecl : s.getAttributeDecls().values()) {
            this.attributeDecl(attrDecl);
        }
        for (XSComplexType complexType2 : s.getComplexTypes().values()) {
            this.complexType(complexType2);
        }
        for (XSElementDecl elementDecl : s.getElementDecls().values()) {
            this.elementDecl(elementDecl);
        }
        for (XSModelGroupDecl modelGroupDecl : s.getModelGroupDecls().values()) {
            this.modelGroupDecl(modelGroupDecl);
        }
        for (XSSimpleType simpleType2 : s.getSimpleTypes().values()) {
            this.simpleType(simpleType2);
        }
    }

    public void attGroupDecl(XSAttGroupDecl decl) {
        SchemaTreeNode newNode = new SchemaTreeNode("Attribute group \"" + decl.getName() + "\"", decl.getLocator());
        this.currNode.add(newNode);
        this.currNode = newNode;
        Iterator<XSComponent> itr = decl.iterateAttGroups();
        while (itr.hasNext()) {
            this.dumpRef(itr.next());
        }
        itr = decl.iterateDeclaredAttributeUses();
        while (itr.hasNext()) {
            this.attributeUse((XSAttributeUse)itr.next());
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void dumpRef(XSAttGroupDecl decl) {
        SchemaTreeNode newNode = new SchemaTreeNode("Attribute group ref \"{" + decl.getTargetNamespace() + "}" + decl.getName() + "\"", decl.getLocator());
        this.currNode.add(newNode);
    }

    public void attributeUse(XSAttributeUse use) {
        XSAttributeDecl decl = use.getDecl();
        String additionalAtts = "";
        if (use.isRequired()) {
            additionalAtts = additionalAtts + " use=\"required\"";
        }
        if (use.getFixedValue() != null && use.getDecl().getFixedValue() == null) {
            additionalAtts = additionalAtts + " fixed=\"" + use.getFixedValue() + "\"";
        }
        if (use.getDefaultValue() != null && use.getDecl().getDefaultValue() == null) {
            additionalAtts = additionalAtts + " default=\"" + use.getDefaultValue() + "\"";
        }
        if (decl.isLocal()) {
            this.dump(decl, additionalAtts);
        } else {
            String str = MessageFormat.format("Attribute ref \"'{'{0}'}'{1}{2}\"", decl.getTargetNamespace(), decl.getName(), additionalAtts);
            SchemaTreeNode newNode = new SchemaTreeNode(str, decl.getLocator());
            this.currNode.add(newNode);
        }
    }

    public void attributeDecl(XSAttributeDecl decl) {
        this.dump(decl, "");
    }

    private void dump(XSAttributeDecl decl, String additionalAtts) {
        XSSimpleType type = decl.getType();
        String str = MessageFormat.format("Attribute \"{0}\"{1}{2}{3}{4}", decl.getName(), additionalAtts, type.isLocal() ? "" : MessageFormat.format(" type=\"'{'{0}'}'{1}\"", type.getTargetNamespace(), type.getName()), decl.getFixedValue() == null ? "" : " fixed=\"" + decl.getFixedValue() + "\"", decl.getDefaultValue() == null ? "" : " default=\"" + decl.getDefaultValue() + "\"");
        SchemaTreeNode newNode = new SchemaTreeNode(str, decl.getLocator());
        this.currNode.add(newNode);
        this.currNode = newNode;
        if (type.isLocal()) {
            this.simpleType(type);
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void simpleType(XSSimpleType type) {
        String str = MessageFormat.format("Simple type {0}", type.isLocal() ? "" : " name=\"" + type.getName() + "\"");
        SchemaTreeNode newNode = new SchemaTreeNode(str, type.getLocator());
        this.currNode.add(newNode);
        this.currNode = newNode;
        type.visit(this);
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void listSimpleType(XSListSimpleType type) {
        XSSimpleType itemType = type.getItemType();
        if (itemType.isLocal()) {
            SchemaTreeNode newNode = new SchemaTreeNode("List", type.getLocator());
            this.currNode.add(newNode);
            this.currNode = newNode;
            this.simpleType(itemType);
            this.currNode = (SchemaTreeNode)this.currNode.getParent();
        } else {
            String str = MessageFormat.format("List itemType=\"'{'{0}'}'{1}\"", itemType.getTargetNamespace(), itemType.getName());
            SchemaTreeNode newNode = new SchemaTreeNode(str, itemType.getLocator());
            this.currNode.add(newNode);
        }
    }

    public void unionSimpleType(XSUnionSimpleType type) {
        int len = type.getMemberSize();
        StringBuffer ref = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            XSSimpleType member = type.getMember(i);
            if (!member.isGlobal()) continue;
            ref.append(MessageFormat.format(" '{'{0}'}'{1}", member.getTargetNamespace(), member.getName()));
        }
        String name = ref.length() == 0 ? "Union" : "Union memberTypes=\"" + ref + "\"";
        SchemaTreeNode newNode = new SchemaTreeNode(name, type.getLocator());
        this.currNode.add(newNode);
        this.currNode = newNode;
        for (int i = 0; i < len; ++i) {
            XSSimpleType member = type.getMember(i);
            if (!member.isLocal()) continue;
            this.simpleType(member);
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void restrictionSimpleType(XSRestrictionSimpleType type) {
        if (type.getBaseType() == null) {
            if (!type.getName().equals("anySimpleType")) {
                throw new InternalError();
            }
            if (!"http://www.w3.org/2001/XMLSchema".equals(type.getTargetNamespace())) {
                throw new InternalError();
            }
            return;
        }
        XSSimpleType baseType = type.getSimpleBaseType();
        String str = MessageFormat.format("Restriction {0}", baseType.isLocal() ? "" : " base=\"{" + baseType.getTargetNamespace() + "}" + baseType.getName() + "\"");
        SchemaTreeNode newNode = new SchemaTreeNode(str, baseType.getLocator());
        this.currNode.add(newNode);
        this.currNode = newNode;
        if (baseType.isLocal()) {
            this.simpleType(baseType);
        }
        Iterator<XSFacet> itr = type.iterateDeclaredFacets();
        while (itr.hasNext()) {
            this.facet(itr.next());
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void facet(XSFacet facet2) {
        SchemaTreeNode newNode = new SchemaTreeNode(MessageFormat.format("{0} value=\"{1}\"", facet2.getName(), facet2.getValue()), facet2.getLocator());
        this.currNode.add(newNode);
    }

    public void notation(XSNotation notation2) {
        SchemaTreeNode newNode = new SchemaTreeNode(MessageFormat.format("Notation name='\"0}\" public =\"{1}\" system=\"{2}\"", notation2.getName(), notation2.getPublicId(), notation2.getSystemId()), notation2.getLocator());
        this.currNode.add(newNode);
    }

    public void complexType(XSComplexType type) {
        SchemaTreeNode newNode = new SchemaTreeNode(MessageFormat.format("ComplexType {0}", type.isLocal() ? "" : " name=\"" + type.getName() + "\""), type.getLocator());
        this.currNode.add(newNode);
        this.currNode = newNode;
        if (type.getContentType().asSimpleType() != null) {
            SchemaTreeNode newNode2 = new SchemaTreeNode("Simple content", type.getContentType().getLocator());
            this.currNode.add(newNode2);
            this.currNode = newNode2;
            XSType baseType = type.getBaseType();
            if (type.getDerivationMethod() == 2) {
                String str = MessageFormat.format("Restriction base=\"<{0}>{1}\"", baseType.getTargetNamespace(), baseType.getName());
                SchemaTreeNode newNode3 = new SchemaTreeNode(str, baseType.getLocator());
                this.currNode.add(newNode3);
                this.currNode = newNode3;
                this.dumpComplexTypeAttribute(type);
                this.currNode = (SchemaTreeNode)this.currNode.getParent();
            } else {
                String str = MessageFormat.format("Extension base=\"<{0}>{1}\"", baseType.getTargetNamespace(), baseType.getName());
                SchemaTreeNode newNode3 = new SchemaTreeNode(str, baseType.getLocator());
                this.currNode.add(newNode3);
                this.currNode = newNode3;
                if (type.getTargetNamespace().compareTo(baseType.getTargetNamespace()) == 0 && type.getName().compareTo(baseType.getName()) == 0) {
                    SchemaTreeNode newNodeRedefine = new SchemaTreeNode("redefine", type.getLocator());
                    this.currNode.add(newNodeRedefine);
                    this.currNode = newNodeRedefine;
                    baseType.visit(this);
                    this.currNode = (SchemaTreeNode)newNodeRedefine.getParent();
                }
                this.dumpComplexTypeAttribute(type);
                this.currNode = (SchemaTreeNode)this.currNode.getParent();
            }
            this.currNode = (SchemaTreeNode)this.currNode.getParent();
        } else {
            SchemaTreeNode newNode2 = new SchemaTreeNode("Complex content", type.getContentType().getLocator());
            this.currNode.add(newNode2);
            this.currNode = newNode2;
            XSComplexType baseType = type.getBaseType().asComplexType();
            if (type.getDerivationMethod() == 2) {
                String str = MessageFormat.format("Restriction base=\"<{0}>{1}\"", baseType.getTargetNamespace(), baseType.getName());
                SchemaTreeNode newNode3 = new SchemaTreeNode(str, baseType.getLocator());
                this.currNode.add(newNode3);
                this.currNode = newNode3;
                type.getContentType().visit(this);
                this.dumpComplexTypeAttribute(type);
                this.currNode = (SchemaTreeNode)this.currNode.getParent();
            } else {
                String str = MessageFormat.format("Extension base=\"'{'{0}'}'{1}\"", baseType.getTargetNamespace(), baseType.getName());
                SchemaTreeNode newNode3 = new SchemaTreeNode(str, baseType.getLocator());
                this.currNode.add(newNode3);
                this.currNode = newNode3;
                if (type.getTargetNamespace().compareTo(baseType.getTargetNamespace()) == 0 && type.getName().compareTo(baseType.getName()) == 0) {
                    SchemaTreeNode newNodeRedefine = new SchemaTreeNode("redefine", type.getLocator());
                    this.currNode.add(newNodeRedefine);
                    this.currNode = newNodeRedefine;
                    baseType.visit(this);
                    this.currNode = (SchemaTreeNode)newNodeRedefine.getParent();
                }
                type.getExplicitContent().visit(this);
                this.dumpComplexTypeAttribute(type);
                this.currNode = (SchemaTreeNode)this.currNode.getParent();
            }
            this.currNode = (SchemaTreeNode)this.currNode.getParent();
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    private void dumpComplexTypeAttribute(XSComplexType type) {
        Iterator<XSComponent> itr = type.iterateAttGroups();
        while (itr.hasNext()) {
            this.dumpRef(itr.next());
        }
        itr = type.iterateDeclaredAttributeUses();
        while (itr.hasNext()) {
            this.attributeUse((XSAttributeUse)itr.next());
        }
    }

    public void elementDecl(XSElementDecl decl) {
        this.elementDecl(decl, "");
    }

    private void elementDecl(XSElementDecl decl, String extraAtts) {
        XSType type = decl.getType();
        String str = MessageFormat.format("Element name=\"{0}\"{1}{2}", decl.getName(), type.isLocal() ? "" : " type=\"{" + type.getTargetNamespace() + "}" + type.getName() + "\"", extraAtts);
        SchemaTreeNode newNode = new SchemaTreeNode(str, decl.getLocator());
        this.currNode.add(newNode);
        this.currNode = newNode;
        if (type.isLocal() && type.isLocal()) {
            type.visit(this);
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void modelGroupDecl(XSModelGroupDecl decl) {
        SchemaTreeNode newNode = new SchemaTreeNode(MessageFormat.format("Group name=\"{0}\"", decl.getName()), decl.getLocator());
        this.currNode.add(newNode);
        this.currNode = newNode;
        this.modelGroup(decl.getModelGroup());
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void modelGroup(XSModelGroup group2) {
        this.modelGroup(group2, "");
    }

    private void modelGroup(XSModelGroup group2, String extraAtts) {
        SchemaTreeNode newNode = new SchemaTreeNode(MessageFormat.format("{0}{1}", new Object[]{group2.getCompositor(), extraAtts}), group2.getLocator());
        this.currNode.add(newNode);
        this.currNode = newNode;
        int len = group2.getSize();
        for (int i = 0; i < len; ++i) {
            this.particle(group2.getChild(i));
        }
        this.currNode = (SchemaTreeNode)this.currNode.getParent();
    }

    public void particle(XSParticle part) {
        StringBuffer buf = new StringBuffer();
        BigInteger i = part.getMaxOccurs();
        if (i.equals(BigInteger.valueOf(-1L))) {
            buf.append(" maxOccurs=\"unbounded\"");
        } else if (!i.equals(BigInteger.ONE)) {
            buf.append(" maxOccurs=\"" + i + "\"");
        }
        i = part.getMinOccurs();
        if (!i.equals(BigInteger.ONE)) {
            buf.append(" minOccurs=\"" + i + "\"");
        }
        final String extraAtts = buf.toString();
        part.getTerm().visit(new XSTermVisitor(){

            public void elementDecl(XSElementDecl decl) {
                if (decl.isLocal()) {
                    SchemaTreeTraverser.this.elementDecl(decl, extraAtts);
                } else {
                    SchemaTreeNode newNode = new SchemaTreeNode(MessageFormat.format("Element ref=\"'{'{0}'}'{1}\"{2}", decl.getTargetNamespace(), decl.getName(), extraAtts), decl.getLocator());
                    SchemaTreeTraverser.this.currNode.add(newNode);
                }
            }

            public void modelGroupDecl(XSModelGroupDecl decl) {
                SchemaTreeNode newNode = new SchemaTreeNode(MessageFormat.format("Group ref=\"'{'{0}'}'{1}\"{2}", decl.getTargetNamespace(), decl.getName(), extraAtts), decl.getLocator());
                SchemaTreeTraverser.this.currNode.add(newNode);
            }

            public void modelGroup(XSModelGroup group2) {
                SchemaTreeTraverser.this.modelGroup(group2, extraAtts);
            }

            public void wildcard(XSWildcard wc) {
                SchemaTreeTraverser.this.wildcard(wc, extraAtts);
            }
        });
    }

    public void wildcard(XSWildcard wc) {
        this.wildcard(wc, "");
    }

    private void wildcard(XSWildcard wc, String extraAtts) {
        SchemaTreeNode newNode = new SchemaTreeNode(MessageFormat.format("Any ", extraAtts), wc.getLocator());
        this.currNode.add(newNode);
    }

    public void annotation(XSAnnotation ann) {
    }

    public void empty(XSContentType t) {
    }

    public void identityConstraint(XSIdentityConstraint ic) {
    }

    public void xpath(XSXPath xp) {
    }

    public static class SchemaTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected final JLabel iconLabel;
        protected final JLabel nameLabel;
        private boolean isSelected;
        public final Color selectedBackground = new Color(255, 244, 232);
        public final Color selectedForeground = new Color(64, 32, 0);
        public final Font nameFont = new Font("Arial", 1, 12);

        public SchemaTreeCellRenderer() {
            FlowLayout fl = new FlowLayout(0, 1, 1);
            this.setLayout(fl);
            this.iconLabel = new JLabel();
            this.iconLabel.setOpaque(false);
            this.iconLabel.setBorder(null);
            this.add(this.iconLabel);
            this.add(Box.createHorizontalStrut(5));
            this.nameLabel = new JLabel();
            this.nameLabel.setOpaque(false);
            this.nameLabel.setBorder(null);
            this.nameLabel.setFont(this.nameFont);
            this.add(this.nameLabel);
            this.isSelected = false;
            this.setOpaque(false);
            this.setBorder(null);
        }

        public final void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.isSelected) {
                g.setColor(this.selectedBackground);
                g.fillRect(0, 0, width - 1, height - 1);
                g.setColor(this.selectedForeground);
                g.drawRect(0, 0, width - 1, height - 1);
            }
            super.paintComponent(g);
        }

        protected final void setValues(Icon icon, String caption, boolean selected) {
            this.iconLabel.setIcon(icon);
            this.nameLabel.setText(caption);
            this.isSelected = selected;
            if (selected) {
                this.nameLabel.setForeground(this.selectedForeground);
            } else {
                this.nameLabel.setForeground(Color.black);
            }
        }

        public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof SchemaTreeNode) {
                SchemaTreeNode stn = (SchemaTreeNode)value;
                this.setValues(null, stn.getCaption(), selected);
                return this;
            }
            throw new IllegalStateException("Unknown node");
        }
    }

    public static class SchemaRootNode
    extends SchemaTreeNode {
        public SchemaRootNode() {
            super("Schema set", null);
        }
    }

    public static class SchemaTreeNode
    extends DefaultMutableTreeNode {
        private String fileName;
        private int lineNumber;
        private String artifactName;

        public SchemaTreeNode(String artifactName, Locator locator) {
            this.artifactName = artifactName;
            if (locator == null) {
                this.fileName = null;
            } else {
                String filename = locator.getSystemId();
                if ((filename = filename.replaceAll("%20", " ")).startsWith("file:/")) {
                    filename = filename.substring(6);
                }
                this.fileName = filename;
                this.lineNumber = locator.getLineNumber() - 1;
            }
        }

        public String getCaption() {
            return this.artifactName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }
    }

    public static final class SchemaTreeModel
    extends DefaultTreeModel {
        private SchemaTreeModel(SchemaRootNode root) {
            super(root);
        }

        public static SchemaTreeModel getInstance() {
            SchemaRootNode root = new SchemaRootNode();
            return new SchemaTreeModel(root);
        }

        public void addSchemaNode(SchemaTreeNode node) {
            ((SchemaRootNode)this.root).add(node);
        }
    }
}

