/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.ldap.sdk.controls.PersistentSearchChangeType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PersistentSearchRequestControl
extends Control {
    public static final String PERSISTENT_SEARCH_REQUEST_OID = "2.16.840.1.113730.3.4.3";
    private static final long serialVersionUID = 3532762682521779027L;
    private final boolean changesOnly;
    private final boolean returnECs;
    private final EnumSet<PersistentSearchChangeType> changeTypes;

    public PersistentSearchRequestControl(PersistentSearchChangeType changeType, boolean changesOnly, boolean returnECs) {
        super(PERSISTENT_SEARCH_REQUEST_OID, true, PersistentSearchRequestControl.encodeValue(changeType, changesOnly, returnECs));
        this.changeTypes = EnumSet.of(changeType);
        this.changesOnly = changesOnly;
        this.returnECs = returnECs;
    }

    public PersistentSearchRequestControl(Set<PersistentSearchChangeType> changeTypes, boolean changesOnly, boolean returnECs) {
        super(PERSISTENT_SEARCH_REQUEST_OID, true, PersistentSearchRequestControl.encodeValue(changeTypes, changesOnly, returnECs));
        this.changeTypes = EnumSet.copyOf(changeTypes);
        this.changesOnly = changesOnly;
        this.returnECs = returnECs;
    }

    public PersistentSearchRequestControl(PersistentSearchChangeType changeType, boolean changesOnly, boolean returnECs, boolean isCritical) {
        super(PERSISTENT_SEARCH_REQUEST_OID, isCritical, PersistentSearchRequestControl.encodeValue(changeType, changesOnly, returnECs));
        this.changeTypes = EnumSet.of(changeType);
        this.changesOnly = changesOnly;
        this.returnECs = returnECs;
    }

    public PersistentSearchRequestControl(Set<PersistentSearchChangeType> changeTypes, boolean changesOnly, boolean returnECs, boolean isCritical) {
        super(PERSISTENT_SEARCH_REQUEST_OID, isCritical, PersistentSearchRequestControl.encodeValue(changeTypes, changesOnly, returnECs));
        this.changeTypes = EnumSet.copyOf(changeTypes);
        this.changesOnly = changesOnly;
        this.returnECs = returnECs;
    }

    public PersistentSearchRequestControl(Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PSEARCH_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.changeTypes = EnumSet.copyOf(PersistentSearchChangeType.decodeChangeTypes(ASN1Integer.decodeAsInteger(elements[0]).intValue()));
            this.changesOnly = ASN1Boolean.decodeAsBoolean(elements[1]).booleanValue();
            this.returnECs = ASN1Boolean.decodeAsBoolean(elements[2]).booleanValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PSEARCH_CANNOT_DECODE.get(e), e);
        }
    }

    private static ASN1OctetString encodeValue(PersistentSearchChangeType changeType, boolean changesOnly, boolean returnECs) {
        Validator.ensureNotNull((Object)changeType);
        ASN1Element[] elements = new ASN1Element[]{new ASN1Integer(changeType.intValue()), new ASN1Boolean(changesOnly), new ASN1Boolean(returnECs)};
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    private static ASN1OctetString encodeValue(Set<PersistentSearchChangeType> changeTypes, boolean changesOnly, boolean returnECs) {
        Validator.ensureNotNull(changeTypes);
        Validator.ensureFalse(changeTypes.isEmpty(), "PersistentSearchRequestControl.changeTypes must not be empty.");
        ASN1Element[] elements = new ASN1Element[]{new ASN1Integer(PersistentSearchChangeType.encodeChangeTypes(changeTypes)), new ASN1Boolean(changesOnly), new ASN1Boolean(returnECs)};
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public Set<PersistentSearchChangeType> getChangeTypes() {
        return this.changeTypes;
    }

    public boolean changesOnly() {
        return this.changesOnly;
    }

    public boolean returnECs() {
        return this.returnECs;
    }

    @Override
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PSEARCH_REQUEST.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("PersistentSearchRequestControl(changeTypes={");
        Iterator iterator = this.changeTypes.iterator();
        while (iterator.hasNext()) {
            buffer.append(((PersistentSearchChangeType)((Object)iterator.next())).getName());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, changesOnly=");
        buffer.append(this.changesOnly);
        buffer.append(", returnECs=");
        buffer.append(this.returnECs);
        buffer.append(", isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

