/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ClientBase3.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.callback;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.omg.CORBA.ORB;

/**
 * the direct superclass of Client classes that test application client 
 * PostConstruct and injection-complete, e.g., 
 * stateless/callback/method/annotated/Client.
 */
abstract public class ClientBase3 extends ClientBase2 {
    @Resource
    private static ORB orbInClientBase3;
    
    public ClientBase3() {
    }

    @PostConstruct
    private static void postConstructInBase3() {
        addPostConstructCall(BASE3);
        //check injected fields
        if(orbInClientBase3 != null) {
            addInjectedField(orbInClientBase3);
        } else {
            TLogger.log("WARNING: ClientBase3.orbInClientBase3 has not been " +
            "initialized when checking inside ClientBase3.postConstructInBase3()");
        }
    }
    
}
