/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestBean.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.equals;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.NamingException;

@Stateless(name="test-bean")
@Remote
public class TestBean extends TestBeanBase implements TestIF {
    @Resource(name="sessionContext")
    private SessionContext sessionContext;
    
    protected SessionContext getSessionContext() {
        return sessionContext;
    }
    
    @EJB(name="cart")
    private  LocalCartIF cart;
    
    @EJB(name="cartOther")
    private  LocalCartIF cartOther;
    
    @EJB(name="shoppingCart")
    private  LocalShoppingCartIF shoppingCart;
    
    @EJB(name="shoppingCartOther")
    private  LocalShoppingCartIF shoppingCartOther;
    
    public void remove() {
    }
    
    //////////////////////////////////////////////////////////////////////
    public void selfEquals() throws TestFailedException {
        Comparator.compare(cart, cart, true, LOG_IF_OK);
        Comparator.compare(shoppingCart, shoppingCart, true, LOG_IF_OK);
    }
    
    public void selfEqualsLookup() throws TestFailedException {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Comparator.compare(cart, cart, true, LOG_IF_OK);
            Comparator.compare(shoppingCart, shoppingCart, true, LOG_IF_OK);
            
            cart = getSessionContext().lookup("cart");
            shoppingCart = getSessionContext().lookup("shoppingCart");
            Comparator.compare(cart, cart, true, LOG_IF_OK);
            Comparator.compare(shoppingCart, shoppingCart, true, LOG_IF_OK);
        } catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }
    
    public void otherEquals() throws TestFailedException {
        Comparator.compare(cart, cartOther, true, LOG_IF_OK);
        Comparator.compare(shoppingCart, shoppingCartOther, true, LOG_IF_OK);
    }
    
    public void otherEqualsLookup() throws TestFailedException {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object cartOther = ServiceLocator.lookupByShortName("cartOther");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Object shoppingCartOther = ServiceLocator.lookupByShortName("shoppingCartOther");
            Comparator.compare(cart, cartOther, this.cart, true, LOG_IF_OK);
            Comparator.compare(shoppingCart, shoppingCartOther, this.shoppingCart, true, LOG_IF_OK);
            
            cart = getSessionContext().lookup("cart");
            cartOther = getSessionContext().lookup("cartOther");
            shoppingCart = getSessionContext().lookup("shoppingCart");
            shoppingCartOther = getSessionContext().lookup("shoppingCartOther");
            Comparator.compare(cart, cartOther, this.cart, true, LOG_IF_OK);
            Comparator.compare(shoppingCart, shoppingCartOther, this.shoppingCart, true, LOG_IF_OK);
        } catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }
    
    public void differentInterfaceNotEqual() throws TestFailedException {
        Comparator.compare(cart, shoppingCart, false, LOG_IF_OK);
    }
    
    public void differentInterfaceNotEqualLookup() throws TestFailedException {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Comparator.compare(cart, shoppingCart, false, LOG_IF_OK);
        } catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    //////////////////////////////////////////////////////////////////////
    // disable methods for stateful beans
    //////////////////////////////////////////////////////////////////////
    public void otherNotEqualsLookup() throws TestFailedException {
        throw new TestFailedException("This method should not be invoked for this test.");
    }

    public void otherNotEquals() throws TestFailedException {
        throw new TestFailedException("This method should not be invoked for this test.");
    }
}
