/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: DateGreetingBean.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.generics;

import java.util.Date;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless()
public class DateGreetingBean implements GenericGreetingIF<java.util.Date> {
    
    @TransactionAttribute(TransactionAttributeType.MANDATORY)
    public java.util.Date greet(java.util.Date date) {
       return date;
    }

    /* (non-Javadoc)
     * @see com.sun.ts.tests.ejb30.common.generics.GenericGreetingIF#rolesAllowed()
     */
    @RolesAllowed("Administrator")
    public Date rolesAllowed(Date d) {
        return d;
    }

    /* (non-Javadoc)
     * @see com.sun.ts.tests.ejb30.common.generics.GenericGreetingIF#rolesAllowedNoArg()
     */
    @RolesAllowed("Manager")
    public Date rolesAllowedNoArg() {
        return new Date();
    } 
}
