 /*
  * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */
/*
 * $Id: SessionContextAllowedBeanBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.allowed;

import java.util.Properties;
import javax.ejb.SessionContext;


public abstract class SessionContextAllowedBeanBase
        implements SessionContextAllowedIF, SessionContextAllowedLocalIF {
    protected  SessionContext sessionContext;
    
    protected  Properties results;
    
    abstract public Properties runOperations(SessionContext sctx);
    
    public void timeout(javax.ejb.Timer timer) {}
    
    public void setSessionContext(SessionContext sc) {
        this.sessionContext = sc;
        this.results = null;
        this.results = runOperations(sessionContext);
    }
    
    public void clearResults() {
        if(this.results != null)
            this.results.clear();
    }
    
    public void remove() {}
    
    public Properties getResults() {
        return this.results;
    }
    
}
